/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_TEST_SDL_NEW_STATUS_H__
#define __DISPLAYER_TEST_SDL_NEW_STATUS_H__

#include <gtk/gtk.h>
#include <SDL/SDL_video.h>
#include <SDL/SDL_ttf.h>

#include <pthread.h>

#include "singit_song.h"
#include "singit_karaoke_data.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct _TestSDLNewStatus
{
	SingitSong *song;

	gboolean toggle_yz;
	gboolean print_debug;
	gboolean is_fullscreen;

	guint time;
	gint toplines;
	gint lines;

	SDL_Surface *screen;
	SDL_Surface *current_text;
	SDL_Surface *next_text;
	TTF_Font *font;

	gint jump_to_song;
	SingitKaraokeData *skd;

	gboolean sdl_inuse;

	gboolean xmms_playing;
	gboolean singit_playing;

	guint longest_line;
	
	pthread_t render_thread;
	gboolean kill_render_thread;
}
TestSDLNewStatus;

extern TestSDLNewStatus displayer_test_sdl_new_status;

void displayer_test_sdl_new_status_init(void);
void displayer_test_sdl_new_status_finish(void);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __DISPLAYER_TEST_SDL_NEW_STATUS_H__
