/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include <xmms/configfile.h>

#include "singit_debug.h"
#include "singit_macros.h"

#include "singit_config_xmms.h"
#include "singit_config.h"
#include "singit_config_private.h"

#include "singit_main.h"

#include "singit_tools.h"

/*
#define def_html_header g_strconcat("<HTML>\n<HEAD>\n  <TITLE>", _("SingIt generated Lyrics"), \
		"</TITLE>\n</HEAD>\n", "<BODY>\n<TABLE BORDER=\"0\" CELLSPACINNG=\"2\">\n", NULL)
#define def_html_tail "</TABLE>\n</BODY>\n</HTML>\n"
*/
#define def_lyric_line "<TR><TD>%t</TD><TD>%l</TD></TR>"

#define def_html_header g_strconcat("<HTML>\n<HEAD>\n  <TITLE>", _("SingIt generated Lyrics"), \
	"</TITLE>\n<STYLE TYPE=\"text/ccs\">\n<!--\nfont.lyrictag {\n  color:#CC0000;\n}\n//-->\n</STYLE>\n", \
	"</HEAD>\n<BODY>\n", NULL)
#define def_html_tail "\n</BODY>\n</HTML>\n"

SingitConfigGen *singit_config = NULL;

extern SingitStatus singit_status;

enum {
	SC_SAVE_EDITOR,
	SC_SAVE_POSITIONS,
	SC_SAVE_PLUGINS,
};

static gpointer singit_config_init_event(SingitConfigGen *scg, gpointer user_data)
{
	SingitConfigData *singit_config_data = g_malloc(sizeof(SingitConfigData));

//	g_print("Init\n");

	singit_config_data->debugEnable = FALSE;
	singit_config_data->debugLevelExcl = FALSE;
	singit_config_data->debugLevel = 9;

	singit_config_data->basePath = NULL;
	singit_config_data->constructFilename = NULL;
	singit_config_data->lyricExtension = NULL;
	singit_config_data->lyricFontName = NULL;

	singit_config_data->backgroundColor = NULL;
	singit_config_data->normalTextColor = NULL;
	singit_config_data->normalBarColor = NULL;
	singit_config_data->progressTextColor = NULL;
	singit_config_data->progressBarColor = NULL;

	singit_config_data->htmlHeader = NULL;
	singit_config_data->htmlTail = NULL;
	singit_config_data->lyricLine = NULL;

	singit_config_data->enabled_dplugins = NULL;

	singit_config_data->song = NULL;

	singit_config_data->framerateLimit = 32;

	return singit_config_data;
}

static void singit_config_free_event(SingitConfigGen *scg, SingitConfigData *cfg_data, gpointer user_data)
{
//	g_print("Free\n");

	if (cfg_data->basePath != NULL) { g_free(cfg_data->basePath); }
	if (cfg_data->constructFilename != NULL) { g_free(cfg_data->constructFilename); }
	if (cfg_data->lyricExtension != NULL) { g_free(cfg_data->lyricExtension); }
	if (cfg_data->lyricFontName != NULL) { g_free(cfg_data->lyricFontName); }

	if (cfg_data->backgroundColor != NULL) { g_free(cfg_data->backgroundColor); }
	if (cfg_data->normalTextColor != NULL) { g_free(cfg_data->normalTextColor); }
	if (cfg_data->normalBarColor != NULL) { g_free(cfg_data->normalBarColor); }
	if (cfg_data->progressTextColor != NULL) { g_free(cfg_data->progressTextColor); }
	if (cfg_data->progressBarColor != NULL) { g_free(cfg_data->progressBarColor); }

	if (cfg_data->htmlHeader != NULL) { g_free(cfg_data->htmlHeader); }
	if (cfg_data->htmlTail != NULL) { g_free(cfg_data->htmlTail); }
	if (cfg_data->lyricLine != NULL) { g_free(cfg_data->lyricLine); }
	if (cfg_data->enabled_dplugins != NULL) { g_free(cfg_data->enabled_dplugins); }

	g_free(cfg_data);
	cfg_data = NULL;
}

static void singit_config_load_event(SingitConfigGen *scg, ConfigFile* cfg_file, SingitConfigData *cfg_data, gpointer user_data)
{
	gchar *tmp;

//	g_print("Load\n");
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "hideIfNotFound", &cfg_data->hideIfNotFound))
		{ cfg_data->hideIfNotFound = FALSE; }
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "toggleYZ", &cfg_data->toggleYZ))
		{ cfg_data->toggleYZ = TRUE; }
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "showEmpty", &cfg_data->showEmpty))
		{ cfg_data->showEmpty = FALSE; }
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "autoResize", &cfg_data->autoResize))
		{ cfg_data->autoResize = TRUE; }
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "guessSyncLyrics", &cfg_data->guessSyncLyrics))
		{ cfg_data->guessSyncLyrics = TRUE; }
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "showJumpingBall", &cfg_data->showJumpingBall))
		{ cfg_data->showJumpingBall = TRUE; }
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "findOptimalFont", &cfg_data->findOptimalFont))
		{ cfg_data->findOptimalFont = FALSE; }
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "useXMMSuSleep", &cfg_data->useXMMSuSleep))
		{ cfg_data->useXMMSuSleep = FALSE; }
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "showTimeIndicator", &cfg_data->showTimeIndicator))
		{ cfg_data->showTimeIndicator = TRUE; }

#ifdef CODEDEBUG
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "debugEnable", &cfg_data->debugEnable))
		{ cfg_data->debugEnable = FALSE; }
	if (!singit_config_xmms_read(boolean, cfg_file, "SingIt", "debugLevelExcl", &cfg_data->debugLevelExcl))
		{ cfg_data->debugLevelExcl = FALSE; }
	if (!(singit_config_xmms_read(int, cfg_file, "SingIt", "debugLevel", &cfg_data->debugLevel)))
		{ cfg_data->debugLevel = 8; }
#endif

	if (!singit_config_xmms_read(string, cfg_file, "SingIt", "basePath", &(cfg_data->basePath)))
		{ cfg_data->basePath = g_strdup("~/lyrics/,~~/,~~/lyrics/"); }
	if (!singit_config_xmms_read(string, cfg_file, "SingIt", "constructFilename", &(cfg_data->constructFilename)))
		{ cfg_data->constructFilename = g_strdup("%1"); }
	if (!singit_config_xmms_read(string, cfg_file, "SingIt", "lyricExtension", &(cfg_data->lyricExtension)))
		{ cfg_data->lyricExtension = g_strdup("txt,tag"); }
	if (!singit_config_xmms_read(string, cfg_file, "SingIt", "lyricFontName", &(cfg_data->lyricFontName)))
		{ cfg_data->lyricFontName = g_strdup("-adobe-helvetica-bold-r-*-*-14-*"); }
	if (!singit_config_xmms_read(string, cfg_file, "SingIt", "enabled_dplugins", &(cfg_data->enabled_dplugins)))
		{ cfg_data->enabled_dplugins = g_strdup("libdisplayer_karaoke_window"); }

	if (!singit_config_xmms_read(color, cfg_file, "SingIt", "backgroundColor", &(cfg_data->backgroundColor)))
		{ cfg_data->backgroundColor = g_strdup("white"); }
	if (!singit_config_xmms_read(color, cfg_file, "SingIt", "normalTextColor", &(cfg_data->normalTextColor)))
		{ cfg_data->normalTextColor = g_strdup("black"); }
	if (!singit_config_xmms_read(color, cfg_file, "SingIt", "normalBarColor", &(cfg_data->normalBarColor)))
		{ cfg_data->normalBarColor = g_strdup("white"); }
	if (!singit_config_xmms_read(color, cfg_file, "SingIt", "progressTextColor", &(cfg_data->progressTextColor)))
		{ cfg_data->progressTextColor = g_strdup("white"); }
	if (!singit_config_xmms_read(color, cfg_file, "SingIt", "progressBarColor", &(cfg_data->progressBarColor)))
		{ cfg_data->progressBarColor = g_strdup("lightblue"); }

	if (!(singit_config_xmms_read(int, cfg_file, "SingIt", "configWinPosX", &cfg_data->configWinPosX)))
		{ cfg_data->configWinPosX = -1; }
	if (!(singit_config_xmms_read(int, cfg_file, "SingIt", "configWinPosY", &cfg_data->configWinPosY)))
		{ cfg_data->configWinPosY = -1; }

	if (!(singit_config_xmms_read(int, cfg_file, "SingIt", "framerateLimit", &cfg_data->framerateLimit)))
		{ cfg_data->framerateLimit = 32; }
		
	/* From lyrics exporter */
	if (!(singit_config_xmms_read(string, cfg_file, "SingIt", "htmlHeader", &cfg_data->htmlHeader))) {
		cfg_data->htmlHeader = g_strdup(def_html_header);
	}
	else {
		tmp = tools_replace_string(cfg_data->htmlHeader, "\\n", "\n");
		g_free(cfg_data->htmlHeader);
		cfg_data->htmlHeader = tmp;
	}

	if (!(singit_config_xmms_read(string, cfg_file, "SingIt", "htmlTail", &cfg_data->htmlTail))) {
		cfg_data->htmlTail = g_strdup(def_html_tail);
	}
	else {
		tmp = tools_replace_string(cfg_data->htmlTail, "\\n", "\n");
		g_free(cfg_data->htmlTail);
		cfg_data->htmlTail = tmp;
	}
	if (!(singit_config_xmms_read(string, cfg_file, "SingIt", "lyricLine", &cfg_data->lyricLine)))
		{ cfg_data->lyricLine = g_strdup(def_lyric_line); }
	if (!(singit_config_xmms_read(int, cfg_file, "SingIt", "exportMode", &cfg_data->exportMode)))
		{ cfg_data->exportMode = 0; }

	/* From lyrics editor */
	if (!singit_config_xmms_read(int, cfg_file, "SingIt", "reactionTime", &cfg_data->reactionTime))
		{ cfg_data->reactionTime = 500; }
}

static void singit_config_save_event(SingitConfigGen *scg, ConfigFile* cfg_file, SingitConfigData *cfg_data, gpointer user_data)
{
//	g_print("Save\n");

	//  * boolean values *
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "toggleYZ", cfg_data->toggleYZ);
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "showEmpty", cfg_data->showEmpty);
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "autoResize", cfg_data->autoResize);
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "hideIfNotFound", cfg_data->hideIfNotFound);
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "showJumpingBall", cfg_data->showJumpingBall);
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "guessSyncLyrics", cfg_data->guessSyncLyrics);
#ifdef CODEDEBUG
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "debugEnable", cfg_data->debugEnable);
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "debugLevelExcl", cfg_data->debugLevelExcl);
	singit_config_xmms_write(int, cfg_file, "SingIt", "debugLevel", cfg_data->debugLevel);
#endif
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "findOptimalFont", cfg_data->findOptimalFont);
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "useXMMSuSleep", cfg_data->useXMMSuSleep);
	singit_config_xmms_write(boolean, cfg_file, "SingIt", "showTimeIndicator", cfg_data->showTimeIndicator);

	/* string values */
	singit_config_xmms_write(del_string, cfg_file, "SingIt", "basePath", cfg_data->basePath);
	singit_config_xmms_write(del_string, cfg_file, "SingIt", "constructFilename", cfg_data->constructFilename);
	singit_config_xmms_write(del_string, cfg_file, "SingIt", "lyricExtension", cfg_data->lyricExtension);
	singit_config_xmms_write(del_string, cfg_file, "SingIt", "lyricFontName", cfg_data->lyricFontName);

	singit_config_xmms_write(del_string, cfg_file, "SingIt", "backgroundColor", cfg_data->backgroundColor);
	singit_config_xmms_write(del_string, cfg_file, "SingIt", "normalTextColor", cfg_data->normalTextColor);
	singit_config_xmms_write(del_string, cfg_file, "SingIt", "normalBarColor", cfg_data->normalBarColor);
	singit_config_xmms_write(del_string, cfg_file, "SingIt", "progressTextColor", cfg_data->progressTextColor);
	singit_config_xmms_write(del_string, cfg_file, "SingIt", "progressBarColor", cfg_data->progressBarColor);

	singit_config_xmms_write(del_string, cfg_file, "SingIt", "enabled_dplugins", cfg_data->enabled_dplugins);

	/* integer values */
	singit_config_xmms_write(int, cfg_file, "SingIt", "reactionTime", cfg_data->reactionTime);
	singit_config_xmms_write(int, cfg_file, "SingIt", "framerateLimit", cfg_data->framerateLimit);
	singit_config_xmms_write(int, cfg_file, "SingIt", "configWinPosX", cfg_data->configWinPosX);
	singit_config_xmms_write(int, cfg_file, "SingIt", "configWinPosY", cfg_data->configWinPosY);
}

static void singit_config_update_event(SingitConfigGen *scg, SingitConfigData *cfg_data, gpointer user_data)
{
//	g_print("Update\n");

	singit_status.config_update = TRUE;
}

static void singit_config_destroy_event(SingitConfigGen *scg, gpointer user_data)
{
//	g_print("Destroy\n");

	singit_config = NULL;
}

static void singit_config_save_part_event(SingitConfigGen *scg, ConfigFile* cfg_file, SingitConfigData *cfg_data, gint part, gpointer user_data)
{
	switch (part) {
	case SC_SAVE_POSITIONS:
//		singit_config_xmms_write(int, cfg_file, "SingIt", "editorWinPosX", cfg_data->editorWinPosX);
//		singit_config_xmms_write(int, cfg_file, "SingIt", "editorWinPosY", cfg_data->editorWinPosY);
		singit_config_xmms_write(int, cfg_file, "SingIt", "configWinPosX", cfg_data->configWinPosX);
		singit_config_xmms_write(int, cfg_file, "SingIt", "configWinPosY", cfg_data->configWinPosY);
		break;
	case SC_SAVE_PLUGINS:
		singit_config_xmms_write(del_string, cfg_file, "SingIt", "enabled_dplugins", cfg_data->enabled_dplugins);
		break;
	default:
		break;
	}
}

void singit_config_new(void)
{
	if (singit_config) { return; }

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_singit_config.c [singit_config_new]\n"));
#endif

	singit_config = SINGIT_CONFIG_GEN(singit_config_gen_new(CONFIG_FILENAME, NULL));

	gtk_signal_connect(GTK_OBJECT(singit_config), "init",
		GTK_SIGNAL_FUNC(singit_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "free",
		GTK_SIGNAL_FUNC(singit_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "load",
		GTK_SIGNAL_FUNC(singit_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "save",
		GTK_SIGNAL_FUNC(singit_config_save_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "save_part",
		GTK_SIGNAL_FUNC(singit_config_save_part_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "update",
		GTK_SIGNAL_FUNC(singit_config_update_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "destroy",
		GTK_SIGNAL_FUNC(singit_config_destroy_event), &singit_config);
}

ConfigFile* singit_config_open(void)
{
	ConfigFile *cfg;

	if (!singit_config_gen_attach(singit_config)) {
#ifdef CODEDEBUG
		DEBUG(DLV_ALL, ("Failed\n"));
#endif
		return FALSE;
	}

	cfg = xmms_cfg_open_file((gchar*) CONFIG_FILENAME);
	if (!cfg)
		cfg = xmms_cfg_new();

	return cfg;
}

gboolean singit_config_close(ConfigFile *cfg, gboolean save)
{
	if (!cfg) {
#ifdef CODEDEBUG
		DEBUG(DLV_ALL, ("Failed\n"));
#endif
		return FALSE;
	}

	if (save)
		xmms_cfg_write_file(cfg, (gchar*) CONFIG_FILENAME);
	xmms_cfg_free(cfg);

	singit_config_gen_detach(SINGIT_CONFIG_GEN(singit_config));

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("Ok\n"));
#endif

	return TRUE;
}

gboolean singit_config_save_editor(void)
{
	if (singit_config) {
#ifdef CODEDEBUG
		DEBUG(DLV_ALL, ("dlg_singit_config.c [singit_config_save_editor]\n"));
#endif
		return singit_config_gen_save_part(SINGIT_CONFIG_GEN(singit_config), SC_SAVE_EDITOR);
	}
	return FALSE;
}

gboolean singit_config_save_positions(void)
{
	if (singit_config) {
#ifdef CODEDEBUG
		DEBUG(DLV_ALL, ("dlg_singit_config.c [singit_config_save_positions] : "));
#endif
		return singit_config_gen_save_part(SINGIT_CONFIG_GEN(singit_config), SC_SAVE_POSITIONS);
	}
	return FALSE;
}

gboolean singit_config_save_plugins(void)
{
	if (singit_config) {
#ifdef CODEDEBUG
		DEBUG(DLV_ALL, ("dlg_singit_config.c [singit_config_save_plugins] : "));
#endif
		return singit_config_gen_save_part(SINGIT_CONFIG_GEN(singit_config), SC_SAVE_PLUGINS);
	}
	return FALSE;
}

gboolean singit_config_load_plugin_position(const gchar* plugin, gint *posX, gint *posY, gint *sizeX, gint *sizeY)
{
	ConfigFile *cfg;
	gboolean result = TRUE;
	gchar *load_str;

	cfg = singit_config_open();
	if (!(cfg && plugin)) { return FALSE; }

	if (posX && result) {
		load_str = g_strconcat("dp_", plugin, "_posX", NULL);
		if (!(singit_config_xmms_read(int, cfg, "SingIt", load_str, posX)))
			{ result = FALSE; }
		g_free(load_str);
	}

	if (posY && result) {
		load_str = g_strconcat("dp_", plugin, "_posY", NULL);
		if (!(singit_config_xmms_read(int, cfg, "SingIt", load_str, posY)))
			{ result = FALSE; }
		g_free(load_str);
	}

	if (sizeX && result) {
		load_str = g_strconcat("dp_", plugin, "_sizeX", NULL);
		if (!(singit_config_xmms_read(int, cfg, "SingIt", load_str, sizeX)))
			{ result = FALSE; }
		g_free(load_str);
	}

	if (sizeY && result) {
		load_str = g_strconcat("dp_", plugin, "_sizeY", NULL);
		if (!(singit_config_xmms_read(int, cfg, "SingIt", load_str, sizeY)))
			{ result = FALSE; }
		g_free(load_str);
	}

	singit_config_close(cfg, FALSE);
	return result;
}

gboolean singit_config_save_plugin_position(const gchar* plugin, gint posX, gint posY, gint sizeX, gint sizeY)
{
	ConfigFile *cfg;
	gchar *save_str;

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_singit_config.c [singit_config_save_plugin_position] :\n"));
#endif

	if (!plugin) { return FALSE; }

	cfg = singit_config_open();
	if (!cfg) { return FALSE; }

	if (posX >= 0) {
		save_str = g_strconcat("dp_", plugin, "_posX", NULL);
		singit_config_xmms_write(int, cfg, "SingIt", save_str, posX);
		g_free(save_str);
	}

	if (posY >= 0) {
		save_str = g_strconcat("dp_", plugin, "_posY", NULL);
		singit_config_xmms_write(int, cfg, "SingIt", save_str, posY);
		g_free(save_str);
	}

	if (sizeX >= 0) {
		save_str = g_strconcat("dp_", plugin, "_sizeX", NULL);
		singit_config_xmms_write(int, cfg, "SingIt", save_str, sizeX);
		g_free(save_str);
	}

	if (sizeY >= 0) {
		save_str = g_strconcat("dp_", plugin, "_sizeY", NULL);
		singit_config_xmms_write(int, cfg, "SingIt", save_str, sizeY);
		g_free(save_str);
	}

	return singit_config_close(cfg, TRUE);
}
