/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Based on xmms visualization plugin mechanism */


#ifndef __SINGIT_PLUGIN_SCANNER_H__
#define __SINGIT_PLUGIN_SCANNER_H__

#include <glib.h>

// * The plugins_init and plugins_finish functions are nested.
// * In other words, you have to  call plugins_finish as often as plugins_init!
// * This has to be done, because you can open the configuration without
// * enabling the plugin
// * The following sequence of functions represents the right way

// * Creates the plugin list by scanning for plugin libs *
void plugins_init(void);
// * Enables the selected displayer plugins and increases the attachments *
gboolean plugins_initialize(void);

// * Shut all plugins down *
gboolean plugins_finalize(void);
// * Unloads all libraries *
void plugins_finish(void);

// * Is the plugin on the enabled list? : plugin < 0: any
gboolean is_dis_plugin_enabled(gint plugin);
// * Is the plugin running? : plugin < 0: any
gboolean is_dis_plugin_running(gint plugin);

// * Return the list of all found displayer plugin structs
// * BE CAREFULL -  it's the real list!!!
GList *get_dis_plugin_list(void);

// * Set the status of the plugin and run the init / finish handlers
gboolean set_dis_plugin_status(gint plugin, gboolean enable);

// * Create a string of enabled plugins  *
// * Restore plugins from this string *
gchar *dis_plugin_stringify_enabled_list(void);
void dis_plugin_enable_from_stringified_list(gchar *list);

// * Calls the plugin funtion from the enabled list *
void dis_plugin_show(gint plugin, SingitSong *cur_song);
void dis_plugin_hide(gint plugin, SingitSong *cur_song);
void dis_plugin_toggle(gint plugin, SingitSong *cur_song);
void dis_plugin_update(gint plugin);
void dis_plugin_playback_start(gint plugin);
void dis_plugin_playback_stop(gint plugin);
void dis_plugin_about(gint plugin);
void dis_plugin_configure(gint plugin);

void dis_plugin_render_freq(gint16 freq_data[2][256]);
void dis_plugin_render_pcm(gint16 pcm_data[2][512]);

// * Tell all enabled plugins the actual time / song *
void plugins_set_time(gint time, SingitSong *cur_song, GList *real_next);

#endif // __SINGIT_PLUGIN_SCANNER_H__
