/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdlib.h>
#include <stdio.h>

#include "singit_sound_precalcs.h"
#include "singit_sound_precalcs_private.h"

static gfloat calc_level(gint16 *freq_data)
{
	gint16 c = 0;
        gdouble level = 0;
        for(c = 0; c < 256; c++)
        {
                level = level + (gdouble) freq_data[c];
        }
        if(level > (512*256))
        {
                level = 512*256;
        }
	return (gfloat)(level / (512 * 256));
}

void sigit_sound_precalcs_level(SingitSoundPrecalcs *ssp, gint16 *freq_data)
{
	g_return_if_fail(ssp != NULL);
	g_return_if_fail(freq_data != NULL);

	ssp->level[0] = calc_level(freq_data);
	ssp->level[1] = calc_level(&freq_data[255]);
	ssp->level[2] = (ssp->level[0] + ssp->level[1]) / 2;
}

#define STOP_SPEED 128

void sigit_sound_precalcs_beat (SingitSoundPrecalcs *ssp, gint16 *pcm_data)
{
	static gboolean last_beat = FALSE;
	static char	beat_sensitive = 3;
	static int 	beatvar = 0;
	static int 	totalbeat = 0; // nombre de beats par seconds
	static int 	speedvar = 0; // speed des particules
	static guint32  cycle;
	static int      speed;

	gboolean beat;
	int             incvar; // volume du son
	int             accelvar; // acceleration des particules
	int             i;
	guint32         newvit;

	g_return_if_fail(ssp != NULL);
	g_return_if_fail(pcm_data != NULL);

	incvar = 0 ;
	for (i = 0; i < 512; i++)
	{
		if (incvar < pcm_data[i]) incvar = pcm_data[i];
	}

	accelvar = incvar / 5000;
	if (speedvar > 5) {
		accelvar--;
		if (speedvar>20) accelvar --;
		if (speedvar>40) speedvar = 40;
	}
	accelvar --;
	speedvar += accelvar ;

	if (speedvar < 0) speedvar = 0;
	if (speedvar > 40) speedvar = 40;

	if ((accelvar > beat_sensitive) || (accelvar < (-1 * beat_sensitive)))
	{
		if (last_beat == FALSE) {
			totalbeat++;
			beat = TRUE;
			last_beat = TRUE;
		}
		else { beat = FALSE; }
	}
	else {
		beat = FALSE;
		last_beat = FALSE;
	}

	if ((accelvar > beat_sensitive) || (accelvar < (-1 * beat_sensitive)))
	{
		beatvar++ ;

		newvit = STOP_SPEED - speedvar / 2 ;

		if (((cycle % 12) == 0) && ((rand() % 3) == 0))
		{
			speed = STOP_SPEED - 2;
		}

		if (newvit < (guint) speed) // on accelere
		{
			if (((newvit < STOP_SPEED - 7) && (speed < STOP_SPEED - 6) && (cycle % 3 == 0)))
			{
				speed = STOP_SPEED - 1;
			}
			else {
				speed = (newvit + speed * 4) / 5;
			}
		}
	}

	if ((speedvar < 1) && (speed < STOP_SPEED - 4) && (cycle % 16 == 0))
	{
		speed += 3;
		beatvar = 0;
	}

	if ((cycle % 73 == 0) && (speed < STOP_SPEED - 5)) {
		speed ++;
	}

	cycle++;

	if ((cycle % 100) == 0)
	{
		if (totalbeat > 15) { beat_sensitive++; }
		else {
			if ((totalbeat == 0) && (beat_sensitive > 1))
				{ beat_sensitive--; }
		}
		totalbeat = 0;
		cycle = 0;
	}

	ssp->beat = beat;
}


void sigit_sound_precalcs_freq(SingitSoundPrecalcs *ssp, gint16 *freq_data)
{
	g_return_if_fail(ssp != NULL);
	g_return_if_fail(freq_data != NULL);

	sigit_sound_precalcs_level(ssp, freq_data);
}

void sigit_sound_precalcs_pcm(SingitSoundPrecalcs *ssp, gint16 *pcm_data)
{
	g_return_if_fail(ssp != NULL);
	g_return_if_fail(pcm_data != NULL);

	sigit_sound_precalcs_beat(ssp, pcm_data);
}
