/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_TAG_MANAGER_PRIVATE_H__
#define __SINGIT_TAG_MANAGER_PRIVATE_H__

#include "mpeg_header_info.h"

#include <id3.h>
#include <vorbis/vorbisfile.h>

typedef enum {
	IT_MPEG,
	IT_VORBIS,
	IT_ID3
}
InfoType;

typedef struct _Id3DlgStatus {

	gboolean useId1;
	gboolean beStrict;
	guint id3v2Usage;

	InfoType info_type;
	
	ID3Tag *id3tag;
	MPEGHeaderInfo *mpeg_info;

	OggVorbis_File *ov_file;
}
Id3DlgStatus;


ID3Tag* get_mpeg_file_info(gchar *file_name, 
	gboolean *is_writeable, MPEGHeaderInfo **info);

void append_mpeg_info_page(GtkWidget *notebook, 
	GtkWidget *window, ID3Tag *id3, MPEGHeaderInfo *info);

OggVorbis_File* get_oggvorbis_file_info
	(gchar *file_name, gboolean *is_writeable);

void append_oggvorbis_info_page
	(GtkWidget *notebook, GtkWidget *window, OggVorbis_File *vf);

void append_hierachial_view_page(GtkWidget *notebook, GtkWidget *window);


gchar* transadd(const gchar *trans_str, const gchar *add);

gchar* convert_to_utf8(const gchar *string);
gchar* convert_from_utf8(const gchar *string);

#endif  // __SINGIT_TAG_MANAGER_PRIVATE_H__
