#!/bin/sh
#

function usage()
{
	echo
	echo "Usage: jmg.sh [options]"
	echo "Options:"
	echo "  -g    Set ghhtp dir"
	echo "  -h    Disable home install"
	echo "  -o    Disable OpenGL"
	echo "  -p    Enable optimizations"
	echo "  -q    Disable lyrix queries"
	echo "  -t    Omit test plugins"
	echo "  -w    Normal warnings"
	echo
}

function evl_echo()
{
	if test "$1" != ""
	then
		echo "        $1"
	fi
}

OPENGL="--enable-opengl"
HOMEINST="--enable-install-home"
OPTIMI="--disable-optimizations"
TESTDIS="--enable-test-plugins"
WARNS="--enable-more-warnings"
GHTTP="--with-ghttp-prefix=/opt/gnome"
QUERY=""

# Parse command line options
while getopts ghopqtw? opt ; do
	case "$opt" in
		g) GHTTP="" ;;
		h) HOMEINST="" ;;
		o) OPENGL="" ;;
		p) OPTIMI="" ;;
		q) QUERY="--disable-lyrix-query" ;;
		t) TESTDIS="" ;;
		w) WARNS="" ;;
		?) usage; exit ;;
	esac
done

CONFIG="${OPENGL} ${TESTDIS} ${OPTIMI} ${WARNS} ${HOMEINST} ${GHTTP}"

echo
echo "This script runs configure with the following settings"
echo " ./configure"
evl_echo "${OPENGL}"
evl_echo "${TESTDIS}"
evl_echo "${OPTIMI}"
evl_echo "${WARNS}"
evl_echo "${HOMEINST}"
evl_echo "${GHTTP}"
evl_echo "${QUERY}"
echo
echo "<CTRL + C> to abort - <Return> to continue"

read TMP

./configure ${CONFIG}

echo
echo "Press <Return> to compile"
read TMP
echo

make

echo
echo "Press <Return> to install"
read TMP
echo

make install

exit 0
