#include "Prefs.h"

#include "CEgIOFile.h"
#include "EgOSUtils.h"

#ifdef EG_MAC
#include <Files.h>
#include <Folders.h>
#endif

#ifdef EG_POSIX
#include <stdlib.h>
#endif

Prefs::Prefs() {

	mSysStored	= false;
	mDirty		= true;
}

void Prefs::ErasePrefData() {

	mDirty 		= true;
	mPrefs.Clear();
}

void Prefs::SetFilename( const char* inPrefsName, bool inSysStored ) {

	mSysStored	= inSysStored;
	mDirty		= true;

	mPrefName.Assign( inPrefsName );

#ifdef EG_MAC
  	short int	theVRef;
	long		theDirID;
	short		theErr;
	FSSpec		prefSpec;

	if ( inSysStored ) {
		theErr = ::FindFolder( kOnSystemDisk, kPreferencesFolderType, kCreateFolder, &theVRef, &theDirID );
		if ( theErr != noErr ) {
			theVRef = 0;
			theDirID = 0;
		}
	}
	else {
		theVRef		= ( (FSSpec*) EgOSUtils::sAppSpec.OSSpec() ) -> vRefNum;
		theDirID	= ( (FSSpec*) EgOSUtils::sAppSpec.OSSpec() ) -> parID;
	}

	::FSMakeFSSpec( theVRef, theDirID, mPrefName.getPasStr(), &prefSpec );
	mFileSpec.Assign( &prefSpec, MCC4_TO_INT( "TEXT" ) );
#elif EG_WIN
	// Note: mSysStored == true is unimplmented--just continue as mSysStored == false
	// (yah, right--like i'm gonna even *think* about touching the registry!)
	UtilStr prefPath;
	prefPath.Assign( (char*) EgOSUtils::sAppSpec.OSSpec() );
	prefPath.Append( mPrefName );
	mFileSpec.Assign( prefPath.getCStr(), 0 );
#elif EG_POSIX
	mSysStored	= inSysStored;
	mDirty		= true;

	if ((inPrefsName != NULL) && (inPrefsName[0] == '~')) {
		mPrefName.Assign( getenv( "HOME" ) );
		mPrefName.Append( &inPrefsName[1] );
	}
	else { mPrefName.Assign( inPrefsName ); }

	mFileSpec.Assign( mPrefName.getCStr(), 0 );
#endif
}

CEgErr Prefs::Load() {

	CEgIFile iFile;

	mPrefs.Clear();

	if ( mPrefs.SetArgs( &mFileSpec ) )
		mDirty = false;

	return iFile;
}

CEgErr Prefs::Store() {

	CEgIOFile oFile;

	if ( mDirty ) {
		long origType = CEgIOFile::sCreatorType;
#if EG_MAC
		CEgIOFile::sCreatorType = MCC4_TO_INT( "ttxt" );
#elif EG_WIN || EG_POSIX
		CEgIOFile::sCreatorType = MCC4_TO_INT( "????" );
#endif
		oFile.open( &mFileSpec );

		if ( oFile.noErr() ) {

			mPrefs.ExportTo( &oFile, true );
			oFile.Writeln();
		}
		mDirty = false;
		CEgIOFile::sCreatorType = origType;
	}

	return oFile;
}

void Prefs::SetPref( long inID, const UtilStr& inData ) {

	if ( ! mDirty ) {
		const UtilStr* str;

		str = mPrefs.GetStr( inID );
		if ( str ) {
			if ( str -> compareTo( &inData ) )
				mDirty = true; }
		else
			mDirty = true;
	}

	mPrefs.SetArg( inID, inData );
}

void Prefs::SetPref( long inID, long inData ) {

	bool exists;
	long num;

	if ( ! mDirty ) {

		exists = mPrefs.GetArg( inID, num );
		if ( ! exists || num != inData )
			mDirty = true;
	}

	mPrefs.SetArg( inID, inData );
}
