
#ifndef __SDL_VIDEO_DEVICE_H__
#define __SDL_VIDEO_DEVICE_H__

#include "VFrameBuffer.h"
#include "VideoDevice.h"
#include "PixPort.h"

#include <SDL/SDL_video.h>

/* This class represents a framebuffer that will be a video outlet.   */

class SDL_VideoDevice : public VideoDevice, public VFrameBuffer {

public:
	SDL_VideoDevice( bool inForceFullRedraws );

	void		SetOutput( SDL_Surface *surface );

	virtual int	GetDepth()	{ return mDepth; }

protected:
	virtual void	TransferBits( PixPort& inFrame, Rect& inSrce, Rect& inDest );

	virtual void	BeginFrame_Self();
	virtual void	EndFrame_Self();

	SDL_Surface 	*mSurface;
};

#endif // __SDL_VIDEO_DEVICE_H__
