

#ifndef __WHITE_CAP_H__
#define __WHITE_CAP_H__


#include "WhiteCapWorld.h"
#include "ConsolePixPort.h"
#include "FileSpecList.h"
#include "Prefs.h"
#include "XLongList.h"
#include "CEgIOFile.h"
#include "GeneralFileSys.h"
#include "PluginGlue.h"


#if EG_MAC
#include <Files.h>
#include <Events.h>
#endif

// Capture codes
#define CAPTURE_SAMPLE	55
#define CAPTURE_CONFIG_CHANGE	56
#define CAPTURE_CONFIG_MORPH	57


class WhiteCap : public PluginGlue {

public:
	// Once you make a new WhiteCap, don't do anything else until you call SetPort() or SetWinRect()
	WhiteCap( long inHostVers, void* inRefCon = NULL );
	~WhiteCap();

	// Draws the plugin to the screen, at the time index used in RecordSample().  The part of the
	// screen refreshed is the union of the changed rect since the last call to Draw() and
	// any rects passed to RefreshRect() since the last call to Draw().
	void			Draw();

	virtual void		CommandClick();

	void			ExportQT( CEgIFile* inStream );

protected:
	// Sets each pref...
	virtual void		SetPrefsFactory();
	virtual void		LoadPrefs( Prefs& inPrefs );
	virtual void		SavePrefs( Prefs& inPrefs );

	virtual void		RefreshRect( Rect* inRect );

	virtual void		DoFrame();

	void			EnableSlideShow();
	void			SelectConfig();

	FileSysIDList		mConfigs;
	int			mCurConfigNum;
	UtilStr			mCurConfigName;
	XLongList		mConfigPlayList;
	ConsolePixPort		mPort;
	float 			mNextShapeChange;
	bool			mSlideShowOn;
	bool			mNewConfigNotify;

	// Track text related
	UtilStr			mTrackText;
	Rect			mTrackTextRect;
	int			mTrackTextDur;			// (Pref)
	float			mTrackTextEndT;
	virtual void		StartTrackText();
	void			ManageTrackText();

	virtual void		MakeStateCmdLine( UtilStr& outCmdList );

	virtual PixPort*	Screenshot_PixPort()		{ return &mPort; }

	Expression		mMorphDurationExpr;
	Expression		mSlideShowIntervalExpr;
	Expression		mMorphTransExpr;

#define MAX_WORLDS		10
	long			mNumWorlds;
	WhiteCapWorld*		mWorld[ MAX_WORLDS ];

	void			LoadConfig( int inConfigNum, float inMorphDur );
	void			LoadNextConfig();

	//  Chops up mDispRect into smaller rects, making a rect for each config to be shown.
	void			ResizeWorlds();

	virtual	bool		ExecuteCmd( UtilStr& inCmd );

	virtual void  		PortResized( long inX, long inY );

	virtual bool		ExecuteCmdCode( long inCode, bool inShiftKey );
	virtual void		ShowHelp();

	virtual void		TimeIndexHasChanged( long inOldBase_MS );
};

#endif // __WHITE_CAP_H__
