/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_CONFIG_H__
#define __SINGIT_CONFIG_H__

#include <singit/song.h>
#include <singit/config_xmms.h>

#include "singit_main_status.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct _SingitConfigData {

	// Changed by user - restored
	gboolean     toggleYZ;		// Instead of Z use Y (german keyboard "fix")
	gboolean     showEmpty;		// Show the selection on empty lines
	gboolean     autoResize;	// Resize the window automagically
	gboolean     hideIfNotFound;	// Hide the lyric window, if no lyrics were found
	gboolean     showJumpingBall;
	gboolean     guessSyncLyrics;
	gboolean     findOptimalFont;
	gboolean     useXMMSuSleep;
	gboolean     showTimeIndicator;

        gchar       *basePath;
        gchar       *constructFilename;	// Not in use yet - can't get id3 information
	gchar       *lyricExtension;
	gchar       *lyricFontName;

	gchar       *backgroundColor;
	gchar       *normalTextColor;
	gchar       *normalBarColor;
	gchar       *progressTextColor;
	gchar       *progressBarColor;

	gboolean     debugEnable;
	gboolean     debugLevelExcl;
	gint         debugLevel;

	gboolean     framerateLimitEnabled;
	guint        framerateLimit;	// Limit the framerate (0 = no limit)

	// From lyrics editor
	gint         reactionTime;
	gchar       *submittingAuthor;

	gboolean     httpProxyUsage;
	gchar       *httpProxyServer;
	gint         httpProxyPort;
	gchar       *httpProxyUser;
	gchar       *httpProxyPasswd;
	gboolean     httpProxySavePasswd;

	// From HTML exporter
	gchar       *htmlHeader;
	gchar       *htmlTail;
	gchar       *lyricLine;
	gint         exportMode;

	// Changed by plugin dialogs - restored
	gint         configWinPosX;
	gint         configWinPosY;

	// Plugin globals
	gchar       *enabled_dplugins;
}
SingitConfigData;

gboolean singit_config_load_plugin_position
	(const gchar* plugin, gint *posX, gint *posY, gint *sizeX, gint *sizeY);
gboolean singit_config_save_plugin_position
	(const gchar* plugin, gint posX, gint posY, gint sizeX, gint sizeY);

ConfigFile* singit_config_open(void);
gboolean singit_config_close(ConfigFile *cfg, gboolean save);

// * creates new config data includes attachment *
SingitConfigGen* singit_config_new(void);

// * Just saves special data *
gboolean singit_config_save_editor(void);
gboolean singit_config_save_positions(void);
gboolean singit_config_save_plugins(void);

void singit_config_show_author(void);

#define GET_SCD \
	((SingitConfigData *) \
		singit_config_gen_get_data(STATUS->config))

#ifdef __cplusplus
}
#endif // __cplusplus

#endif  // __SINGIT_CONFIG_H__
