/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_OPENGL_CONFIG_H__
#define __DISPLAYER_OPENGL_CONFIG_H__

#include "singit/config_gen.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct _OpenGLConfigData {

	gint sensitivityBassLow;
	gint sensitivityBassHigh;
	gboolean directApply;
	gboolean displayParticles;

	gboolean debugEnable;
	gboolean isLoaded;
	guint attachments;

	gint winPosX, winPosY;

	gboolean gblToggleYZ;
}
OpenGLConfigData;

SingitConfigGen *displayer_opengl_config_new(void);

#define GET_OGLCD ((OpenGLConfigData *) \
	singit_config_gen_get_data(STATUS->config))

#define DEBUG(x) \
	do { if (STATUS && GET_OGLCD && GET_OGLCD->debugEnable) debug x; } while (0);

#define GET_CFG(val) (GET_OGLCD->forceGlobals == TRUE) \
	? (GET_SCD->val) : GET_OGLCD->val

#ifdef __cplusplus
}
#endif // __cplusplus

#endif  // __DISPLAYER_OPENGL_CONFIG_H__
