
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <errno.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdlib.h>

//NO WE USE g_assert for portability
//#include "assert.h"

#include <gtk/gtk.h>

#include "gtk-meta.h"

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include "gdk-pixbuf-extra.h"

#include "gtktopdata.h"

#include "libmorph/warp.h"
#include "libmorph/warp2.h"
#include "libmorph/warp-gtk.h"
#include "libmorph/resample.h"
#include "libmorph/mesh.h"

#include "callbacks.h"
#include "interface.h"
#include "support.h"
//#include "pixmaps.h"
#include "mesh-gtk.h"
#include "utils.h"
#include "main.h"
#include "settings.h"
#include "dialogs.h"
#include "loadsave.h"
#include "utils.h"

#if HAVE_LIBPLY_H
#include "../plyview/bind.h"
#endif

extern gtkmorph_status_t   *sp ;




/************************************************************************

************************************************************************

 load/save hooks 

 see  on_ok_button1_realize ()

************************************************************************

************************************************************************/

inline  void 
showerr(const char *file, const char *msg)
{
  char *s = 
	g_strdup_printf( msg, file, strerror(errno));
			
  show_error(s  );
  g_free(s);
}

gboolean is_null(const gchar *s)
{
  if(strlen(s) == 0)
    {
      show_error(_("please provide a filename"));
      return TRUE;
    }
  return FALSE;
}
/*****************************************************************************/

gboolean save_session(int ignored,
		      const char *file)
{
  FILE *f;
  int lp;
#ifdef HAVE_UNISTD_H
  int c;
  extern gchar *session_name;
  char cwd[PATH_MAX];
  getcwd(cwd,PATH_MAX);
  c=strlen(cwd);
  /* delete the common initial part of cwd and filename */
#define REDUCE_CWD(A) ( (strlen(A)>=(c+1) && 0==strncmp((A),cwd,c) && (A)[c] == '/' ) ? (A)+c+1:(A))
#else
#define REDUCE_CWD(A) (A)
#endif
 
  if(is_null(file)) return FALSE;

  if((f=fopen(file, "w"))==NULL) {
    showerr(file, _("could not open file '%s' for write: %s") );
    return FALSE; 
  }

  if(session_name) g_free(session_name);
  session_name=g_strdup(file);

  fprintf(f,"<gtkmorph session>\n");
#ifdef HAVE_UNISTD_H
  fprintf(f,"<cwd>\n%s\n</cwd>\n",cwd);
#endif
 for(lp=1;lp<=MAX_WINS; lp++)
    if(sp->im_widget[lp] != NULL)
      {
	if(sp->im_filename_in[lp]) {
	  fprintf(f,"<image>\n");
	  fprintf(f,"<image file in>\n%s\n</image file in>\n",
		  REDUCE_CWD(sp->im_filename_in[lp]));
	  fprintf(f,"<preserve aspect>\n%d\n</preserve aspect>\n",
		  image_settings_get_value("preserve aspect ratio",lp));
	  if(sp->im_mesh_filename[lp]) 
	    fprintf(f,"<mesh file>\n%s\n</mesh file>\n",
		    REDUCE_CWD(sp->im_mesh_filename[lp]));
	  fprintf(f,"<morph factors>\n%f %f\n</morph factors>\n",
		  sp->mf.im_warp_factor[lp],
		  sp->mf.im_dissolve_factor[lp]);
	  fprintf(f,"</image>\n");
	}
      }
  fprintf(f,"<resulting_size>\n%d %d\n</resulting_size>\n",
	 sp->resulting_width,sp->resulting_height);
  fprintf(f,"</gtkmorph session>\n");
  fclose(f);
  return TRUE;
}

static inline void de_n(char *s)
{ int l=strlen(s);  if(s[l-1]=='\n') s[l-1]=0; }

static inline void close_tag(FILE *f)
{
  char s[PATH_MAX+1];
  fgets(s,PATH_MAX,f);
  if( s[0]!='<' || s[1]!='/') {
    de_n(s);
    g_warning("malformed session: '%s' is not a closing tag",s);
  } 
}


static gboolean load_session_stanza(FILE *f)
{
  int aspect=-3333, equal=0;
  float a=-3333.3,b=-3333.3;
  const  int lens=PATH_MAX;
  char s[lens+1],  imagename[lens+1], meshname[lens+1];

  imagename[0]=meshname[0]=0; 
  fgets(s,lens,f); de_n(s); /* tag? */
  while( !feof(f) && 0!=strcmp(s,"</image>") ) {
    /********* image tags loop *********/
    if( s[0]!='<' || s[1]=='/' ) {
      /* attemp syncronization */
      g_warning("malformed session: '%s' is not an opening tag in image",s);
    } else
      if(0==strcmp(s,"<image file in>")) {
	fgets(imagename,lens,f); /* file name */
	de_n(imagename); close_tag(f);
      } else
	if( 0==strcmp(s,"<mesh file>")) {
	  fgets(meshname,lens,f);
	  de_n(meshname); close_tag(f);
	} else
	  if( 0==strcmp(s,"<preserve aspect>")) {
	    fgets(s,lens,f); 
	    sscanf(s,"%d",&aspect);     close_tag(f);  
	  } else
	    if( 0==strcmp(s,"<morph factors>")) {
	      fgets(s,lens,f); 
	      sscanf(s,"%f %f",&a,&b);  close_tag(f);
	    } else
	      g_warning("session file: line '%s' was unrecognized in image\n",s);
    fgets(s,lens,f); de_n(s);/* tag? */
  }    /********* end image tags loop *********/
      
  if(imagename[0]==0) {
    g_warning("malformed session: no image filename");
    return FALSE;
  }
  {/* look if it has already been loaded */
    int empty=0;
    { 
      int lp;
      /* FIXME < or <= ?? */
      for(lp=1;lp<MAX_WINS; lp++) {
	if(sp->im_widget[lp] != NULL) {	  
	  if(sp->im_filename_in[lp] &&
	     0==strcmp(sp->im_filename_in[lp],imagename)) {
	    equal=lp;	    
	  }
	  /* if the user has not used this image... we reuse it */
	  if(!image_used(lp)) { if(!empty) empty=lp; }
	} else  {
	  if(!empty) empty=lp; 
	}
      }
    }
    /* if not existent, create it now */
    if(equal==0) {
      if(empty==0) {
	show_error(_("can't reload the full session-no more available images"));
	return FALSE;
      } else {
	if(sp->im_widget[empty] == NULL) {
	  sp->max_wins++;
	  create_and_show_image_win(empty);	 
	}
      }
    }
    /* if not loaded, load it now */
    if(equal==0) {
      load_image_from_file(empty,imagename);
      equal=empty;
    }
  }
  if(equal==0) return TRUE;
  /* aspect */
  if(aspect!=-3333)
    image_settings_set_value("preserve aspect ratio",equal,aspect);

  /* mesh file */    
  if(sp->im_mesh_filename[equal]==NULL ||
     0!=strcmp(sp->im_mesh_filename[equal],meshname))
    load_mesh_from_file(equal,meshname);
    
  if(a!=-3333.3) { 
    sp->mf.im_warp_factor[equal]=a;
    sp->mf.im_dissolve_factor[equal]=b;
  }

  gtk_widget_show(sp->im_widget[equal]);
  return TRUE;
}



gboolean load_session(int ignored,
		      const char *file)
{
  FILE *f;  
  const  int lens=PATH_MAX;
  char s[lens+1], cwd[lens+1];

  if(is_null(file)) return FALSE;

  cwd[0]=0;
  if((f=fopen(file, "r"))==NULL) {
    showerr(file, _("could not open file '%s' for read: %s"));
    return FALSE; 
  }
  { int e;
#if GLIB_MAJOR_VERSION == 1
    gchar * dir = g_dirname(file);
#else
    gchar * dir = g_path_get_dirname (file);
#endif
    e=chdir(dir);
    if(e) g_critical("cannot ch dir to %s : %s",dir,strerror(e));
    g_free(dir);
  }
  fgets(s,lens,f);
  if(strcmp(s,"<gtkmorph session>\n")) {
    show_error( _("parsing of session failed at first header!") );
    return FALSE;
  }
  fgets(s,lens,f);  de_n(s);
  while(!feof(f) && strcmp(s,"</gtkmorph session>") ) {
    /* attemp syncronization    */
    if( s[0]!='<' || s[1]=='/' ) {
      /* attemp syncronization */
      g_warning("malformed session: '%s' is not an opening tag",s);
    } else
      if( 0==strcmp(s,"<cwd>") ) {
	fgets(cwd,lens,f); de_n(cwd);      
	if(chdir(cwd)) {
	  g_warning("Cannot change to CWD %s\n   as specified in the session file",cwd);
	  perror("");
	}
	close_tag(f);	
      } else
	if( 0==strcmp(s,"<resulting_size>") ) {
	  fgets(s,lens,f);
	  sscanf(s,"%d %d",
		 &sp->resulting_width_sp,&sp->resulting_height_sp);
	  spinbutton_res_set();
	  on_resulting_apply_clicked(NULL,NULL);
	  close_tag(f);
	} else 
	  if ( 0==strcmp(s,"<image>") ) {
	    load_session_stanza(f);
	  } 
	  else
	    g_warning("session file: line '%s' was unrecognized\n",s);
    fgets(s,lens,f);de_n(s);
  }

  if(strcmp(s,"</gtkmorph session>")) {
    show_error(_("parsing of session failed"));
    return FALSE;
  }
  // WHY? setup_handlebox_factors();
  fclose(f);
  return TRUE;
}








gboolean load_image_from_file_not_ply(int lp,
				      const char *file)
{
  GdkPixbuf      *impixfile;

#if GTK_MAJOR_VERSION < 2  
  impixfile= gdk_pixbuf_new_from_file(file);
  if (impixfile ==NULL)    {
      showerr(file,_("\
the attempt to load the image file %s as produced error: %s"));
      return FALSE;
    }
#else
  {
    GError *err=NULL;
    impixfile= gdk_pixbuf_new_from_file(file,&err);        
    if(err)      {
	show_error((err)->message);g_error_free (err);
	return FALSE;
      }
  }
#endif

    {
#ifndef RESCALE_RELOAD_LESS_MEM
      destroy_pixbuf(lp,PIXLOADED );
#endif      
      destroy_pixmap(lp,PIXLOADED );
      
            
      sp->im_width[lp]= gdk_pixbuf_get_width(impixfile);
      sp->im_height[lp]= gdk_pixbuf_get_height(impixfile);
      gtk_subimasel_reset( &(sp->subimasel[lp]) ,
			   sp->im_width[lp],
			   sp->im_height[lp]);
      subimages_spinbuttons_set(lp);
      subimage2affines(lp);
      sp->im_loaded_pixbuf[lp]=impixfile;
      create__pixmap(lp,PIXLOADED );
      render_pixmap(lp, PIXLOADED);

      scale_loaded_pixbuf_et_rrggbb(lp);
      render_pixmap(lp, PIXSUBIMAGE);
      //FIXME do we do this here?
      //render_pixmap(lp, PIXWARPED);

#ifdef RESCALE_RELOAD_LESS_MEM
      destroy_pixbuf(lp,PIXLOADED );
      impixfile=NULL;
#endif


      if(sp->im_filename_in[lp]!=NULL)
	g_free(sp->im_filename_in[lp]);
      
      sp->im_filename_in[lp]=g_strdup(file);
      {
	char s[600];
	sprintf(s,"%s %d: %s",_("in img"),lp,     file);
	gtk_window_set_title ( GTK_WINDOW(sp->im_widget[lp]),   s);
      }
      set_editview( lp, EDITVIEW_EYES); 

      drawingarea_configure(lp);
      MY_GTK_DRAW( sp-> im_widget[lp]);  
      return TRUE;
    }  
}


gboolean load_image_from_file(int lp,
			      const char *file)
{
  int len=strlen(file);
  g_assert(lp>0);
  if (strcmp(file+len-4,".ply"))
    return load_image_from_file_not_ply(lp,file);
  else
    {
#if HAVE_LIBPLY_H
    if(!read_ply_) {
      show_error(_("gtkmorph could not find libply, so it cannot load PLY surfaces. Read documentations to install libply."));
      return FALSE;    
    }
    if(!read_ply_(file,&sp->im_ply_surface[lp])) {
      showerr(file,_("error while loading PLY file"));
      return FALSE;
    }
    return TRUE;
#else
    show_error(_("gtkmorph was NOT compiled with PLY support"));
    return FALSE;
#endif
  } 
}


/* reloads image , if necessary,  and rescales it */
void
reload_and_scale_image(int i)
{
  GdkPixbuf **impixfile = which_pixbuf(i,PIXLOADED);
  g_assert(i > 0);

  if(*impixfile == NULL) {
#ifndef RESCALE_RELOAD_LESS_MEM
    g_warning("lost original pixbuf %d... why???\n try reloading\n",i);
#endif
    if ( sp-> im_filename_in[i] == NULL
	 || strlen( sp-> im_filename_in[i]) == 0)	
      {
	show_error
	  ( g_strdup_printf(_("can't resize %dth image-no filename"),i));
	return;
      }
    /* reload */
#if GTK_MAJOR_VERSION < 2 
    *impixfile= gdk_pixbuf_new_from_file(sp-> im_filename_in[i]);
#else
    {
      GError *err=NULL;
      *impixfile= gdk_pixbuf_new_from_file(sp-> im_filename_in[i],&err);
      //FIXME should use err
    }
#endif
    if (*impixfile ==NULL)
      {
	showerr(sp-> im_filename_in[i], _("the attempt to reload the image file %s to resize it as produced error: %s"));
	create__pixbuf(i, PIXLOADED);
	return;
      }
  }
#ifdef RESCALE_RELOAD_LESS_MEM
  else {
    g_warning("the original pixbuf %d was not deallocated, reusing it\n",i);
    //FIXME why?? gdk_pixbuf_ref(*impixfile);
  }
#endif

  g_assert(*impixfile);
  g_assert(&(sp->im_loaded_pixbuf[i])==impixfile);
  render_pixmap(i, PIXLOADED);
  scale_loaded_pixbuf_et_rrggbb(i);
  render_pixmap(i, PIXSUBIMAGE);
#ifdef RESCALE_RELOAD_LESS_MEM
  delete_pixbuf(i, PIXLOADED);
#endif
}





/* it looks bad: it would be nicer if done with a static inline fun...
 but it must return the caller, not itself !*/

#define myfputc(F,C) \
{ \
 if( EOF == fputc(C,F)) { \
      showerr(file,_("\
the attempt to save the image file %s as produced error: %s")); \
      return FALSE; \
    } \
}

gboolean save_as_ppm(gchar *file,GdkPixbuf * pb)
{    
  FILE *f;
  int  w= sp-> resulting_width;
  int h= sp-> resulting_height;

    if( gdk_pixbuf_get_n_channels(pb) != 3)  {
      show_error
	(g_strdup_printf
	 (  " cant save as .ppm :-( the image has %d channels", 
	    gdk_pixbuf_get_n_channels(pb)  ));
      return FALSE;
    }

    f = fopen(file, "wb");
    if( f ==NULL)
      {
	showerr(file,_("\
the attempt to save the image file %s as produced error: %s"));
	return FALSE;
      }
  
    /* save as ppm format */
  
    fprintf(f,"\
P6\n\
# CREATOR: " PACKAGE " " VERSION "\n\
%d %d\n\
255\n",
	    w,h);
 
 
    {
      guchar  *data = gdk_pixbuf_get_pixels(pb);	
      int y, stride=gdk_pixbuf_get_rowstride(pb),
	channels=gdk_pixbuf_get_n_channels(pb);
      for (y=0;y<h;y++)
	if ( fwrite(data+y*stride, channels,w, f) != w)
	  {
	    showerr(file,_("\
the attempt to save the image file %s as produced error: %s"));
	  }
    }

    if( 0 != fclose (f))
      showerr(file,_("\
the attempt to close the saved image file %s as produced error: %s"));
    return TRUE;
}

/*******************************************************/




gboolean save_image_to_file(int lp,
			    const char *file)
{

  FILE *f;
  GdkPixbuf * pb=*(which_pixbuf_is_visible(lp));
  //int len=strlen(file);
  char *ext=extension(file);
  gboolean result=TRUE;

  if(is_null(file)) return FALSE;
  
  if( pb ==NULL)    {
    show_error(_("\
internal error: the image doesnt exist!"));
    return FALSE;
  }
  
  if(sp->im_filename_out[lp] == NULL ||
     0!=strcmp(sp->im_filename_out[lp],file)) {
    f = fopen(file, "r");
    if( f!=NULL)
      {
	showerr(file,_("\
This file already exists! If you really want to overwrite it, delete it."));
	fclose(f);
	return FALSE;
      }
  }

#ifndef HAVE_GDK_FORMATS
  if (ext == NULL || cmp_extension(file,"ppm")) {
    show_error(_(" this version of gtkmorph can save images only in .ppm format (to save in other formats, compile with GTK2 or higher). Please set the filename extension to '.ppm'"));
    return FALSE;
  } 
  result=save_as_ppm(file,pb);
#else
  {
    extern GSList *writable_formats;
    char *type="ppm";
    int wl=g_slist_length(writable_formats);
#ifdef HAVE_GTK_COMBO
    GtkWidget*  C=lookup_widget (fileselection_g,"file_type_combo");
    //if(!C)      { g_critical("cannot save! internal error"); return TRUE; }
    gint sel = gtk_combo_box_get_active(C);
#else
    gint sel= type_by_extension    (file);
#endif
    GSList *F=g_slist_nth(writable_formats,sel);
    if(sel<0 || sel >wl) {
      show_error(_("please use an allowed image format"));
      return FALSE;
    }
    //g_assert(F || sel==wl);
    if(F) {
      gpointer data=F->data;
      GError *error=NULL;
      
      f=data;
      type=gdk_pixbuf_format_get_name (f);
      result = gdk_pixbuf_save(pb,file,//const char *filename,
			       type,&error,NULL);
      g_assert ((result  && !error ) || (!result && error ));
      if(error)
	{show_error((error)->message);g_error_free (error);}   
    } else
      result=save_as_ppm(file,pb);
    {
      if ( ext==NULL ||  cmp_extension(file,type)) {
	gchar * s=g_strdup_printf
	  (_("the filename extension is '%s' but the image was saved in format '%s'. This mismatch may prevent you from viewing this image."),
	   (ext?ext:""),type); 
	show_warning(s);
	g_free(s);
      }
    }
  }
#endif
  if(result)
    sp->im_filename_out[lp]=g_strdup(file);
  
  return result;  
}




static gboolean cmp_mesh_name(int lp,const char *file)
{
  int l;
  for ( l =1; l <= MAX_WINS; l++)
    if( sp->im_widget[l] != NULL && sp->im_mesh_filename[l] != NULL)
      if( l != lp && 
	  0==strcmp (file, sp->im_mesh_filename[l])) {
	gchar *s=
	  g_strdup_printf
	  (_("this filename is already used by the mesh of image %d") ,l);
	show_error(s);
	g_free(s);
	return FALSE;
      }

  return TRUE;
}
/***************************************************************
 synch mesh labels
********/

/* we want the negative labels to be the highest, as if casting to unsigned */
#define MESHLABELMAP(A)   (((A)<0)? 20000-(A) : (A))
#define MESHLABELDEMAP(A) (((A)>20000)? 20000-(A) : (A))
#define MAXLABEL(A,B) MESHLABELDEMAP( MAX( MESHLABELMAP(A),MESHLABELDEMAP(B)))

/***************************************************************
 load mesh from file
*/



gboolean load_mesh_from_file(int lp, const char * file)
{
  FILE *fP;
  //int c;
  if(is_null(file)) return FALSE;

  if(!cmp_mesh_name(lp,file))
    return FALSE;

  if((fP=fopen(file, "r"))==NULL) {
    showerr(file, "could not open file '%s' for read: %s");
    return FALSE; 
  }

  if (meshRead_stream( &(sp-> im_mesh[lp]), fP))   {
    show_error(_("the attempt to load mesh from file as produced an error\n(either this is not a mesh file, or the mesh file is corrupted)"));
    fclose(fP);
    return FALSE;
  }
  
  /* memory leak :-) */
  sp->im_mesh_filename[lp] = g_strdup(file);

#ifdef NO_BORDER_HACK
  {
    MeshT *m =&sp->im_mesh[lp];
    meshSetLabel(m,0,0,MESHPOINTSELECTED);
    meshSetLabel(m,0,m->ny-1,MESHPOINTSELECTED);
    meshSetLabel(m,m->nx-1,0,MESHPOINTSELECTED);
    meshSetLabel(m,m->nx-1,m->ny-1,MESHPOINTSELECTED);
  }
#endif
  
#ifdef THE_MESH_IS_NOW_FREE  
  meshScale( &(sp->im_mesh[lp]),
	     sp->resulting_width, sp->resulting_height);
#endif
  MY_GTK_DRAW(sp-> im_widget[lp]);  
  
  sp->meshes_x= MAX(sp->meshes_x, sp->im_mesh[lp].nx);
  sp->meshes_y= MAX(sp->meshes_y, sp->im_mesh[lp].ny);
  
  if (settings_get_value("mesh auto sync")) {
    int xi,yi,t=0;
    MeshT *this, *res;
    promote_meshes();
    this=&(sp-> im_mesh[lp]);
    res=&(sp-> im_mesh[MAIN_WIN]);

    for(yi=0; yi < this->ny; yi++) {
      for(xi=0; xi < this->nx; xi++) {
	t+= meshGetLabel(this,xi,yi);
	/* this does a sort of fuzzy union */
	meshSetLabel(res, xi,yi,
		     MAXLABEL(meshGetLabel(this,xi,yi),
			      meshGetLabel(res ,xi,yi)));
      }}
    
    if(t==0) {
      /* this is an old style mesh, with no labels:
	 then we select all points so that they cant be smoothed
      */
      g_message(" this mesh %s had no labels: autoselecting all point",file);
	  for(yi=0; yi < this->ny; yi++) {
	    for(xi=0; xi < this->nx; xi++) {
	      meshSetLabel(this , xi,yi, -1);
	    }}}
  }


  if(gtk_subimasel_load(&(sp-> subimasel[lp]), fP)==0) {
    char s[401];s[0]=0;
    subimages_spinbuttons_set(lp);
    subimage2affines(lp);
  
    if(fgets(s,400,fP) && 0==strcmp("<image file name>\n",s)) {
      int l;
      fgets(s,400,fP);
      l=strlen(s);
      if(l>0) s[l-1]=0;
    } else
      s[0]=0;

    if(sp-> im_filename_in[lp] && s[0] &&  
       0!=strcmp(sp-> im_filename_in[lp],s)) {
      char z[601];
      sprintf(z,_("this mesh was created on image '%s' and not on this image '%s'"),s,sp-> im_filename_in[lp]);
      show_warning(z);
      if(sp-> im_filename_in[lp] && s[0] ) {
	gchar * b1, *b2;
#if GLIB_MAJOR_VERSION == 1
      b1=g_basename(sp-> im_filename_in[lp]);        b2=g_basename(s); 
#else
      b1=g_path_get_basename(sp-> im_filename_in[lp]);       
      b2=g_path_get_basename(s); 
#endif
      if(b1 && b2 && 0==strcmp(b1,b2))       {
	set_editview( lp, EDITVIEW_EDIT);
	scale_loaded_pixbuf_et_rrggbb(lp);}
      else set_editview( lp, EDITVIEW_EYES);
#if GLIB_MAJOR_VERSION >= 2
      g_free(b1); g_free(b2);
#endif
    } } else {
    if(sp-> subimasel[lp].orig_width != sp-> im_width[lp] || 
       sp-> subimasel[lp].orig_height != sp->im_height[lp]) {
      char z[601];
      sprintf(z,_("the size of the image w=%d h=%d and the size recorded in the mesh  w=%d h=%d  do not match"),
	      sp-> im_width[lp],sp->im_height[lp],
	      sp-> subimasel[lp].orig_width,sp-> subimasel[lp].orig_height);
      show_warning(z);
      set_editview( lp, EDITVIEW_EYES);
      } else {
	set_editview( lp, EDITVIEW_EDIT);
	scale_loaded_pixbuf_et_rrggbb(lp);
      }
    }
    fgets(s,400,fP);

  }
  else
    show_warning("could not read subimage information from this file.");

  fclose(fP);
  return TRUE;
}



/****************************************************************/


gboolean save_mesh_to_file(int lp, const char * file)
{
  FILE *fP;
/*   int c; */
/*   c=strlen(file); */
/*   /\* delete the common initial part of cwd and filename *\/ */
/* #define REDUCE__(A) ((0==strncmp(A,file,c)) ? (A)+c:(A)) */
  if(is_null(file)) return FALSE;

  if(lp==MAIN_WIN && settings_get_value("automatic mesh interpolation"))
    {
      if((fP=fopen(file, "r"))!=NULL)
	{
	  show_error(_("This mesh is automatically generated. You don't want to overwrite another mesh with this one!"));
	  fclose(fP);
	  return FALSE;
	}
    }

  if(!cmp_mesh_name(lp,file))
    return FALSE;

  if((fP=fopen(file, "w"))==NULL) {
    showerr(file, "could not open file '%s' for write: %s");
    return FALSE; 
  }
  if (meshWrite_stream( &(sp-> im_mesh[lp]), fP) ==0)
    {
      /* memory leak */
      sp->im_mesh_filename[lp] = g_strdup(file);
      sp-> subimasel[lp].orig_width = sp-> im_width[lp];
      sp-> subimasel[lp].orig_height = sp->im_height[lp];
      if(gtk_subimasel_save(&(sp-> subimasel[lp]), fP)==0) {
	if(sp->im_filename_in[lp])
	  fprintf(fP,"<image file name>\n%s\n</image file name>\n",
		  (sp->im_filename_in[lp]));
	fclose(fP);
	return TRUE;
      } else	{      
	  char *s = 
	    g_strdup_printf("\
the attempt to save the subimage selection in file %s as produced an internal error",
			    file);
	  show_error(s);	  
	  g_free(s);
	  fclose(fP);
	  return FALSE;
	}
    }
  else
    {      
      char *s = 
	g_strdup_printf("\
the attempt to save the mesh in file %s as produced an internal error",
			file);
			
      show_error(s);	  
      g_free(s);
      fclose(fP);
      return FALSE;
    }
  fclose(fP);
}

