#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

//#include "waili/gtk.h"

#include <math.h>
#include <string.h> //memcpy

#include <waili/Image.h>
#include <waili/Storage.h>

#include "gtk-meta.h"

#ifdef G_HAVE_ISO_VARARGS
#define message(...)  printf(__VA_ARGS__)
#elif defined(G_HAVE_GNUC_VARARGS)
#define message(format...)      printf(format)
#else  /* no varargs macros */
static void
message (const gchar *format,      ...)
{
  va_list args;
  va_start (args, format);
  printf (format, args);
  va_end (args);
}
#endif

/*************/   

#define DEPTH 2

#define EXTRA_PRECISION 16

//#define REDUCE_PRECISION(A) (((A)+EXTRA_PRECISION/2)/EXTRA_PRECISION)
#if  EXTRA_PRECISION == 1
#define REDUCE_PRECISION(A) (A)
#else
static inline gint REDUCE_PRECISION(gint A) {
  return (((A)+(EXTRA_PRECISION/2))/EXTRA_PRECISION);
}
#endif
static inline gchar pix_2_char(PixType A) {
  return CLAMP( REDUCE_PRECISION(A) +128 ,0,255);
}

/*************/   

Image *gdk_to_waili(GdkPixbuf *src)
{
  guchar * data = gdk_pixbuf_get_pixels(src);
  int ch,c,r,
    channels=gdk_pixbuf_get_n_channels(src),
    stride=gdk_pixbuf_get_rowstride(src),
    w= gdk_pixbuf_get_width(src), h=gdk_pixbuf_get_height(src);

  Image * dst = new Image(w,h,channels); 
  g_assert(data);
  for (r = 0; r < h; r++)
    for (c = 0; c < w; c++)
      for (ch = 0; ch < channels; ch++) {
	  (*dst)(c, r, ch) = EXTRA_PRECISION*((PixType)
	    ( data[ch+ c*channels + stride*r]-128));
      }
  return dst;
}

/*************/   

void waili_to_gdk(GdkPixbuf  *dst,Image *src)
{
  int channels=src->GetChannels(), 
    w=src->GetCols(0),  h=src->GetRows(0),   c ,r ;
  guchar * data = gdk_pixbuf_get_pixels(dst);
  int    stride=gdk_pixbuf_get_rowstride(dst);
  assert(channels==gdk_pixbuf_get_n_channels(dst));
  assert(w==gdk_pixbuf_get_width(dst));
  assert(h==gdk_pixbuf_get_height(dst));
  switch(channels) {
  case 1:
    for (r = 0; r < h; r++)
      for (c = 0; c < w; c++)      {
	data[ c + stride*r]= 
	  data[ c + stride*r+1]= 
	  data[ c + stride*r+2]= pix_2_char((*src)(c, r, 0));
      }
    break;
  case 3:
  case 4:    
    for (r = 0; r < h; r++)
      for (c = 0; c < w; c++)
	for (int ch = 0; ch < channels; ch++) {
	  data[ch+ c*channels + stride*r]=pix_2_char((*src)(c, r, ch));	  
	}
    break;
  default: abort(); 
  }
}

/*************/   

GdkPixbuf  *waili_to_gdk(Image *src)
{
  int channels=src->GetChannels(), 
    w=src->GetCols(0),  h=src->GetRows(0) ;
  GdkPixbuf  *dst=gdk_pixbuf_new
    (GDK_COLORSPACE_RGB,//GdkColorspace colorspace,
     (channels==4?1:0),//gboolean has_alpha,
     8,//int bits_per_sample,
     w,//int width,
     h);//int height);
  waili_to_gdk(dst,src);
  return dst;
}

/********************************************************************/   
Wavelet *MyWavelet = NULL;

void Do_FStep_CR(Image *I)
{
    for (u_int ch = 0; ch < I->GetChannels(); ch++) {
	Channel *ch2 = (*I)[ch]->PushFwtStepCR(*MyWavelet);
	if (ch2 && ch2 != (*I)[ch]) {
	    delete (*I)[ch];
	    (*I)[ch] = ch2;
	}
    }
}

/*************/   

double L2(Channel *channel) 
{
  u_int Cols = channel->GetCols() ,  Rows = channel->GetRows();

  u64 ss = 0;
  for (u_int r = 0; r < Rows; r++)
    for (u_int c = 0; c < Cols; c++) {
      int d = (*channel)(c, r);
      ss += d*d;
    }
  return ((double)ss/(double)(Cols*Rows));
}

/*********************************************************/   

struct statdata { Channel *C; double v;} ;

#if GLIB_CHECK_VERSION(2,4,0)
static gpointer    statscopy (gconstpointer  src ,gpointer data)
{
  if(data == NULL)
    return NULL;
  gpointer s=g_malloc(sizeof(struct statdata));
  memcpy(s,src,sizeof(struct statdata));
  return s;
}
static   gpointer  statsclone (gconstpointer src,gpointer data)
{
  gpointer s=g_malloc0(sizeof(struct statdata));
  return s;
}
#endif

void   statsmalloc(GNode *node,gpointer data)
{
  g_node_children_foreach(node,  G_TRAVERSE_ALL,
			  statsmalloc, NULL);
  node->data=g_malloc0(sizeof(struct statdata));
}


void   statsfree(GNode *node,gpointer data)
{
  g_node_children_foreach(node,  G_TRAVERSE_ALL,
			  statsfree, NULL);
  g_free(node->data);
  node->data=NULL;
}



GNode * L2_stats_channel(Channel *C, int depth)
{  
  struct statdata *s; 
  s=(struct statdata *)g_malloc(sizeof(struct statdata));
  s->C=C;
  s->v=-1;
  GNode *  stat= g_node_new(s);
  
  if (C->IsLifted()) { 
    unsigned int subbands=((LChannel *)C)->GetSubbands();
    for (u_int z = 0; z < subbands; z++) {
      SubBand c=(SubBand)z; 
      Channel *CS=(*(LChannel *)C)[c];      g_assert(CS);      
      GNode *cs=NULL;
      g_debug("  subband=%d ", z);
      cs=L2_stats_channel(CS,depth+1);
      g_node_append(stat,cs);
    }
  } else {
    double l = L2(C); 
    g_debug(" depth %d sigma %2.3g ",depth,sqrt(l)/EXTRA_PRECISION);
    s->v = l;
  }
  return stat;
}

GNode * L2_stats_channel(Channel *C)
{
  return L2_stats_channel(C,0);
}

/*******************************/

void sum(GNode *thi, GNode *other,double factor)
{
  struct statdata *st, *so;
  
  GNode *stc = g_node_first_child(thi),
    *soc = g_node_first_child(other);
  if( stc ) {
    while(stc) {
      sum(stc,soc,factor);
      stc=g_node_next_sibling(stc);
      soc=g_node_next_sibling(soc);
    }
  }  else {
    if(other) {
      st=(struct statdata *)(thi->data);
      so=(struct statdata *)(other->data);
      st->v += factor * so->v;
    } else g_critical(" wrong depth");
  }
}

/*************/   

GNode * L2_stats(Image *I)
{
  (*I).Convert(IT_RGB, IT_YUVr);

  if (! MyWavelet)
    MyWavelet = new Wavelet_SWE_13_7; //Wavelet_CRF_13_7
  
  for(int lp=DEPTH;lp>0;lp--) {
    Do_FStep_CR(I); 
  }

  u_int channels = I->GetChannels();
  
  GNode *stat=g_node_new(NULL);

  for (unsigned int ch = 0; ch < channels; ch++) {
    g_debug("color %d ",ch);
    g_node_append(stat, L2_stats_channel((*I)[ch]) );  
  }
  return stat;
}

GNode * L2_stats(GdkPixbuf *src)
{
  Image * I =gdk_to_waili(src);
  GNode * n =L2_stats(I);
  delete I;
  return n;
}

void enhance_channel(Channel *C,GNode *stat, GNode *statwanted,int depth=0)
{

  struct statdata *s, *sw;

  if (C->IsLifted()) { 
    unsigned int subbands=((LChannel *)C)->GetSubbands();
    //for (u_int z = (subbands-1); z >= 0; z--){
    for (u_int z = 0; z < subbands; z++) {
      SubBand c=(SubBand)z; 
      Channel *CS=(*(LChannel *)C)[c];
      assert(CS);
      g_assert(! G_NODE_IS_LEAF(stat));
      g_assert(! G_NODE_IS_LEAF(statwanted));
      if(z != 0 || CS->IsLifted())
	enhance_channel(CS,
			g_node_nth_child(stat,z),
			g_node_nth_child(statwanted,z),
			depth+1);    
    }
  } else {
    s=(struct statdata *)(stat->data);
    sw=(struct statdata *)(statwanted->data);
    double E= sqrt(sw->v / (s->v+0.001));
    (*C).Enhance(  E  ); 
    double l = L2(C); 
    printf(\
"depth %d sigma=%2.3f should be %2.3f ;corrected to %2.3f (%+.2g db)\n",
	   depth,
	   sqrt(s->v)/EXTRA_PRECISION,sqrt(sw->v)/EXTRA_PRECISION,
	   sqrt(l)/EXTRA_PRECISION,20*log(E)/log(2.));
  }
}


/*****************************************************************
 fake an image by using gaussian noise
*/

//#define FAKE_TEST

#ifdef FAKE_TEST
    //  Uniform random generator between 0 and 1

static double ranu(void)
{
  double x;
#ifdef __WIN32__
  x = (double)rand()/(double)RAND_MAX;
#else
  x=drand48();
#endif
  return x;
}

//  Gaussian random generator
static double rang()
{
    static double x1, x2;
    double s, num1, num2, v1, v2, tvar;
    static int igauss = 0 ;
    if (igauss != 2) {
      do {
	num1 = ranu();
	num2 = ranu();
	v1 = 2.0*num1-1.0;
	v2 = 2.0*num2-1.0;
	s = v1*v1+v2*v2;
      } while (s >= 1.0 || s == 0.0);
      tvar = sqrt(-2.0*log(s)/s);
      x1 = v1*tvar;
      x2 = v2*tvar;
      igauss = 2;
      return x1;
    } else {
      igauss = 1;
      return x2;
    }
}
void Do_Noise(Channel *C,   double stdev )
{
    unsigned int w= C->GetCols(),h=C->GetRows();
    for (u_int r = 0; r < h; r++)
      for (u_int c = 0; c < w; c++)
	(*C)(c, r) = (PixType)floor(0.5+stdev*rang());
}
static void Do_View(Image * MyImage)
{
  /* WHO THE HELL MADE THIS STRING SIZE =32!!!!! I LOST 3 DAYS ON THIS!!!*/
    char command[512];
#ifdef __WIN32__
    char *filename = tmpnam(NULL); 
#else
    char filename[] = "/tmp/wailiXXXXXXXX";
    if(!mkstemp(filename))
      g_critical(filename);
#endif
    MyImage->Export(filename);
    sprintf(command, "if which xv >/dev/null ; then xv %s & else display %s & fi", filename,filename);
    system(command);
}
void fake_channel(Channel *C, GNode *statfinal,int depth=0)
{
  struct statdata  *sf;

  if (C->IsLifted()) { 
    unsigned int subbands=((LChannel *)C)->GetSubbands();
    for (u_int z = 0; z < subbands; z++) {
      SubBand c=(SubBand)z; 
      Channel *CS=(*(LChannel *)C)[c];
      assert(CS);
      g_assert(! G_NODE_IS_LEAF(statfinal));
      if(z != 0 || CS->IsLifted())
	fake_channel(CS,  g_node_nth_child(statfinal,z),depth+1);
    }
  } else {
    sf=(struct statdata *)(statfinal->data);
    Do_Noise(C,  sqrt(sf->v) ); 
    double l = L2(C); 
    printf("depth %d  faked to %g that is %g\n",depth,
	   sqrt(sf->v)/EXTRA_PRECISION, sqrt(l)/EXTRA_PRECISION);
  }
}
#endif //FAKE_TEST
/******************************************************************/

void wavelet_equalize_(GdkPixbuf *src,GNode *l2_wanted_stat)
{
  Image * I =gdk_to_waili(src);

  GNode *l2_stat=L2_stats(I);

  u_int channels = I->GetChannels();
#ifdef FAKE_TEST
  {
    Image J =*I;
    for (unsigned int ch = 0; ch < channels; ch++) {
      message(" - faking color %d",ch);
      fake_channel((J)[ch],g_node_nth_child (l2_wanted_stat,ch));  
    }
    (J).IFwt();
    (J).Convert(IT_YUVr,IT_RGB);
    for (unsigned int ch = 0; ch < channels; ch++) 
      (J)[ch]->Enhance(1.0/EXTRA_PRECISION);
    Do_View(&J);
  }
#endif

  for (unsigned int ch = 0; ch < channels; ch++) {
    message(" - equalize color %d\n",ch);
    enhance_channel((*I)[ch], 
		    g_node_nth_child (l2_stat,ch),
		    g_node_nth_child (l2_wanted_stat,ch));
  }
  (*I).IFwt();
  (*I).Convert(IT_YUVr,IT_RGB);
  waili_to_gdk(src,I);
}


extern "C"
{
  GNode *  wavelet_stats(GdkPixbuf *src)
  {
    return L2_stats(src);
  }

  void wavelet_stats_sum(GNode *ths, GNode *other,double factor)
  {
    sum(ths,other,factor);
  }

#if GLIB_CHECK_VERSION(2,4,0)  
  GNode * wavelet_stats_copy(GNode *ths)
  {
    return     g_node_copy_deep (ths, statscopy,NULL);
  }
  GNode * wavelet_stats_clone(GNode *ths)
  {
    return     g_node_copy_deep (ths, statsclone,NULL);
  }
#else
  GNode * wavelet_stats_clone(GNode *ths)
  {
    GNode *copy=     g_node_copy (ths);
    statsmalloc(copy,NULL);
    return copy;
  }
#endif

  void wavelet_stats_free(GNode *ths)
  {

    statsfree(ths,NULL);
    g_node_destroy (ths);
  }

  void wavelet_equalize(GdkPixbuf *dpb,GNode *l2_stats)
  {
     wavelet_equalize_(dpb,l2_stats);
  }
}
  
