#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include "gtk-meta.h"

#include "string.h" //strlen

#include "gtktopdata.h"
#include "gtk_subimagesel.h"

#include "main.h"
#include "utils.h"
#include "support.h"
#include "interface.h"
#include "dialogs.h"
#include "loadsave.h"

#include "callbacks_fs.h"
extern fileselection_hook_t fileselection_hook;

#ifndef IS_PLYMORPH
#include "loadsave_mesh.h"
#else
#include "loadsave_ply.h"
#endif


/***** 
       returns TRUE if it was already known
***/
static gboolean
set_fs_mesh_filename(int i)
{
  if ( sp->im_mesh_filename[i] != NULL) {   
      gtk_file_selection_set_filename(fileselection_g,
				      sp->im_mesh_filename[i]);
      return TRUE;
  } else {
      char *file= sp-> im_filename_in[i];
      
      if(file != NULL) { 
	char *s = g_strdup_printf("%s.mesh",file);
	gtk_file_selection_set_filename(fileselection_g,  s);
	g_free(s);
      }       else
	gtk_file_selection_complete(fileselection_g, "*.mesh");
      //gtk_file_selection_set_filename(fileselection_g,  "");
      return FALSE;
  }
}

void
on_loadmesh_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  int i =
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 
  fileselection_hook=load_mesh_from_file;

  show_fs(GTK_WIDGET(button), _( "load mesh")
#if GTK_MAJOR_VERSION >= 2
	     ,	    GTK_FILE_CHOOSER_ACTION_OPEN
#endif	     
	  ); 
  set_fs_mesh_filename(i);
}













void
on_savemesh_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  int i = GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 

  fileselection_hook=save_mesh_to_file;
  


  //FIXME auto save doesnt work
  //if( set_fs_mesh_filename(i) == FALSE|| button->state & GDK_SHIFT_MASK)
  show_fs(GTK_WIDGET(button), _( "save mesh n.")
#if GTK_MAJOR_VERSION >= 2
	     ,	    GTK_FILE_CHOOSER_ACTION_SAVE
#endif	     
	  ); 

  set_fs_mesh_filename(i);
  //  else
  /* directly simulate as if OK was hit */
  //on_ok_button1_clicked   (NULL,NULL); 
}





















