// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef CLIENTLIST_H
#define CLIENTLIST_H

#include "mfc.h"                            // CTypedPtrList - audited 4 Nov 2004

#include <map>                              // std::map
#include <stdint.h>                         // uint8_t uint16_t uint32_t

class CClientReqSocket;
class CUpDownClient;

class CClientList
{
public:
    CClientList();
    ~CClientList();
    void AddClient(CUpDownClient* toadd,bool bSkipDupTest = false);
    void RemoveClient(CUpDownClient* toremove);
    void GetStatistics(uint32_t &totalclient, int stats[], std::map<uint16_t, uint32_t>* clientVersionEDonkey = NULL, std::map< uint16_t, uint32_t >* clientVersionEDonkeyHybrid = NULL, std::map< uint8_t, uint32_t >* clientVersionEMule = NULL);
    void DeleteAll();
    bool AttachToAlreadyKnown(CUpDownClient** client, CClientReqSocket* sender);
    CUpDownClient* FindClientByIP(uint32_t clientip,uint16_t port);
    CUpDownClient* FindClientByUserHash(unsigned char* clienthash);
    CUpDownClient* VUGetRandomClient();
    bool VerifyUpload(uint32_t clientip,uint16_t port);
    bool Debug_IsValidClient(CUpDownClient* tocheck);
    void Debug_SocketDeleted(CClientReqSocket* deleted);

private:
    CTypedPtrList<CPtrList, CUpDownClient*> list;
};

#endif
