// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include "MD5Sum.h"                         // MD5Sum - audited 5 Nov 2004
#include "mfc.h"                            // wxString - audited 4 Nov 2004
#include "wintypes.h"                       // bool DWORD INT WORD - audited 4 Nov 2004

#include <ctime>
#include <list>                             // Needed for std::list
#include <stdint.h>                         // uint32_t
#include <wx/version.h>                     // wxCHECK_VERSION

#if wxCHECK_VERSION(2, 5, 0)
    #include <wx/arrstr.h>                  // wxArrayString
#else
    #include <wx/string.h>                  // wxArrayString
#endif

#ifndef MAX_PATH
// *BSD compatibility
#	if (defined(BSD) && (BSD >= 199103))
#		define MAX_PATH MAXPATHLEN
#	else
#		define MAX_PATH 2048
#	endif
#endif

#define DEFAULT_COL_SIZE 65535

// DO NOT EDIT VALUES like making a uint16_t to uint32_t, or insert any value. ONLY append new vars
#pragma pack(1)
struct Preferences_Ext_Struct
{
    int8_t version;
    unsigned char userhash[16];
    WINDOWPLACEMENT EmuleWindowPlacement;
};

#pragma pack()

// deadlake PROXYSUPPORT
struct ProxySettings
{
    uint16_t type;
    uint16_t port;
    char name[50];
    char user[50];
    char password[50];
    bool EnablePassword;
    bool UseProxy;
};

#pragma pack(1)
struct Category_Struct
{
    wxString incomingpath;
    wxString title;
    wxString comment;
    uint32_t color;
    int prio;
};

#pragma pack(1)
struct Preferences_Struct
{
    int8_t updatenotify;
    int8_t autotakeed2klinks;
    unsigned char userhash[16];
    WINDOWPLACEMENT EmuleWindowPlacement;
    int16_t downloadColumnWidths[13];
    int16_t downloadColumnHidden[13];
    INT downloadColumnOrder[13];
    int16_t uploadColumnWidths[8];
    int16_t uploadColumnHidden[8];
    INT uploadColumnOrder[8];
    int16_t queueColumnWidths[10];
    int16_t queueColumnHidden[10];
    INT queueColumnOrder[10];
    int16_t searchColumnWidths[5];
    int16_t searchColumnHidden[5];
    INT searchColumnOrder[5];
    int16_t sharedColumnWidths[11];
    int16_t sharedColumnHidden[11];
    INT sharedColumnOrder[11];
    int16_t serverColumnWidths[12];
    int16_t serverColumnHidden[12];
    INT serverColumnOrder[12];
    int16_t clientListColumnWidths[8];
    int16_t clientListColumnHidden[8];
    INT clientListColumnOrder[8];
    uint32_t statcolors[15];
    uint64_t totalDownloadedBytes;
    uint64_t totalUploadedBytes;
    WORD languageID;
    int8_t m_iToolDelayTime;
    int8_t splitterbarPosition;
    int8_t useDownloadNotifier;
    int8_t useChatNotifier;
    int8_t useLogNotifier;
    int8_t useSoundInNotifier;
    int8_t notifierPopsEveryChatMsg;
    int8_t notifierImportantError;
    int8_t notifierNewVersion;
    char notifierSoundFilePath[510];
    char m_sircserver[50];
    char m_sircnick[30];
    char m_sircchannamefilter[50];
    bool m_bircaddtimestamp;
    bool m_bircusechanfilter;
    uint16_t m_iircchanneluserfilter;
    char m_sircperformstring[255];
    bool m_bircuseperform;
    bool m_birclistonconnect;
    bool m_bircacceptlinks;
    bool m_bircignoreinfomessage;
    bool m_bircignoreemuleprotoinfomessage;
    uint8_t smartidstate;
    bool m_bVerbose;
    bool m_bDisableKnownClientList;
    bool m_bDisableQueueList;
    int8_t versioncheckdays;
    // Barry - Provide a mechanism for all tables to store/retrieve sort order
    int tableSortItemDownload;
    int tableSortItemUpload;
    int tableSortItemQueue;
    int tableSortItemSearch;
    int tableSortItemShared;
    int tableSortItemServer;
    int tableSortItemClientList;
    bool tableSortAscendingDownload;
    bool tableSortAscendingUpload;
    bool tableSortAscendingQueue;
    bool tableSortAscendingSearch;
    bool tableSortAscendingShared;
    bool tableSortAscendingServer;
    bool tableSortAscendingClientList;
    char TxtEditor[256];
    char VideoPlayer[256];
    bool moviePreviewBackup;
    bool indicateratings;
    bool showAllNotCats;
    bool watchclipboard;
    bool m_bFirstStart;
    bool m_bCreditSystem;
    bool log2disk;
    bool debug2disk;
    int iMaxLogMessages;
    bool scheduler;
    bool dontcompressavi;
    bool msgonlyfriends;
    bool msgsecure;
    uint8_t filterlevel;
    int m_iCommitFiles;
    uint16_t maxmsgsessions;
    uint32_t versioncheckLastAutomatic;
    char messageFilter[512];
    char commentFilter[512];
    char notifierConfiguration[510];
    char datetimeformat[32];
    char m_szLRUServermetURL[512];
    // Web Server [kuchin]
    char m_sWebPassword[256];
    char m_sWebLowPassword[256];
    uint16_t m_nWebPort;
    bool m_bWebEnabled;
    bool m_bWebUseGzip;
    int m_nWebPageRefresh;
    bool m_bWebLowEnabled;
    char m_sWebResDir[MAX_PATH];
    char m_sTemplateFile[MAX_PATH];
    ProxySettings proxy;
    // deadlake PROXYSUPPORT
    bool m_bIsASCWOP;
    bool showCatTabInfos;
    bool resumeSameCat;
    bool dontRecreateGraphs;
    int allcatType;
    bool m_bUseSecureIdent;
    // Madcat - Sources Dropping Tweaks
    bool DropNoNeededSources;
    bool SwapNoNeededSources;
    bool DropFullQueueSources;
    bool DropHighQueueRankingSources;
    int HighQueueRanking;
    int AutoDropTimer;
};

#pragma pack()

class CPreferences
{
    public:
    enum Table
    {
        tableDownload, tableUpload, tableQueue, tableSearch,
        tableShared, tableServer, tableClientList
        };
    wxArrayString shareddir_list;
    std::list<wxString> addresses_list;
    friend class CPreferencesWnd;
    friend class CPPgGeneral;
    friend class CPPgConnection;
    friend class CPPgServer;
    friend class CPPgDirectories;
    friend class CPPgFiles;
    friend class CPPgNotify;
    friend class CPPgIRC;
    friend class Wizard;
    friend class CPPgTweaks;
    friend class CPPgDisplay;
    friend class CPPgSecurity;
    friend class CPPgScheduler;
    friend class CPPgSourcesDropping;
    friend class CPPgGuiTweaks;
    CPreferences();
    ~CPreferences();
    // Sort Algorithmen
    int GetColumnWidth(const short int t, int index) const;
    bool GetColumnHidden(Table t, int index) const;
    int GetColumnOrder(const short int t, int index) const;
    void SetColumnWidth(const short int t, int index, int width);
    void SetColumnHidden(Table t, int index, bool bHidden);
    void SetColumnOrder(const short int t, INT *piOrder);
    int GetColumnSortItem(Table t) const;
    bool GetColumnSortAscending(Table t) const;
    void SetColumnSortItem(Table t, int sortItem);
    void SetColumnSortAscending(Table t, bool sortAscending);
    // Load-Save
    bool Load(bool startup);
    bool Save(unsigned char selection_mask);
    // ~/.eMule Line13:Language
    void SetLanguage();
    // ~/.eMule Line 15:ToolTipDelay
    void SetToolTipDelay(int8_t in_m_iToolDelayTime)
    {
        prefs->m_iToolDelayTime = in_m_iToolDelayTime;
    }
    int8_t GetToolTipDelay(void)
    {
        return prefs->m_iToolDelayTime;
    }

    uint16_t GetDefaultMaxConperFive();
    // ~/.emule Line 25:Check4NewVersionDelay
    void SetUpdateDays(int8_t in_versioncheckdays)
    {
        prefs->versioncheckdays = in_versioncheckdays;
    }
    int8_t GetUpdateDays()
    {
        return prefs->versioncheckdays;
    }
    // ~/.eMule Line31:UpdateNotify
    void SetUpdateNotify(bool in_updatenotify)
    {
        prefs->updatenotify = in_updatenotify;
    }
    bool UpdateNotify()
    {
        return prefs->updatenotify;
    }
    // ~/-eMule Line 49:AutoTakeED2KLinks
    void SetAutoTakeED2KLinks(bool in_autotakeed2klinks)
    {
        prefs->autotakeed2klinks = in_autotakeed2klinks;
    }
    bool AutoTakeED2KLinks()
    {
        return prefs->autotakeed2klinks;
    }
    // ~/.eMule Line 61:VideoPlayer
    void SetVideoPlayer(wxString in_VideoPlayer)
    {
        strcpy(prefs->VideoPlayer, in_VideoPlayer.c_str());
    }
    char *GetVideoPlayer()
    {
        if (strlen(prefs->VideoPlayer) == 0) return "";
        else return prefs->VideoPlayer;
    }
    // ~/.eMule Line 80:Verbose
    void SetVerbose(bool in_m_bVerbose)
    {
        prefs->m_bVerbose = in_m_bVerbose;
    }
    bool GetVerbose()
    {
        return prefs->m_bVerbose;
    }

    bool IsQueueListDisabled()
    {
        return prefs->m_bDisableQueueList;
    }
    // ~/.eMule Line 87:VideoPreviewBackupped
    void SetMoviePreviewBackup(bool in_moviePreviewBackup)
    {
        prefs->moviePreviewBackup = in_moviePreviewBackup;
    }
    bool IsMoviePreviewBackup()
    {
        return prefs->moviePreviewBackup;
    }
    // ~/.eMule Line 144-155:StatColor0-StatColor12
    void SetStatsColor(int index, uint32_t value)
    {
        prefs->statcolors[index] = value;
    }
    uint32_t GetStatsColor(int index)
    {
        return prefs->statcolors[index];
    }
    void ResetStatsColor(int index);
    // UNSORTED *****************************************************************************
    // Download Categories (Ornis)
    void RemoveCat(int index);
    int AddCat(Category_Struct* cat)
    {
        catMap.Add(cat);
        return catMap.GetCount() - 1;
    }
    int GetCatCount()
    {
        return catMap.GetCount();
    }
    Category_Struct *GetCategory(int index)
    {
        if (index >= 0 &&index < catMap.GetCount()) return catMap.GetAt(index);
        else return NULL;
    }
    
    wxString& GetCatPath(uint8_t index)
    {
        return catMap.GetAt(index)->incomingpath;
    }
    DWORD GetCatColor(int index)
    {
        if ((int) index >= 0 && (int) index < (int) catMap.GetCount()) return catMap.GetAt(index)->color;
        else return 0;
    }
    int GetAllcatType()
    {
        return prefs->allcatType;
    }
    void SetAllcatType(int in)
    {
        prefs->allcatType = in;
    }
    bool ShowAllNotCats()
    {
        return prefs->showAllNotCats;
    }
    bool ShowRatingIndicator()
    {
        return prefs->indicateratings;
    }
    bool WatchClipboard4ED2KLinks()
    {
        return prefs->watchclipboard;
    }
    void InvertShowAllNotCats()
    {
        prefs->showAllNotCats =!prefs->showAllNotCats;
    }
    bool Log2Disk()
    {
        return prefs->log2disk;
    }
    bool Debug2Disk()
    {
        return prefs->debug2disk;
    }
    int GetMaxLogMessages()
    {
        return prefs->iMaxLogMessages;
    }
    char *GetUserHash()
    {
        return userhash;
    }
    char *GetLRUServermetURL()
    {
        return prefs->m_szLRUServermetURL;
    }
    void SetLRUServermetURL(const char *pszURL)
    {
        snprintf(prefs->m_szLRUServermetURL, sizeof prefs->m_szLRUServermetURL, "%s", pszURL);
    }
    void Add2TotalDownloaded(uint64_t in)
    {
        prefs->totalDownloadedBytes += in;
    }
    void Add2TotalUploaded(uint64_t in)
    {
        prefs->totalUploadedBytes += in;
    }
    uint64_t GetTotalDownloaded()
    {
        return prefs->totalDownloadedBytes;
    }
    uint64_t GetTotalUploaded()
    {
        return prefs->totalUploadedBytes;
    }
    WORD GetLanguageID()
    {
        return prefs->languageID;
    }
    int8_t GetSplitterbarPosition()
    {
        return prefs->splitterbarPosition;
    }
    void SetSplitterbarPosition(int8_t pos)
    {
        prefs->splitterbarPosition = pos;
    }
    bool GetUseDownloadNotifier()
    {
        return prefs->useDownloadNotifier;
    }
    bool GetUseChatNotifier()
    {
        return prefs->useChatNotifier;
    }
    bool GetUseLogNotifier()
    {
        return prefs->useLogNotifier;
    }
    bool GetUseSoundInNotifier()
    {
        return prefs->useSoundInNotifier;
    }
    bool GetNotifierPopsEveryChatMsg()
    {
        return prefs->notifierPopsEveryChatMsg;
    }
    bool GetNotifierPopOnImportantError()
    {
        return prefs->notifierImportantError;
    }
    bool GetNotifierPopOnNewVersion()
    {
        return prefs->notifierNewVersion;
    }
    char *GetNotifierWavSoundPath()
    {
        return prefs->notifierSoundFilePath;
    }
    WORD GetWindowsVersion();
    bool IsKnownClientListDisabled()
    {
        return prefs->m_bDisableKnownClientList;
    }
    bool IsFirstStart()
    {
        return prefs->m_bFirstStart;
    }
    bool UseCreditSystem()
    {
        return prefs->m_bCreditSystem;
    }
    void SetCreditSystem(bool m_bInCreditSystem)
    {
        prefs->m_bCreditSystem = m_bInCreditSystem;
    }
    char *GetTxtEditor()
    {
        return prefs->TxtEditor;
    }
    int GetCommitFiles()
    {
        return prefs->m_iCommitFiles;
    }
    WINDOWPLACEMENT GetEmuleWindowPlacement()
    {
        return prefs->EmuleWindowPlacement;
    }
    void SetWindowLayout(WINDOWPLACEMENT in)
    {
        prefs->EmuleWindowPlacement = in;
    }
    uint32_t GetLastVC()
    {
        return prefs->versioncheckLastAutomatic;
    }
    void UpdateLastVC()
    {
        prefs->versioncheckLastAutomatic = time(NULL);
    }
    int GetIPFilterLevel()
    {
        return prefs->filterlevel;
    }
    wxString GetMessageFilter()
    {
        return prefs->messageFilter;
    }
    wxString GetCommentFilter()
    {
        return wxString(prefs->commentFilter);
    }
    char *GetNotifierConfiguration()
    {
        return prefs->notifierConfiguration;
        };
    //<<-- enkeyDEV(kei-kun) -skinnable notifier-
    void SetNotifierConfiguration(wxString configFullPath)
    {
        sprintf(prefs->notifierConfiguration, "%s", configFullPath.GetData());
    }
    //<<-- enkeyDEV(kei-kun) -skinnable notifier-
    wxString GetDateTimeFormat()
    {
        return wxString(prefs->datetimeformat);
    }
    // WebServer
    uint16_t GetWSPort()
    {
        return prefs->m_nWebPort;
    }
    void SetWSPort(uint16_t uPort)
    {
        prefs->m_nWebPort = uPort;
    }
    wxString GetWSPass()
    {
        return wxString(prefs->m_sWebPassword);
    }
    void SetWSPass(wxString strNewPass)
    {
        sprintf(prefs->m_sWebPassword, "%s", MD5Sum(strNewPass) .GetHash() .GetData());
    }
    bool GetWSIsEnabled()
    {
        return prefs->m_bWebEnabled;
    }
    void SetWSIsEnabled(bool bEnable)
    {
        prefs->m_bWebEnabled = bEnable;
    }
    bool GetWebUseGzip()
    {
        return prefs->m_bWebUseGzip;
    }
    void SetWebUseGzip(bool bUse)
    {
        prefs->m_bWebUseGzip = bUse;
    }
    int GetWebPageRefresh()
    {
        return prefs->m_nWebPageRefresh;
    }
    void SetWebPageRefresh(int nRefresh)
    {
        prefs->m_nWebPageRefresh = nRefresh;
    }
    bool GetWSIsLowUserEnabled()
    {
        return prefs->m_bWebLowEnabled;
    }
    void SetWSIsLowUserEnabled(bool in)
    {
        prefs->m_bWebLowEnabled = in;
    }
    wxString GetWSLowPass()
    {
        return wxString(prefs->m_sWebLowPassword);
    }
    void SetWSLowPass(wxString strNewPass)
    {
        sprintf(prefs->m_sWebLowPassword, "%s", MD5Sum(strNewPass) .GetHash() .GetData());
    }
    bool IsSchedulerEnabled()
    {
        return prefs->scheduler;
    }
    bool GetDontCompressAvi()
    {
        return prefs->dontcompressavi;
    }
    bool MsgOnlyFriends()
    {
        return prefs->msgonlyfriends;
    }
    bool MsgOnlySecure()
    {
        return prefs->msgsecure;
    }
    uint16_t GetMsgSessionsMax()
    {
        return prefs->maxmsgsessions;
    }
    wxString GetTemplate()
    {
        return wxString(prefs->m_sTemplateFile);
    }
    void SetTemplate(wxString in)
    {
        sprintf(prefs->m_sTemplateFile, "%s", in.GetData());
    }
    // deadlake PROXYSUPPORT
    ProxySettings GetProxy()
    {
        return prefs->proxy;
    }
    void SetProxySettings(ProxySettings proxysettings)
    {
        prefs->proxy = proxysettings;
    }
    void ResetListenPort()
    {
        ListenPort = 0;
        m_UseProxyListenPort = false;
    }
    void SetUseProxy(bool in)
    {
        prefs->proxy.UseProxy = in;
    }
    bool IsProxyASCWOP()
    {
        return prefs->m_bIsASCWOP;
    }
    void SetProxyASCWOP(bool in)
    {
        prefs->m_bIsASCWOP = in;
    }
    bool ShowCatTabInfos()
    {
        return prefs->showCatTabInfos;
    }
    void ShowCatTabInfos(bool in)
    {
        prefs->showCatTabInfos = in;
    }
    bool GetResumeSameCat()
    {
        return prefs->resumeSameCat;
    }
    bool IsGraphRecreateDisabled()
    {
        return prefs->dontRecreateGraphs;
    }
    // Madcat - Sources Dropping Tweaks
    bool DropNoNeededSources()
    {
        return prefs->DropNoNeededSources;
    }
    bool SwapNoNeededSources()
    {
        return prefs->SwapNoNeededSources;
    }
    bool DropFullQueueSources()
    {
        return prefs->DropFullQueueSources;
    }
    bool DropHighQueueRankingSources()
    {
        return prefs->DropHighQueueRankingSources;
    }
    int HighQueueRanking()
    {
        return prefs->HighQueueRanking;
    }
    int GetAutoDropTimer()
    {
        return prefs->AutoDropTimer;
    }

    Preferences_Struct *prefs;

protected:
    bool SaveCats(void);
    bool LoadCats(void);
    bool LoadPreferences(void);
    void SavePreferences(void);
    bool Load_Adresses(void);
    bool Save_Adresses(void);
    bool Load_Shared_Dirs(void);
    bool Save_Shared_Dirs(void);
    void CreateUserHash();
    void SetStandartValues();
    static int GetRecommendedMaxConnections();

private:
//    char appdir[MAX_PATH];
    Preferences_Ext_Struct *prefsExt;
    char userhash[16];
    WORD m_wWinVer;
    CArray < Category_Struct *, Category_Struct *> catMap;
    // deadlake PROXYSUPPORT
    bool m_UseProxyListenPort;
    uint16_t ListenPort;
};

#endif
