// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef SERVERLIST_H
#define SERVERLIST_H

#include "mfc.h"                            // wxString POSITION - audited 4 Nov 2004
#include "server.h"
#include "opcodes.h"
#include "ServerListCtrl.h"

#include <wx/timer.h>

class CPreferences;
class Packet;

class CServerList
{
	friend class CServerListCtrl;
public:
	CServerList(CPreferences* in_prefs);
	~CServerList(void);
	bool		Init();
	bool		AddServer(CServer* in_server );
	void		RemoveServer(CServer* out_server);
	void		RemoveAllServers(void);
	bool		AddServermetToList(wxString strFile, bool merge = true);
	void		AddServersFromTextFile(wxString strFilename,bool isstaticserver=true);
	bool		SaveServermetToFile(); //<<--9/22/02
	void		ServerStats();
	void		ResetServerPos()	{serverpos = 0;}
	void		ResetSearchServerPos()	{searchserverpos = 0;}
	CServer*	GetNextServer();
	CServer*	GetNextSearchServer();
	CServer*	GetNextStatServer();
	CServer*	GetServerAt(uint32_t pos)	{return list.GetAt(list.FindIndex(pos));}
	uint32_t		GetServerCount()	{return list.GetCount();}
	CServer*	GetNextServer(CServer* lastserver); // slow
	CServer*	GetServerByIP(wxUint32 nIP);
	CServer*	GetServerByIP(wxUint32 nIP,wxUint16 nPort);
	CServer*	GetServerByAddress(char* address, uint16_t port);
	bool		IsGoodServerIP( CServer* in_server ); //<<--
	void		GetStatus( uint32_t &total, uint32_t &failed, uint32_t &user, uint32_t &file, uint32_t &tuser, uint32_t &tfile, float &occ);
	void		GetUserFileStatus( uint32_t &user, uint32_t &file);
	bool		BroadCastPacket(Packet* packet); //send Packet to all server in the list
	void		CancelUDPBroadcast();
	void		Sort();
	void		MoveServerDown(CServer* aServer);
	uint32_t		GetServerPostion()	{return serverpos;}
	void		SetServerPosition(uint32_t newPosition) { if (newPosition<(uint32_t)list.GetCount() ) serverpos=newPosition; else serverpos=0;}
	uint32_t		GetDeletedServerCount()		{return delservercount;}
	void		Process();
	void		SendNextPacket();

	//void static CALLBACK UDPTimerProc(HWND hwnd, UINT uMsg,UINT_PTR idEvent,DWORD dwTime);
protected:
	void		AutoUpdate();
private:
	uint32_t		serverpos;
	uint32_t		searchserverpos;
	uint32_t		statserverpos;
	uint8_t		version;
	uint32_t		servercount;
	CTypedPtrList<CPtrList, CServer*>	list;
	CPreferences*	app_prefs;
	//uint32_t		udp_timer;
	wxTimer         udp_timer;
	POSITION	broadcastpos;
	Packet*		broadcastpacket;
	uint32_t		delservercount;
	uint32_t		m_nLastSaved;
};

#endif
