/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/bgp_xif.cc,v 1.56 2009/01/05 18:31:12 jtc Exp $"

#include "bgp_xif.hh"

bool
XrlBgpV0p3Client::send_get_bgp_version(
	const char*	dst_xrl_target_name,
	const GetBgpVersionCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_bgp_version");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_bgp_version, cb));
}


/* Unmarshall get_bgp_version */
void
XrlBgpV0p3Client::unmarshall_get_bgp_version(
	const XrlError&	e,
	XrlArgs*	a,
	GetBgpVersionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t version;
    try {
	a->get("version", version);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &version);
}

bool
XrlBgpV0p3Client::send_local_config(
	const char*	dst_xrl_target_name,
	const string&	as,
	const IPv4&	id,
	const bool&	use_4byte_asnums,
	const LocalConfigCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/local_config");
        x->args().add(XrlAtom(as));
        x->args().add(XrlAtom(id));
        x->args().add(XrlAtom(use_4byte_asnums));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, as);
    x->args().set_arg(1, id);
    x->args().set_arg(2, use_4byte_asnums);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_local_config, cb));
}


/* Unmarshall local_config */
void
XrlBgpV0p3Client::unmarshall_local_config(
	const XrlError&	e,
	XrlArgs*	a,
	LocalConfigCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_local_as(
	const char*	dst_xrl_target_name,
	const string&	as,
	const SetLocalAsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_local_as");
        x->args().add(XrlAtom(as));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, as);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_local_as, cb));
}


/* Unmarshall set_local_as */
void
XrlBgpV0p3Client::unmarshall_set_local_as(
	const XrlError&	e,
	XrlArgs*	a,
	SetLocalAsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_4byte_as_support(
	const char*	dst_xrl_target_name,
	const bool&	enable,
	const Set4ByteAsSupportCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_4byte_as_support");
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, enable);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_4byte_as_support, cb));
}


/* Unmarshall set_4byte_as_support */
void
XrlBgpV0p3Client::unmarshall_set_4byte_as_support(
	const XrlError&	e,
	XrlArgs*	a,
	Set4ByteAsSupportCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_get_local_as(
	const char*	dst_xrl_target_name,
	const GetLocalAsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_local_as");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_local_as, cb));
}


/* Unmarshall get_local_as */
void
XrlBgpV0p3Client::unmarshall_get_local_as(
	const XrlError&	e,
	XrlArgs*	a,
	GetLocalAsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    string as;
    try {
	a->get("as", as);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &as);
}

bool
XrlBgpV0p3Client::send_set_bgp_id(
	const char*	dst_xrl_target_name,
	const IPv4&	id,
	const SetBgpIdCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_bgp_id");
        x->args().add(XrlAtom(id));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, id);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_bgp_id, cb));
}


/* Unmarshall set_bgp_id */
void
XrlBgpV0p3Client::unmarshall_set_bgp_id(
	const XrlError&	e,
	XrlArgs*	a,
	SetBgpIdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_get_bgp_id(
	const char*	dst_xrl_target_name,
	const GetBgpIdCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_bgp_id");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_bgp_id, cb));
}


/* Unmarshall get_bgp_id */
void
XrlBgpV0p3Client::unmarshall_get_bgp_id(
	const XrlError&	e,
	XrlArgs*	a,
	GetBgpIdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    IPv4 id;
    try {
	a->get("id", id);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &id);
}

bool
XrlBgpV0p3Client::send_set_confederation_identifier(
	const char*	dst_xrl_target_name,
	const string&	as,
	const bool&	disable,
	const SetConfederationIdentifierCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_confederation_identifier");
        x->args().add(XrlAtom(as));
        x->args().add(XrlAtom(disable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, as);
    x->args().set_arg(1, disable);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_confederation_identifier, cb));
}


/* Unmarshall set_confederation_identifier */
void
XrlBgpV0p3Client::unmarshall_set_confederation_identifier(
	const XrlError&	e,
	XrlArgs*	a,
	SetConfederationIdentifierCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_cluster_id(
	const char*	dst_xrl_target_name,
	const IPv4&	cluster_id,
	const bool&	disable,
	const SetClusterIdCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_cluster_id");
        x->args().add(XrlAtom(cluster_id));
        x->args().add(XrlAtom(disable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, cluster_id);
    x->args().set_arg(1, disable);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_cluster_id, cb));
}


/* Unmarshall set_cluster_id */
void
XrlBgpV0p3Client::unmarshall_set_cluster_id(
	const XrlError&	e,
	XrlArgs*	a,
	SetClusterIdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_damping(
	const char*	dst_xrl_target_name,
	const uint32_t&	half_life,
	const uint32_t&	max_suppress,
	const uint32_t&	reuse,
	const uint32_t&	suppress,
	const bool&	disable,
	const SetDampingCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_damping");
        x->args().add(XrlAtom(half_life));
        x->args().add(XrlAtom(max_suppress));
        x->args().add(XrlAtom(reuse));
        x->args().add(XrlAtom(suppress));
        x->args().add(XrlAtom(disable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, half_life);
    x->args().set_arg(1, max_suppress);
    x->args().set_arg(2, reuse);
    x->args().set_arg(3, suppress);
    x->args().set_arg(4, disable);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_damping, cb));
}


/* Unmarshall set_damping */
void
XrlBgpV0p3Client::unmarshall_set_damping(
	const XrlError&	e,
	XrlArgs*	a,
	SetDampingCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_add_peer(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const string&	as,
	const IPv4&	next_hop,
	const uint32_t&	holdtime,
	const AddPeerCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/add_peer");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(as));
        x->args().add(XrlAtom(next_hop));
        x->args().add(XrlAtom(holdtime));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, as);
    x->args().set_arg(5, next_hop);
    x->args().set_arg(6, holdtime);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_add_peer, cb));
}


/* Unmarshall add_peer */
void
XrlBgpV0p3Client::unmarshall_add_peer(
	const XrlError&	e,
	XrlArgs*	a,
	AddPeerCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_delete_peer(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const DeletePeerCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/delete_peer");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_delete_peer, cb));
}


/* Unmarshall delete_peer */
void
XrlBgpV0p3Client::unmarshall_delete_peer(
	const XrlError&	e,
	XrlArgs*	a,
	DeletePeerCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_enable_peer(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const EnablePeerCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/enable_peer");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_enable_peer, cb));
}


/* Unmarshall enable_peer */
void
XrlBgpV0p3Client::unmarshall_enable_peer(
	const XrlError&	e,
	XrlArgs*	a,
	EnablePeerCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_disable_peer(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const DisablePeerCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/disable_peer");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_disable_peer, cb));
}


/* Unmarshall disable_peer */
void
XrlBgpV0p3Client::unmarshall_disable_peer(
	const XrlError&	e,
	XrlArgs*	a,
	DisablePeerCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_change_local_ip(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const string&	new_local_ip,
	const ChangeLocalIpCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/change_local_ip");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(new_local_ip));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, new_local_ip);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_change_local_ip, cb));
}


/* Unmarshall change_local_ip */
void
XrlBgpV0p3Client::unmarshall_change_local_ip(
	const XrlError&	e,
	XrlArgs*	a,
	ChangeLocalIpCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_change_local_port(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const uint32_t&	new_local_port,
	const ChangeLocalPortCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/change_local_port");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(new_local_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, new_local_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_change_local_port, cb));
}


/* Unmarshall change_local_port */
void
XrlBgpV0p3Client::unmarshall_change_local_port(
	const XrlError&	e,
	XrlArgs*	a,
	ChangeLocalPortCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_change_peer_port(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const uint32_t&	new_peer_port,
	const ChangePeerPortCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/change_peer_port");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(new_peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, new_peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_change_peer_port, cb));
}


/* Unmarshall change_peer_port */
void
XrlBgpV0p3Client::unmarshall_change_peer_port(
	const XrlError&	e,
	XrlArgs*	a,
	ChangePeerPortCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_peer_as(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const string&	peer_as,
	const SetPeerAsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_peer_as");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(peer_as));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, peer_as);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_peer_as, cb));
}


/* Unmarshall set_peer_as */
void
XrlBgpV0p3Client::unmarshall_set_peer_as(
	const XrlError&	e,
	XrlArgs*	a,
	SetPeerAsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_holdtime(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const uint32_t&	holdtime,
	const SetHoldtimeCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_holdtime");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(holdtime));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, holdtime);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_holdtime, cb));
}


/* Unmarshall set_holdtime */
void
XrlBgpV0p3Client::unmarshall_set_holdtime(
	const XrlError&	e,
	XrlArgs*	a,
	SetHoldtimeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_delay_open_time(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const uint32_t&	delay_open_time,
	const SetDelayOpenTimeCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_delay_open_time");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(delay_open_time));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, delay_open_time);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_delay_open_time, cb));
}


/* Unmarshall set_delay_open_time */
void
XrlBgpV0p3Client::unmarshall_set_delay_open_time(
	const XrlError&	e,
	XrlArgs*	a,
	SetDelayOpenTimeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_route_reflector_client(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const bool&	state,
	const SetRouteReflectorClientCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_route_reflector_client");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(state));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, state);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_route_reflector_client, cb));
}


/* Unmarshall set_route_reflector_client */
void
XrlBgpV0p3Client::unmarshall_set_route_reflector_client(
	const XrlError&	e,
	XrlArgs*	a,
	SetRouteReflectorClientCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_confederation_member(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const bool&	state,
	const SetConfederationMemberCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_confederation_member");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(state));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, state);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_confederation_member, cb));
}


/* Unmarshall set_confederation_member */
void
XrlBgpV0p3Client::unmarshall_set_confederation_member(
	const XrlError&	e,
	XrlArgs*	a,
	SetConfederationMemberCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_prefix_limit(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const uint32_t&	maximum,
	const bool&	state,
	const SetPrefixLimitCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_prefix_limit");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(maximum));
        x->args().add(XrlAtom(state));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, maximum);
    x->args().set_arg(5, state);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_prefix_limit, cb));
}


/* Unmarshall set_prefix_limit */
void
XrlBgpV0p3Client::unmarshall_set_prefix_limit(
	const XrlError&	e,
	XrlArgs*	a,
	SetPrefixLimitCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_nexthop4(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const IPv4&	next_hop,
	const SetNexthop4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_nexthop4");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(next_hop));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, next_hop);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_nexthop4, cb));
}


/* Unmarshall set_nexthop4 */
void
XrlBgpV0p3Client::unmarshall_set_nexthop4(
	const XrlError&	e,
	XrlArgs*	a,
	SetNexthop4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_nexthop6(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const IPv6&	next_hop,
	const SetNexthop6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_nexthop6");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(next_hop));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, next_hop);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_nexthop6, cb));
}


/* Unmarshall set_nexthop6 */
void
XrlBgpV0p3Client::unmarshall_set_nexthop6(
	const XrlError&	e,
	XrlArgs*	a,
	SetNexthop6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_get_nexthop6(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const GetNexthop6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_nexthop6");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_nexthop6, cb));
}


/* Unmarshall get_nexthop6 */
void
XrlBgpV0p3Client::unmarshall_get_nexthop6(
	const XrlError&	e,
	XrlArgs*	a,
	GetNexthop6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    IPv6 next_hop;
    try {
	a->get("next_hop", next_hop);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &next_hop);
}

bool
XrlBgpV0p3Client::send_set_peer_state(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const bool&	toggle,
	const SetPeerStateCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_peer_state");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(toggle));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, toggle);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_peer_state, cb));
}


/* Unmarshall set_peer_state */
void
XrlBgpV0p3Client::unmarshall_set_peer_state(
	const XrlError&	e,
	XrlArgs*	a,
	SetPeerStateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_peer_md5_password(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const string&	password,
	const SetPeerMd5PasswordCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_peer_md5_password");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(password));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, password);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_peer_md5_password, cb));
}


/* Unmarshall set_peer_md5_password */
void
XrlBgpV0p3Client::unmarshall_set_peer_md5_password(
	const XrlError&	e,
	XrlArgs*	a,
	SetPeerMd5PasswordCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_activate(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const ActivateCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/activate");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_activate, cb));
}


/* Unmarshall activate */
void
XrlBgpV0p3Client::unmarshall_activate(
	const XrlError&	e,
	XrlArgs*	a,
	ActivateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_set_parameter(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const string&	parameter,
	const bool&	toggle,
	const SetParameterCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/set_parameter");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(parameter));
        x->args().add(XrlAtom(toggle));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, parameter);
    x->args().set_arg(5, toggle);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_set_parameter, cb));
}


/* Unmarshall set_parameter */
void
XrlBgpV0p3Client::unmarshall_set_parameter(
	const XrlError&	e,
	XrlArgs*	a,
	SetParameterCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_next_hop_rewrite_filter(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const IPv4&	next_hop,
	const NextHopRewriteFilterCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/next_hop_rewrite_filter");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
        x->args().add(XrlAtom(next_hop));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);
    x->args().set_arg(4, next_hop);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_next_hop_rewrite_filter, cb));
}


/* Unmarshall next_hop_rewrite_filter */
void
XrlBgpV0p3Client::unmarshall_next_hop_rewrite_filter(
	const XrlError&	e,
	XrlArgs*	a,
	NextHopRewriteFilterCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_originate_route4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	nlri,
	const IPv4&	next_hop,
	const bool&	unicast,
	const bool&	multicast,
	const OriginateRoute4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/originate_route4");
        x->args().add(XrlAtom(nlri));
        x->args().add(XrlAtom(next_hop));
        x->args().add(XrlAtom(unicast));
        x->args().add(XrlAtom(multicast));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, nlri);
    x->args().set_arg(1, next_hop);
    x->args().set_arg(2, unicast);
    x->args().set_arg(3, multicast);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_originate_route4, cb));
}


/* Unmarshall originate_route4 */
void
XrlBgpV0p3Client::unmarshall_originate_route4(
	const XrlError&	e,
	XrlArgs*	a,
	OriginateRoute4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_originate_route6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	nlri,
	const IPv6&	next_hop,
	const bool&	unicast,
	const bool&	multicast,
	const OriginateRoute6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/originate_route6");
        x->args().add(XrlAtom(nlri));
        x->args().add(XrlAtom(next_hop));
        x->args().add(XrlAtom(unicast));
        x->args().add(XrlAtom(multicast));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, nlri);
    x->args().set_arg(1, next_hop);
    x->args().set_arg(2, unicast);
    x->args().set_arg(3, multicast);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_originate_route6, cb));
}


/* Unmarshall originate_route6 */
void
XrlBgpV0p3Client::unmarshall_originate_route6(
	const XrlError&	e,
	XrlArgs*	a,
	OriginateRoute6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_withdraw_route4(
	const char*	dst_xrl_target_name,
	const IPv4Net&	nlri,
	const bool&	unicast,
	const bool&	multicast,
	const WithdrawRoute4CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/withdraw_route4");
        x->args().add(XrlAtom(nlri));
        x->args().add(XrlAtom(unicast));
        x->args().add(XrlAtom(multicast));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, nlri);
    x->args().set_arg(1, unicast);
    x->args().set_arg(2, multicast);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_withdraw_route4, cb));
}


/* Unmarshall withdraw_route4 */
void
XrlBgpV0p3Client::unmarshall_withdraw_route4(
	const XrlError&	e,
	XrlArgs*	a,
	WithdrawRoute4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_withdraw_route6(
	const char*	dst_xrl_target_name,
	const IPv6Net&	nlri,
	const bool&	unicast,
	const bool&	multicast,
	const WithdrawRoute6CB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/withdraw_route6");
        x->args().add(XrlAtom(nlri));
        x->args().add(XrlAtom(unicast));
        x->args().add(XrlAtom(multicast));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, nlri);
    x->args().set_arg(1, unicast);
    x->args().set_arg(2, multicast);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_withdraw_route6, cb));
}


/* Unmarshall withdraw_route6 */
void
XrlBgpV0p3Client::unmarshall_withdraw_route6(
	const XrlError&	e,
	XrlArgs*	a,
	WithdrawRoute6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_trace(
	const char*	dst_xrl_target_name,
	const string&	tvar,
	const bool&	enable,
	const TraceCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/trace");
        x->args().add(XrlAtom(tvar));
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tvar);
    x->args().set_arg(1, enable);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_trace, cb));
}


/* Unmarshall trace */
void
XrlBgpV0p3Client::unmarshall_trace(
	const XrlError&	e,
	XrlArgs*	a,
	TraceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_get_peer_list_start(
	const char*	dst_xrl_target_name,
	const GetPeerListStartCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_peer_list_start");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_peer_list_start, cb));
}


/* Unmarshall get_peer_list_start */
void
XrlBgpV0p3Client::unmarshall_get_peer_list_start(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerListStartCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    uint32_t token;
    bool more;
    try {
	a->get("token", token);
	a->get("more", more);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &token, &more);
}

bool
XrlBgpV0p3Client::send_get_peer_list_next(
	const char*	dst_xrl_target_name,
	const uint32_t&	token,
	const GetPeerListNextCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_peer_list_next");
        x->args().add(XrlAtom(token));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, token);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_peer_list_next, cb));
}


/* Unmarshall get_peer_list_next */
void
XrlBgpV0p3Client::unmarshall_get_peer_list_next(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerListNextCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(5));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    string local_ip;
    uint32_t local_port;
    string peer_ip;
    uint32_t peer_port;
    bool more;
    try {
	a->get("local_ip", local_ip);
	a->get("local_port", local_port);
	a->get("peer_ip", peer_ip);
	a->get("peer_port", peer_port);
	a->get("more", more);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &local_ip, &local_port, &peer_ip, &peer_port, &more);
}

bool
XrlBgpV0p3Client::send_get_peer_id(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const GetPeerIdCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_peer_id");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_peer_id, cb));
}


/* Unmarshall get_peer_id */
void
XrlBgpV0p3Client::unmarshall_get_peer_id(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerIdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    IPv4 peer_id;
    try {
	a->get("peer_id", peer_id);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &peer_id);
}

bool
XrlBgpV0p3Client::send_get_peer_status(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const GetPeerStatusCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_peer_status");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_peer_status, cb));
}


/* Unmarshall get_peer_status */
void
XrlBgpV0p3Client::unmarshall_get_peer_status(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerStatusCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    uint32_t peer_state;
    uint32_t admin_status;
    try {
	a->get("peer_state", peer_state);
	a->get("admin_status", admin_status);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &peer_state, &admin_status);
}

bool
XrlBgpV0p3Client::send_get_peer_negotiated_version(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const GetPeerNegotiatedVersionCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_peer_negotiated_version");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_peer_negotiated_version, cb));
}


/* Unmarshall get_peer_negotiated_version */
void
XrlBgpV0p3Client::unmarshall_get_peer_negotiated_version(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerNegotiatedVersionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    int32_t neg_version;
    try {
	a->get("neg_version", neg_version);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &neg_version);
}

bool
XrlBgpV0p3Client::send_get_peer_as(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const GetPeerAsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_peer_as");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_peer_as, cb));
}


/* Unmarshall get_peer_as */
void
XrlBgpV0p3Client::unmarshall_get_peer_as(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerAsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    string peer_as;
    try {
	a->get("peer_as", peer_as);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &peer_as);
}

bool
XrlBgpV0p3Client::send_get_peer_msg_stats(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const GetPeerMsgStatsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_peer_msg_stats");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_peer_msg_stats, cb));
}


/* Unmarshall get_peer_msg_stats */
void
XrlBgpV0p3Client::unmarshall_get_peer_msg_stats(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerMsgStatsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(6));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    uint32_t in_updates;
    uint32_t out_updates;
    uint32_t in_msgs;
    uint32_t out_msgs;
    uint32_t last_error;
    uint32_t in_update_elapsed;
    try {
	a->get("in_updates", in_updates);
	a->get("out_updates", out_updates);
	a->get("in_msgs", in_msgs);
	a->get("out_msgs", out_msgs);
	a->get("last_error", last_error);
	a->get("in_update_elapsed", in_update_elapsed);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &in_updates, &out_updates, &in_msgs, &out_msgs, &last_error, &in_update_elapsed);
}

bool
XrlBgpV0p3Client::send_get_peer_established_stats(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const GetPeerEstablishedStatsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_peer_established_stats");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_peer_established_stats, cb));
}


/* Unmarshall get_peer_established_stats */
void
XrlBgpV0p3Client::unmarshall_get_peer_established_stats(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerEstablishedStatsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    uint32_t transitions;
    uint32_t established_time;
    try {
	a->get("transitions", transitions);
	a->get("established_time", established_time);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &transitions, &established_time);
}

bool
XrlBgpV0p3Client::send_get_peer_timer_config(
	const char*	dst_xrl_target_name,
	const string&	local_ip,
	const uint32_t&	local_port,
	const string&	peer_ip,
	const uint32_t&	peer_port,
	const GetPeerTimerConfigCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_peer_timer_config");
        x->args().add(XrlAtom(local_ip));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(peer_ip));
        x->args().add(XrlAtom(peer_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, local_ip);
    x->args().set_arg(1, local_port);
    x->args().set_arg(2, peer_ip);
    x->args().set_arg(3, peer_port);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_peer_timer_config, cb));
}


/* Unmarshall get_peer_timer_config */
void
XrlBgpV0p3Client::unmarshall_get_peer_timer_config(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerTimerConfigCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(7));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    uint32_t retry_interval;
    uint32_t hold_time;
    uint32_t keep_alive;
    uint32_t hold_time_conf;
    uint32_t keep_alive_conf;
    uint32_t min_as_orgination_interval;
    uint32_t min_route_adv_interval;
    try {
	a->get("retry_interval", retry_interval);
	a->get("hold_time", hold_time);
	a->get("keep_alive", keep_alive);
	a->get("hold_time_conf", hold_time_conf);
	a->get("keep_alive_conf", keep_alive_conf);
	a->get("min_as_orgination_interval", min_as_orgination_interval);
	a->get("min_route_adv_interval", min_route_adv_interval);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &retry_interval, &hold_time, &keep_alive, &hold_time_conf, &keep_alive_conf, &min_as_orgination_interval, &min_route_adv_interval);
}

bool
XrlBgpV0p3Client::send_register_rib(
	const char*	dst_xrl_target_name,
	const string&	name,
	const RegisterRibCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/register_rib");
        x->args().add(XrlAtom(name));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, name);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_register_rib, cb));
}


/* Unmarshall register_rib */
void
XrlBgpV0p3Client::unmarshall_register_rib(
	const XrlError&	e,
	XrlArgs*	a,
	RegisterRibCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlBgpV0p3Client::send_get_v4_route_list_start(
	const char*	dst_xrl_target_name,
	const IPv4Net&	net,
	const bool&	unicast,
	const bool&	multicast,
	const GetV4RouteListStartCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_v4_route_list_start");
        x->args().add(XrlAtom(net));
        x->args().add(XrlAtom(unicast));
        x->args().add(XrlAtom(multicast));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, net);
    x->args().set_arg(1, unicast);
    x->args().set_arg(2, multicast);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_v4_route_list_start, cb));
}


/* Unmarshall get_v4_route_list_start */
void
XrlBgpV0p3Client::unmarshall_get_v4_route_list_start(
	const XrlError&	e,
	XrlArgs*	a,
	GetV4RouteListStartCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t token;
    try {
	a->get("token", token);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &token);
}

bool
XrlBgpV0p3Client::send_get_v6_route_list_start(
	const char*	dst_xrl_target_name,
	const IPv6Net&	net,
	const bool&	unicast,
	const bool&	multicast,
	const GetV6RouteListStartCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_v6_route_list_start");
        x->args().add(XrlAtom(net));
        x->args().add(XrlAtom(unicast));
        x->args().add(XrlAtom(multicast));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, net);
    x->args().set_arg(1, unicast);
    x->args().set_arg(2, multicast);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_v6_route_list_start, cb));
}


/* Unmarshall get_v6_route_list_start */
void
XrlBgpV0p3Client::unmarshall_get_v6_route_list_start(
	const XrlError&	e,
	XrlArgs*	a,
	GetV6RouteListStartCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t token;
    try {
	a->get("token", token);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &token);
}

bool
XrlBgpV0p3Client::send_get_v4_route_list_next(
	const char*	dst_xrl_target_name,
	const uint32_t&	token,
	const GetV4RouteListNextCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_v4_route_list_next");
        x->args().add(XrlAtom(token));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, token);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_v4_route_list_next, cb));
}


/* Unmarshall get_v4_route_list_next */
void
XrlBgpV0p3Client::unmarshall_get_v4_route_list_next(
	const XrlError&	e,
	XrlArgs*	a,
	GetV4RouteListNextCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 14) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(14));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    IPv4 peer_id;
    IPv4Net net;
    uint32_t best_and_origin;
    vector<uint8_t> aspath;
    IPv4 nexthop;
    int32_t med;
    int32_t localpref;
    int32_t atomic_agg;
    vector<uint8_t> aggregator;
    int32_t calc_localpref;
    vector<uint8_t> attr_unknown;
    bool valid;
    bool unicast;
    bool multicast;
    try {
	a->get("peer_id", peer_id);
	a->get("net", net);
	a->get("best_and_origin", best_and_origin);
	a->get("aspath", aspath);
	a->get("nexthop", nexthop);
	a->get("med", med);
	a->get("localpref", localpref);
	a->get("atomic_agg", atomic_agg);
	a->get("aggregator", aggregator);
	a->get("calc_localpref", calc_localpref);
	a->get("attr_unknown", attr_unknown);
	a->get("valid", valid);
	a->get("unicast", unicast);
	a->get("multicast", multicast);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &peer_id, &net, &best_and_origin, &aspath, &nexthop, &med, &localpref, &atomic_agg, &aggregator, &calc_localpref, &attr_unknown, &valid, &unicast, &multicast);
}

bool
XrlBgpV0p3Client::send_get_v6_route_list_next(
	const char*	dst_xrl_target_name,
	const uint32_t&	token,
	const GetV6RouteListNextCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "bgp/0.3/get_v6_route_list_next");
        x->args().add(XrlAtom(token));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, token);

    return _sender->send(*x, callback(this, &XrlBgpV0p3Client::unmarshall_get_v6_route_list_next, cb));
}


/* Unmarshall get_v6_route_list_next */
void
XrlBgpV0p3Client::unmarshall_get_v6_route_list_next(
	const XrlError&	e,
	XrlArgs*	a,
	GetV6RouteListNextCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 14) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(14));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    IPv4 peer_id;
    IPv6Net net;
    uint32_t best_and_origin;
    vector<uint8_t> aspath;
    IPv6 nexthop;
    int32_t med;
    int32_t localpref;
    int32_t atomic_agg;
    vector<uint8_t> aggregator;
    int32_t calc_localpref;
    vector<uint8_t> attr_unknown;
    bool valid;
    bool unicast;
    bool multicast;
    try {
	a->get("peer_id", peer_id);
	a->get("net", net);
	a->get("best_and_origin", best_and_origin);
	a->get("aspath", aspath);
	a->get("nexthop", nexthop);
	a->get("med", med);
	a->get("localpref", localpref);
	a->get("atomic_agg", atomic_agg);
	a->get("aggregator", aggregator);
	a->get("calc_localpref", calc_localpref);
	a->get("attr_unknown", attr_unknown);
	a->get("valid", valid);
	a->get("unicast", unicast);
	a->get("multicast", multicast);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &peer_id, &net, &best_and_origin, &aspath, &nexthop, &med, &localpref, &atomic_agg, &aggregator, &calc_localpref, &attr_unknown, &valid, &unicast, &multicast);
}
