/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/olsr4_xif.cc,v 1.6 2009/01/05 18:31:13 jtc Exp $"

#include "olsr4_xif.hh"

bool
XrlOlsr4V0p1Client::send_trace(
	const char*	dst_xrl_target_name,
	const string&	tvar,
	const bool&	enable,
	const TraceCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/trace");
        x->args().add(XrlAtom(tvar));
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tvar);
    x->args().set_arg(1, enable);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_trace, cb));
}


/* Unmarshall trace */
void
XrlOlsr4V0p1Client::unmarshall_trace(
	const XrlError&	e,
	XrlArgs*	a,
	TraceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_clear_database(
	const char*	dst_xrl_target_name,
	const ClearDatabaseCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/clear_database");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_clear_database, cb));
}


/* Unmarshall clear_database */
void
XrlOlsr4V0p1Client::unmarshall_clear_database(
	const XrlError&	e,
	XrlArgs*	a,
	ClearDatabaseCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_set_willingness(
	const char*	dst_xrl_target_name,
	const uint32_t&	willingness,
	const SetWillingnessCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_willingness");
        x->args().add(XrlAtom(willingness));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, willingness);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_willingness, cb));
}


/* Unmarshall set_willingness */
void
XrlOlsr4V0p1Client::unmarshall_set_willingness(
	const XrlError&	e,
	XrlArgs*	a,
	SetWillingnessCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_willingness(
	const char*	dst_xrl_target_name,
	const GetWillingnessCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_willingness");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_willingness, cb));
}


/* Unmarshall get_willingness */
void
XrlOlsr4V0p1Client::unmarshall_get_willingness(
	const XrlError&	e,
	XrlArgs*	a,
	GetWillingnessCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t willingness;
    try {
	a->get("willingness", willingness);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &willingness);
}

bool
XrlOlsr4V0p1Client::send_set_mpr_coverage(
	const char*	dst_xrl_target_name,
	const uint32_t&	coverage,
	const SetMprCoverageCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_mpr_coverage");
        x->args().add(XrlAtom(coverage));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, coverage);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_mpr_coverage, cb));
}


/* Unmarshall set_mpr_coverage */
void
XrlOlsr4V0p1Client::unmarshall_set_mpr_coverage(
	const XrlError&	e,
	XrlArgs*	a,
	SetMprCoverageCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_mpr_coverage(
	const char*	dst_xrl_target_name,
	const GetMprCoverageCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_mpr_coverage");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_mpr_coverage, cb));
}


/* Unmarshall get_mpr_coverage */
void
XrlOlsr4V0p1Client::unmarshall_get_mpr_coverage(
	const XrlError&	e,
	XrlArgs*	a,
	GetMprCoverageCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t coverage;
    try {
	a->get("coverage", coverage);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &coverage);
}

bool
XrlOlsr4V0p1Client::send_set_tc_redundancy(
	const char*	dst_xrl_target_name,
	const string&	redundancy,
	const SetTcRedundancyCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_tc_redundancy");
        x->args().add(XrlAtom(redundancy));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, redundancy);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_tc_redundancy, cb));
}


/* Unmarshall set_tc_redundancy */
void
XrlOlsr4V0p1Client::unmarshall_set_tc_redundancy(
	const XrlError&	e,
	XrlArgs*	a,
	SetTcRedundancyCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_tc_redundancy(
	const char*	dst_xrl_target_name,
	const GetTcRedundancyCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_tc_redundancy");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_tc_redundancy, cb));
}


/* Unmarshall get_tc_redundancy */
void
XrlOlsr4V0p1Client::unmarshall_get_tc_redundancy(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcRedundancyCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    string redundancy;
    try {
	a->get("redundancy", redundancy);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &redundancy);
}

bool
XrlOlsr4V0p1Client::send_set_tc_fisheye(
	const char*	dst_xrl_target_name,
	const bool&	enabled,
	const SetTcFisheyeCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_tc_fisheye");
        x->args().add(XrlAtom(enabled));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, enabled);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_tc_fisheye, cb));
}


/* Unmarshall set_tc_fisheye */
void
XrlOlsr4V0p1Client::unmarshall_set_tc_fisheye(
	const XrlError&	e,
	XrlArgs*	a,
	SetTcFisheyeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_tc_fisheye(
	const char*	dst_xrl_target_name,
	const GetTcFisheyeCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_tc_fisheye");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_tc_fisheye, cb));
}


/* Unmarshall get_tc_fisheye */
void
XrlOlsr4V0p1Client::unmarshall_get_tc_fisheye(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcFisheyeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlOlsr4V0p1Client::send_set_hna_base_cost(
	const char*	dst_xrl_target_name,
	const uint32_t&	metric,
	const SetHnaBaseCostCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_hna_base_cost");
        x->args().add(XrlAtom(metric));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, metric);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_hna_base_cost, cb));
}


/* Unmarshall set_hna_base_cost */
void
XrlOlsr4V0p1Client::unmarshall_set_hna_base_cost(
	const XrlError&	e,
	XrlArgs*	a,
	SetHnaBaseCostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_hna_base_cost(
	const char*	dst_xrl_target_name,
	const GetHnaBaseCostCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_hna_base_cost");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_hna_base_cost, cb));
}


/* Unmarshall get_hna_base_cost */
void
XrlOlsr4V0p1Client::unmarshall_get_hna_base_cost(
	const XrlError&	e,
	XrlArgs*	a,
	GetHnaBaseCostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t metric;
    try {
	a->get("metric", metric);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &metric);
}

bool
XrlOlsr4V0p1Client::send_set_hello_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetHelloIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_hello_interval");
        x->args().add(XrlAtom(interval));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, interval);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_hello_interval, cb));
}


/* Unmarshall set_hello_interval */
void
XrlOlsr4V0p1Client::unmarshall_set_hello_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetHelloIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_hello_interval(
	const char*	dst_xrl_target_name,
	const GetHelloIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_hello_interval");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_hello_interval, cb));
}


/* Unmarshall get_hello_interval */
void
XrlOlsr4V0p1Client::unmarshall_get_hello_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetHelloIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval;
    try {
	a->get("interval", interval);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval);
}

bool
XrlOlsr4V0p1Client::send_set_refresh_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetRefreshIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_refresh_interval");
        x->args().add(XrlAtom(interval));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, interval);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_refresh_interval, cb));
}


/* Unmarshall set_refresh_interval */
void
XrlOlsr4V0p1Client::unmarshall_set_refresh_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetRefreshIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_refresh_interval(
	const char*	dst_xrl_target_name,
	const GetRefreshIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_refresh_interval");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_refresh_interval, cb));
}


/* Unmarshall get_refresh_interval */
void
XrlOlsr4V0p1Client::unmarshall_get_refresh_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetRefreshIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval;
    try {
	a->get("interval", interval);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval);
}

bool
XrlOlsr4V0p1Client::send_set_tc_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetTcIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_tc_interval");
        x->args().add(XrlAtom(interval));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, interval);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_tc_interval, cb));
}


/* Unmarshall set_tc_interval */
void
XrlOlsr4V0p1Client::unmarshall_set_tc_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetTcIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_tc_interval(
	const char*	dst_xrl_target_name,
	const GetTcIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_tc_interval");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_tc_interval, cb));
}


/* Unmarshall get_tc_interval */
void
XrlOlsr4V0p1Client::unmarshall_get_tc_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval;
    try {
	a->get("interval", interval);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval);
}

bool
XrlOlsr4V0p1Client::send_set_mid_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetMidIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_mid_interval");
        x->args().add(XrlAtom(interval));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, interval);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_mid_interval, cb));
}


/* Unmarshall set_mid_interval */
void
XrlOlsr4V0p1Client::unmarshall_set_mid_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetMidIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_mid_interval(
	const char*	dst_xrl_target_name,
	const GetMidIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_mid_interval");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_mid_interval, cb));
}


/* Unmarshall get_mid_interval */
void
XrlOlsr4V0p1Client::unmarshall_get_mid_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetMidIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval;
    try {
	a->get("interval", interval);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval);
}

bool
XrlOlsr4V0p1Client::send_set_hna_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetHnaIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_hna_interval");
        x->args().add(XrlAtom(interval));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, interval);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_hna_interval, cb));
}


/* Unmarshall set_hna_interval */
void
XrlOlsr4V0p1Client::unmarshall_set_hna_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetHnaIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_hna_interval(
	const char*	dst_xrl_target_name,
	const GetHnaIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_hna_interval");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_hna_interval, cb));
}


/* Unmarshall get_hna_interval */
void
XrlOlsr4V0p1Client::unmarshall_get_hna_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetHnaIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval;
    try {
	a->get("interval", interval);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval);
}

bool
XrlOlsr4V0p1Client::send_set_dup_hold_time(
	const char*	dst_xrl_target_name,
	const uint32_t&	dup_hold_time,
	const SetDupHoldTimeCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_dup_hold_time");
        x->args().add(XrlAtom(dup_hold_time));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, dup_hold_time);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_dup_hold_time, cb));
}


/* Unmarshall set_dup_hold_time */
void
XrlOlsr4V0p1Client::unmarshall_set_dup_hold_time(
	const XrlError&	e,
	XrlArgs*	a,
	SetDupHoldTimeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_dup_hold_time(
	const char*	dst_xrl_target_name,
	const GetDupHoldTimeCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_dup_hold_time");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_dup_hold_time, cb));
}


/* Unmarshall get_dup_hold_time */
void
XrlOlsr4V0p1Client::unmarshall_get_dup_hold_time(
	const XrlError&	e,
	XrlArgs*	a,
	GetDupHoldTimeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t dup_hold_time;
    try {
	a->get("dup_hold_time", dup_hold_time);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &dup_hold_time);
}

bool
XrlOlsr4V0p1Client::send_set_main_address(
	const char*	dst_xrl_target_name,
	const IPv4&	addr,
	const SetMainAddressCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_main_address");
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, addr);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_main_address, cb));
}


/* Unmarshall set_main_address */
void
XrlOlsr4V0p1Client::unmarshall_set_main_address(
	const XrlError&	e,
	XrlArgs*	a,
	SetMainAddressCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_main_address(
	const char*	dst_xrl_target_name,
	const GetMainAddressCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_main_address");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_main_address, cb));
}


/* Unmarshall get_main_address */
void
XrlOlsr4V0p1Client::unmarshall_get_main_address(
	const XrlError&	e,
	XrlArgs*	a,
	GetMainAddressCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    IPv4 addr;
    try {
	a->get("addr", addr);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &addr);
}

bool
XrlOlsr4V0p1Client::send_bind_address(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const IPv4&	all_nodes_addr,
	const uint32_t&	all_nodes_port,
	const BindAddressCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/bind_address");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(local_addr));
        x->args().add(XrlAtom(local_port));
        x->args().add(XrlAtom(all_nodes_addr));
        x->args().add(XrlAtom(all_nodes_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, local_addr);
    x->args().set_arg(3, local_port);
    x->args().set_arg(4, all_nodes_addr);
    x->args().set_arg(5, all_nodes_port);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_bind_address, cb));
}


/* Unmarshall bind_address */
void
XrlOlsr4V0p1Client::unmarshall_bind_address(
	const XrlError&	e,
	XrlArgs*	a,
	BindAddressCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_unbind_address(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const UnbindAddressCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/unbind_address");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_unbind_address, cb));
}


/* Unmarshall unbind_address */
void
XrlOlsr4V0p1Client::unmarshall_unbind_address(
	const XrlError&	e,
	XrlArgs*	a,
	UnbindAddressCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_set_binding_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const bool&	enabled,
	const SetBindingEnabledCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_binding_enabled");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(enabled));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, enabled);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_binding_enabled, cb));
}


/* Unmarshall set_binding_enabled */
void
XrlOlsr4V0p1Client::unmarshall_set_binding_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	SetBindingEnabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_binding_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const GetBindingEnabledCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_binding_enabled");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_binding_enabled, cb));
}


/* Unmarshall get_binding_enabled */
void
XrlOlsr4V0p1Client::unmarshall_get_binding_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	GetBindingEnabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlOlsr4V0p1Client::send_change_local_addr_port(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const ChangeLocalAddrPortCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/change_local_addr_port");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(local_addr));
        x->args().add(XrlAtom(local_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, local_addr);
    x->args().set_arg(3, local_port);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_change_local_addr_port, cb));
}


/* Unmarshall change_local_addr_port */
void
XrlOlsr4V0p1Client::unmarshall_change_local_addr_port(
	const XrlError&	e,
	XrlArgs*	a,
	ChangeLocalAddrPortCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_change_all_nodes_addr_port(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	all_nodes_addr,
	const uint32_t&	all_nodes_port,
	const ChangeAllNodesAddrPortCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/change_all_nodes_addr_port");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(all_nodes_addr));
        x->args().add(XrlAtom(all_nodes_port));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, all_nodes_addr);
    x->args().set_arg(3, all_nodes_port);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_change_all_nodes_addr_port, cb));
}


/* Unmarshall change_all_nodes_addr_port */
void
XrlOlsr4V0p1Client::unmarshall_change_all_nodes_addr_port(
	const XrlError&	e,
	XrlArgs*	a,
	ChangeAllNodesAddrPortCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_interface_list(
	const char*	dst_xrl_target_name,
	const GetInterfaceListCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_interface_list");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_interface_list, cb));
}


/* Unmarshall get_interface_list */
void
XrlOlsr4V0p1Client::unmarshall_get_interface_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetInterfaceListCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList interfaces;
    try {
	a->get("interfaces", interfaces);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interfaces);
}

bool
XrlOlsr4V0p1Client::send_get_interface_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	faceid,
	const GetInterfaceInfoCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_interface_info");
        x->args().add(XrlAtom(faceid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, faceid);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_interface_info, cb));
}


/* Unmarshall get_interface_info */
void
XrlOlsr4V0p1Client::unmarshall_get_interface_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetInterfaceInfoCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(6));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    string ifname;
    string vifname;
    IPv4 local_addr;
    uint32_t local_port;
    IPv4 all_nodes_addr;
    uint32_t all_nodes_port;
    try {
	a->get("ifname", ifname);
	a->get("vifname", vifname);
	a->get("local_addr", local_addr);
	a->get("local_port", local_port);
	a->get("all_nodes_addr", all_nodes_addr);
	a->get("all_nodes_port", all_nodes_port);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &ifname, &vifname, &local_addr, &local_port, &all_nodes_addr, &all_nodes_port);
}

bool
XrlOlsr4V0p1Client::send_set_interface_cost(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	cost,
	const SetInterfaceCostCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/set_interface_cost");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(cost));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, cost);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_set_interface_cost, cb));
}


/* Unmarshall set_interface_cost */
void
XrlOlsr4V0p1Client::unmarshall_set_interface_cost(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceCostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOlsr4V0p1Client::send_get_interface_stats(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const GetInterfaceStatsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_interface_stats");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_interface_stats, cb));
}


/* Unmarshall get_interface_stats */
void
XrlOlsr4V0p1Client::unmarshall_get_interface_stats(
	const XrlError&	e,
	XrlArgs*	a,
	GetInterfaceStatsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(6));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    uint32_t bad_packets;
    uint32_t bad_messages;
    uint32_t messages_from_self;
    uint32_t unknown_messages;
    uint32_t duplicates;
    uint32_t forwarded;
    try {
	a->get("bad_packets", bad_packets);
	a->get("bad_messages", bad_messages);
	a->get("messages_from_self", messages_from_self);
	a->get("unknown_messages", unknown_messages);
	a->get("duplicates", duplicates);
	a->get("forwarded", forwarded);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &bad_packets, &bad_messages, &messages_from_self, &unknown_messages, &duplicates, &forwarded);
}

bool
XrlOlsr4V0p1Client::send_get_link_list(
	const char*	dst_xrl_target_name,
	const GetLinkListCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_link_list");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_link_list, cb));
}


/* Unmarshall get_link_list */
void
XrlOlsr4V0p1Client::unmarshall_get_link_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetLinkListCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList links;
    try {
	a->get("links", links);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &links);
}

bool
XrlOlsr4V0p1Client::send_get_link_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	linkid,
	const GetLinkInfoCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_link_info");
        x->args().add(XrlAtom(linkid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, linkid);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_link_info, cb));
}


/* Unmarshall get_link_info */
void
XrlOlsr4V0p1Client::unmarshall_get_link_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetLinkInfoCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(7));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    IPv4 local_addr;
    IPv4 remote_addr;
    IPv4 main_addr;
    uint32_t link_type;
    uint32_t sym_time;
    uint32_t asym_time;
    uint32_t hold_time;
    try {
	a->get("local_addr", local_addr);
	a->get("remote_addr", remote_addr);
	a->get("main_addr", main_addr);
	a->get("link_type", link_type);
	a->get("sym_time", sym_time);
	a->get("asym_time", asym_time);
	a->get("hold_time", hold_time);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &local_addr, &remote_addr, &main_addr, &link_type, &sym_time, &asym_time, &hold_time);
}

bool
XrlOlsr4V0p1Client::send_get_neighbor_list(
	const char*	dst_xrl_target_name,
	const GetNeighborListCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_neighbor_list");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_neighbor_list, cb));
}


/* Unmarshall get_neighbor_list */
void
XrlOlsr4V0p1Client::unmarshall_get_neighbor_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetNeighborListCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList neighbors;
    try {
	a->get("neighbors", neighbors);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &neighbors);
}

bool
XrlOlsr4V0p1Client::send_get_neighbor_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	nid,
	const GetNeighborInfoCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_neighbor_info");
        x->args().add(XrlAtom(nid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, nid);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_neighbor_info, cb));
}


/* Unmarshall get_neighbor_info */
void
XrlOlsr4V0p1Client::unmarshall_get_neighbor_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetNeighborInfoCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(9));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    IPv4 main_addr;
    uint32_t willingness;
    uint32_t degree;
    uint32_t link_count;
    uint32_t twohop_link_count;
    bool is_advertised;
    bool is_sym;
    bool is_mpr;
    bool is_mpr_selector;
    try {
	a->get("main_addr", main_addr);
	a->get("willingness", willingness);
	a->get("degree", degree);
	a->get("link_count", link_count);
	a->get("twohop_link_count", twohop_link_count);
	a->get("is_advertised", is_advertised);
	a->get("is_sym", is_sym);
	a->get("is_mpr", is_mpr);
	a->get("is_mpr_selector", is_mpr_selector);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &main_addr, &willingness, &degree, &link_count, &twohop_link_count, &is_advertised, &is_sym, &is_mpr, &is_mpr_selector);
}

bool
XrlOlsr4V0p1Client::send_get_twohop_link_list(
	const char*	dst_xrl_target_name,
	const GetTwohopLinkListCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_twohop_link_list");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_twohop_link_list, cb));
}


/* Unmarshall get_twohop_link_list */
void
XrlOlsr4V0p1Client::unmarshall_get_twohop_link_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetTwohopLinkListCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList twohop_links;
    try {
	a->get("twohop_links", twohop_links);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &twohop_links);
}

bool
XrlOlsr4V0p1Client::send_get_twohop_link_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	tlid,
	const GetTwohopLinkInfoCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_twohop_link_info");
        x->args().add(XrlAtom(tlid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tlid);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_twohop_link_info, cb));
}


/* Unmarshall get_twohop_link_info */
void
XrlOlsr4V0p1Client::unmarshall_get_twohop_link_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetTwohopLinkInfoCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(4));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    uint32_t last_face_id;
    IPv4 nexthop_addr;
    IPv4 dest_addr;
    uint32_t hold_time;
    try {
	a->get("last_face_id", last_face_id);
	a->get("nexthop_addr", nexthop_addr);
	a->get("dest_addr", dest_addr);
	a->get("hold_time", hold_time);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &last_face_id, &nexthop_addr, &dest_addr, &hold_time);
}

bool
XrlOlsr4V0p1Client::send_get_twohop_neighbor_list(
	const char*	dst_xrl_target_name,
	const GetTwohopNeighborListCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_twohop_neighbor_list");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_twohop_neighbor_list, cb));
}


/* Unmarshall get_twohop_neighbor_list */
void
XrlOlsr4V0p1Client::unmarshall_get_twohop_neighbor_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetTwohopNeighborListCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList twohop_neighbors;
    try {
	a->get("twohop_neighbors", twohop_neighbors);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &twohop_neighbors);
}

bool
XrlOlsr4V0p1Client::send_get_twohop_neighbor_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	tnid,
	const GetTwohopNeighborInfoCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_twohop_neighbor_info");
        x->args().add(XrlAtom(tnid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tnid);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_twohop_neighbor_info, cb));
}


/* Unmarshall get_twohop_neighbor_info */
void
XrlOlsr4V0p1Client::unmarshall_get_twohop_neighbor_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetTwohopNeighborInfoCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(5));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    IPv4 main_addr;
    bool is_strict;
    uint32_t link_count;
    uint32_t reachability;
    uint32_t coverage;
    try {
	a->get("main_addr", main_addr);
	a->get("is_strict", is_strict);
	a->get("link_count", link_count);
	a->get("reachability", reachability);
	a->get("coverage", coverage);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &main_addr, &is_strict, &link_count, &reachability, &coverage);
}

bool
XrlOlsr4V0p1Client::send_get_mid_entry_list(
	const char*	dst_xrl_target_name,
	const GetMidEntryListCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_mid_entry_list");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_mid_entry_list, cb));
}


/* Unmarshall get_mid_entry_list */
void
XrlOlsr4V0p1Client::unmarshall_get_mid_entry_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetMidEntryListCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList mid_entries;
    try {
	a->get("mid_entries", mid_entries);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &mid_entries);
}

bool
XrlOlsr4V0p1Client::send_get_mid_entry(
	const char*	dst_xrl_target_name,
	const uint32_t&	midid,
	const GetMidEntryCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_mid_entry");
        x->args().add(XrlAtom(midid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, midid);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_mid_entry, cb));
}


/* Unmarshall get_mid_entry */
void
XrlOlsr4V0p1Client::unmarshall_get_mid_entry(
	const XrlError&	e,
	XrlArgs*	a,
	GetMidEntryCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(4));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    IPv4 main_addr;
    IPv4 iface_addr;
    uint32_t distance;
    uint32_t hold_time;
    try {
	a->get("main_addr", main_addr);
	a->get("iface_addr", iface_addr);
	a->get("distance", distance);
	a->get("hold_time", hold_time);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &main_addr, &iface_addr, &distance, &hold_time);
}

bool
XrlOlsr4V0p1Client::send_get_tc_entry_list(
	const char*	dst_xrl_target_name,
	const GetTcEntryListCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_tc_entry_list");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_tc_entry_list, cb));
}


/* Unmarshall get_tc_entry_list */
void
XrlOlsr4V0p1Client::unmarshall_get_tc_entry_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcEntryListCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList tc_entries;
    try {
	a->get("tc_entries", tc_entries);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &tc_entries);
}

bool
XrlOlsr4V0p1Client::send_get_tc_entry(
	const char*	dst_xrl_target_name,
	const uint32_t&	tcid,
	const GetTcEntryCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_tc_entry");
        x->args().add(XrlAtom(tcid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tcid);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_tc_entry, cb));
}


/* Unmarshall get_tc_entry */
void
XrlOlsr4V0p1Client::unmarshall_get_tc_entry(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcEntryCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(5));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    IPv4 destination;
    IPv4 lasthop;
    uint32_t distance;
    uint32_t seqno;
    uint32_t hold_time;
    try {
	a->get("destination", destination);
	a->get("lasthop", lasthop);
	a->get("distance", distance);
	a->get("seqno", seqno);
	a->get("hold_time", hold_time);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &destination, &lasthop, &distance, &seqno, &hold_time);
}

bool
XrlOlsr4V0p1Client::send_get_hna_entry_list(
	const char*	dst_xrl_target_name,
	const GetHnaEntryListCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_hna_entry_list");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_hna_entry_list, cb));
}


/* Unmarshall get_hna_entry_list */
void
XrlOlsr4V0p1Client::unmarshall_get_hna_entry_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetHnaEntryListCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList hna_entries;
    try {
	a->get("hna_entries", hna_entries);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &hna_entries);
}

bool
XrlOlsr4V0p1Client::send_get_hna_entry(
	const char*	dst_xrl_target_name,
	const uint32_t&	hnaid,
	const GetHnaEntryCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "olsr4/0.1/get_hna_entry");
        x->args().add(XrlAtom(hnaid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, hnaid);

    return _sender->send(*x, callback(this, &XrlOlsr4V0p1Client::unmarshall_get_hna_entry, cb));
}


/* Unmarshall get_hna_entry */
void
XrlOlsr4V0p1Client::unmarshall_get_hna_entry(
	const XrlError&	e,
	XrlArgs*	a,
	GetHnaEntryCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(4));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    IPv4Net destination;
    IPv4 lasthop;
    uint32_t distance;
    uint32_t hold_time;
    try {
	a->get("destination", destination);
	a->get("lasthop", lasthop);
	a->get("distance", distance);
	a->get("hold_time", hold_time);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &destination, &lasthop, &distance, &hold_time);
}
