/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/olsr4_base.cc,v 1.6 2009/01/05 18:31:15 jtc Exp $"


#include "olsr4_base.hh"


XrlOlsr4TargetBase::XrlOlsr4TargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlOlsr4TargetBase::~XrlOlsr4TargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlOlsr4TargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlOlsr4TargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get(0, "target_class").text(),
	    xa_inputs.get(1, "target_instance").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get(0, "target_class").text(),
	    xa_inputs.get(1, "target_instance").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_socket4_user_0_1_recv_event(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "socket4_user/0.1/recv_event");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_user_0_1_recv_event(
	    xa_inputs.get(0, "sockid").text(),
	    xa_inputs.get(1, "if_name").text(),
	    xa_inputs.get(2, "vif_name").text(),
	    xa_inputs.get(3, "src_host").ipv4(),
	    xa_inputs.get(4, "src_port").uint32(),
	    xa_inputs.get(5, "data").binary());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_user/0.1/recv_event", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_socket4_user_0_1_inbound_connect_event(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "socket4_user/0.1/inbound_connect_event");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool accept;
    try {
	XrlCmdError e = socket4_user_0_1_inbound_connect_event(
	    xa_inputs.get(0, "sockid").text(),
	    xa_inputs.get(1, "src_host").ipv4(),
	    xa_inputs.get(2, "src_port").uint32(),
	    xa_inputs.get(3, "new_sockid").text(),
	    accept);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_user/0.1/inbound_connect_event", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("accept", accept);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_socket4_user_0_1_outgoing_connect_event(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "socket4_user/0.1/outgoing_connect_event");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_user_0_1_outgoing_connect_event(
	    xa_inputs.get(0, "sockid").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_user/0.1/outgoing_connect_event", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_socket4_user_0_1_error_event(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket4_user/0.1/error_event");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_user_0_1_error_event(
	    xa_inputs.get(0, "sockid").text(),
	    xa_inputs.get(1, "error").text(),
	    xa_inputs.get(2, "fatal").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_user/0.1/error_event", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_socket4_user_0_1_disconnect_event(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "socket4_user/0.1/disconnect_event");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_user_0_1_disconnect_event(
	    xa_inputs.get(0, "sockid").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_user/0.1/disconnect_event", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_policy_backend_0_1_configure(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/configure");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_configure(
	    xa_inputs.get(0, "filter").uint32(),
	    xa_inputs.get(1, "conf").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/configure", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_policy_backend_0_1_reset(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/reset");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_reset(
	    xa_inputs.get(0, "filter").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/reset", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_policy_backend_0_1_push_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/push_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_push_routes();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/push_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_policy_redist4_0_1_add_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "policy_redist4/0.1/add_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist4_0_1_add_route4(
	    xa_inputs.get(0, "network").ipv4net(),
	    xa_inputs.get(1, "unicast").boolean(),
	    xa_inputs.get(2, "multicast").boolean(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "metric").uint32(),
	    xa_inputs.get(5, "policytags").list());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist4/0.1/add_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_policy_redist4_0_1_delete_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "policy_redist4/0.1/delete_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist4_0_1_delete_route4(
	    xa_inputs.get(0, "network").ipv4net(),
	    xa_inputs.get(1, "unicast").boolean(),
	    xa_inputs.get(2, "multicast").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist4/0.1/delete_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_profile_0_1_enable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/enable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_enable(
	    xa_inputs.get(0, "pname").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/enable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_profile_0_1_disable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/disable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_disable(
	    xa_inputs.get(0, "pname").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/disable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_profile_0_1_get_entries(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/get_entries");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_get_entries(
	    xa_inputs.get(0, "pname").text(),
	    xa_inputs.get(1, "instance_name").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/get_entries", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_profile_0_1_clear(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/clear");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_clear(
	    xa_inputs.get(0, "pname").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/clear", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_profile_0_1_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string info;
    try {
	XrlCmdError e = profile_0_1_list(
	    info);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("info", info);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_trace(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/trace");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_trace(
	    xa_inputs.get(0, "tvar").text(),
	    xa_inputs.get(1, "enable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/trace", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_clear_database(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/clear_database");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_clear_database();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/clear_database", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_willingness(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_willingness");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_willingness(
	    xa_inputs.get(0, "willingness").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_willingness", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_willingness(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_willingness");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t willingness;
    try {
	XrlCmdError e = olsr4_0_1_get_willingness(
	    willingness);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_willingness", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("willingness", willingness);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_mpr_coverage(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_mpr_coverage");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_mpr_coverage(
	    xa_inputs.get(0, "coverage").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_mpr_coverage", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_mpr_coverage(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_mpr_coverage");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t coverage;
    try {
	XrlCmdError e = olsr4_0_1_get_mpr_coverage(
	    coverage);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_mpr_coverage", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("coverage", coverage);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_tc_redundancy(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_tc_redundancy");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_tc_redundancy(
	    xa_inputs.get(0, "redundancy").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_tc_redundancy", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_redundancy(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_tc_redundancy");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string redundancy;
    try {
	XrlCmdError e = olsr4_0_1_get_tc_redundancy(
	    redundancy);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_tc_redundancy", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("redundancy", redundancy);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_tc_fisheye(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_tc_fisheye");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_tc_fisheye(
	    xa_inputs.get(0, "enabled").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_tc_fisheye", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_fisheye(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_tc_fisheye");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = olsr4_0_1_get_tc_fisheye(
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_tc_fisheye", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_hna_base_cost(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_hna_base_cost");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_hna_base_cost(
	    xa_inputs.get(0, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_hna_base_cost", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_hna_base_cost(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_hna_base_cost");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t metric;
    try {
	XrlCmdError e = olsr4_0_1_get_hna_base_cost(
	    metric);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_hna_base_cost", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("metric", metric);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_hello_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_hello_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_hello_interval(
	    xa_inputs.get(0, "interval").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_hello_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_hello_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_hello_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval;
    try {
	XrlCmdError e = olsr4_0_1_get_hello_interval(
	    interval);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_hello_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval", interval);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_refresh_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_refresh_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_refresh_interval(
	    xa_inputs.get(0, "interval").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_refresh_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_refresh_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_refresh_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval;
    try {
	XrlCmdError e = olsr4_0_1_get_refresh_interval(
	    interval);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_refresh_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval", interval);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_tc_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_tc_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_tc_interval(
	    xa_inputs.get(0, "interval").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_tc_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_tc_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval;
    try {
	XrlCmdError e = olsr4_0_1_get_tc_interval(
	    interval);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_tc_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval", interval);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_mid_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_mid_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_mid_interval(
	    xa_inputs.get(0, "interval").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_mid_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_mid_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_mid_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval;
    try {
	XrlCmdError e = olsr4_0_1_get_mid_interval(
	    interval);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_mid_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval", interval);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_hna_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_hna_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_hna_interval(
	    xa_inputs.get(0, "interval").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_hna_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_hna_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_hna_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval;
    try {
	XrlCmdError e = olsr4_0_1_get_hna_interval(
	    interval);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_hna_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval", interval);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_dup_hold_time(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_dup_hold_time");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_dup_hold_time(
	    xa_inputs.get(0, "dup_hold_time").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_dup_hold_time", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_dup_hold_time(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_dup_hold_time");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t dup_hold_time;
    try {
	XrlCmdError e = olsr4_0_1_get_dup_hold_time(
	    dup_hold_time);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_dup_hold_time", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("dup_hold_time", dup_hold_time);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_main_address(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_main_address");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_main_address(
	    xa_inputs.get(0, "addr").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_main_address", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_main_address(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_main_address");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 addr;
    try {
	XrlCmdError e = olsr4_0_1_get_main_address(
	    addr);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_main_address", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("addr", addr);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_bind_address(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/bind_address");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_bind_address(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "local_addr").ipv4(),
	    xa_inputs.get(3, "local_port").uint32(),
	    xa_inputs.get(4, "all_nodes_addr").ipv4(),
	    xa_inputs.get(5, "all_nodes_port").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/bind_address", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_unbind_address(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/unbind_address");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_unbind_address(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/unbind_address", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_binding_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_binding_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_binding_enabled(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "enabled").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_binding_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_binding_enabled(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_binding_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = olsr4_0_1_get_binding_enabled(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_binding_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_change_local_addr_port(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/change_local_addr_port");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_change_local_addr_port(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "local_addr").ipv4(),
	    xa_inputs.get(3, "local_port").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/change_local_addr_port", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_change_all_nodes_addr_port(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/change_all_nodes_addr_port");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_change_all_nodes_addr_port(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "all_nodes_addr").ipv4(),
	    xa_inputs.get(3, "all_nodes_port").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/change_all_nodes_addr_port", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_interface_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_interface_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList interfaces;
    try {
	XrlCmdError e = olsr4_0_1_get_interface_list(
	    interfaces);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_interface_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interfaces", interfaces);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_interface_info(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_interface_info");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string ifname;
    string vifname;
    IPv4 local_addr;
    uint32_t local_port;
    IPv4 all_nodes_addr;
    uint32_t all_nodes_port;
    try {
	XrlCmdError e = olsr4_0_1_get_interface_info(
	    xa_inputs.get(0, "faceid").uint32(),
	    ifname,
	    vifname,
	    local_addr,
	    local_port,
	    all_nodes_addr,
	    all_nodes_port);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_interface_info", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ifname", ifname);
	pxa_outputs->add("vifname", vifname);
	pxa_outputs->add("local_addr", local_addr);
	pxa_outputs->add("local_port", local_port);
	pxa_outputs->add("all_nodes_addr", all_nodes_addr);
	pxa_outputs->add("all_nodes_port", all_nodes_port);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_set_interface_cost(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/set_interface_cost");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = olsr4_0_1_set_interface_cost(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    xa_inputs.get(2, "cost").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/set_interface_cost", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_interface_stats(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_interface_stats");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t bad_packets;
    uint32_t bad_messages;
    uint32_t messages_from_self;
    uint32_t unknown_messages;
    uint32_t duplicates;
    uint32_t forwarded;
    try {
	XrlCmdError e = olsr4_0_1_get_interface_stats(
	    xa_inputs.get(0, "ifname").text(),
	    xa_inputs.get(1, "vifname").text(),
	    bad_packets,
	    bad_messages,
	    messages_from_self,
	    unknown_messages,
	    duplicates,
	    forwarded);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_interface_stats", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("bad_packets", bad_packets);
	pxa_outputs->add("bad_messages", bad_messages);
	pxa_outputs->add("messages_from_self", messages_from_self);
	pxa_outputs->add("unknown_messages", unknown_messages);
	pxa_outputs->add("duplicates", duplicates);
	pxa_outputs->add("forwarded", forwarded);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_link_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_link_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList links;
    try {
	XrlCmdError e = olsr4_0_1_get_link_list(
	    links);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_link_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("links", links);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_link_info(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_link_info");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 local_addr;
    IPv4 remote_addr;
    IPv4 main_addr;
    uint32_t link_type;
    uint32_t sym_time;
    uint32_t asym_time;
    uint32_t hold_time;
    try {
	XrlCmdError e = olsr4_0_1_get_link_info(
	    xa_inputs.get(0, "linkid").uint32(),
	    local_addr,
	    remote_addr,
	    main_addr,
	    link_type,
	    sym_time,
	    asym_time,
	    hold_time);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_link_info", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("local_addr", local_addr);
	pxa_outputs->add("remote_addr", remote_addr);
	pxa_outputs->add("main_addr", main_addr);
	pxa_outputs->add("link_type", link_type);
	pxa_outputs->add("sym_time", sym_time);
	pxa_outputs->add("asym_time", asym_time);
	pxa_outputs->add("hold_time", hold_time);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_neighbor_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_neighbor_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList neighbors;
    try {
	XrlCmdError e = olsr4_0_1_get_neighbor_list(
	    neighbors);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_neighbor_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("neighbors", neighbors);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_neighbor_info(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_neighbor_info");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 main_addr;
    uint32_t willingness;
    uint32_t degree;
    uint32_t link_count;
    uint32_t twohop_link_count;
    bool is_advertised;
    bool is_sym;
    bool is_mpr;
    bool is_mpr_selector;
    try {
	XrlCmdError e = olsr4_0_1_get_neighbor_info(
	    xa_inputs.get(0, "nid").uint32(),
	    main_addr,
	    willingness,
	    degree,
	    link_count,
	    twohop_link_count,
	    is_advertised,
	    is_sym,
	    is_mpr,
	    is_mpr_selector);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_neighbor_info", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("main_addr", main_addr);
	pxa_outputs->add("willingness", willingness);
	pxa_outputs->add("degree", degree);
	pxa_outputs->add("link_count", link_count);
	pxa_outputs->add("twohop_link_count", twohop_link_count);
	pxa_outputs->add("is_advertised", is_advertised);
	pxa_outputs->add("is_sym", is_sym);
	pxa_outputs->add("is_mpr", is_mpr);
	pxa_outputs->add("is_mpr_selector", is_mpr_selector);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_twohop_link_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_twohop_link_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList twohop_links;
    try {
	XrlCmdError e = olsr4_0_1_get_twohop_link_list(
	    twohop_links);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_twohop_link_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("twohop_links", twohop_links);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_twohop_link_info(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_twohop_link_info");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t last_face_id;
    IPv4 nexthop_addr;
    IPv4 dest_addr;
    uint32_t hold_time;
    try {
	XrlCmdError e = olsr4_0_1_get_twohop_link_info(
	    xa_inputs.get(0, "tlid").uint32(),
	    last_face_id,
	    nexthop_addr,
	    dest_addr,
	    hold_time);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_twohop_link_info", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("last_face_id", last_face_id);
	pxa_outputs->add("nexthop_addr", nexthop_addr);
	pxa_outputs->add("dest_addr", dest_addr);
	pxa_outputs->add("hold_time", hold_time);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_twohop_neighbor_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_twohop_neighbor_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList twohop_neighbors;
    try {
	XrlCmdError e = olsr4_0_1_get_twohop_neighbor_list(
	    twohop_neighbors);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_twohop_neighbor_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("twohop_neighbors", twohop_neighbors);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_twohop_neighbor_info(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_twohop_neighbor_info");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 main_addr;
    bool is_strict;
    uint32_t link_count;
    uint32_t reachability;
    uint32_t coverage;
    try {
	XrlCmdError e = olsr4_0_1_get_twohop_neighbor_info(
	    xa_inputs.get(0, "tnid").uint32(),
	    main_addr,
	    is_strict,
	    link_count,
	    reachability,
	    coverage);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_twohop_neighbor_info", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("main_addr", main_addr);
	pxa_outputs->add("is_strict", is_strict);
	pxa_outputs->add("link_count", link_count);
	pxa_outputs->add("reachability", reachability);
	pxa_outputs->add("coverage", coverage);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_mid_entry_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_mid_entry_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList mid_entries;
    try {
	XrlCmdError e = olsr4_0_1_get_mid_entry_list(
	    mid_entries);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_mid_entry_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("mid_entries", mid_entries);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_mid_entry(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_mid_entry");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 main_addr;
    IPv4 iface_addr;
    uint32_t distance;
    uint32_t hold_time;
    try {
	XrlCmdError e = olsr4_0_1_get_mid_entry(
	    xa_inputs.get(0, "midid").uint32(),
	    main_addr,
	    iface_addr,
	    distance,
	    hold_time);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_mid_entry", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("main_addr", main_addr);
	pxa_outputs->add("iface_addr", iface_addr);
	pxa_outputs->add("distance", distance);
	pxa_outputs->add("hold_time", hold_time);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_entry_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_tc_entry_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList tc_entries;
    try {
	XrlCmdError e = olsr4_0_1_get_tc_entry_list(
	    tc_entries);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_tc_entry_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tc_entries", tc_entries);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_entry(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_tc_entry");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 destination;
    IPv4 lasthop;
    uint32_t distance;
    uint32_t seqno;
    uint32_t hold_time;
    try {
	XrlCmdError e = olsr4_0_1_get_tc_entry(
	    xa_inputs.get(0, "tcid").uint32(),
	    destination,
	    lasthop,
	    distance,
	    seqno,
	    hold_time);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_tc_entry", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("destination", destination);
	pxa_outputs->add("lasthop", lasthop);
	pxa_outputs->add("distance", distance);
	pxa_outputs->add("seqno", seqno);
	pxa_outputs->add("hold_time", hold_time);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_hna_entry_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_hna_entry_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList hna_entries;
    try {
	XrlCmdError e = olsr4_0_1_get_hna_entry_list(
	    hna_entries);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_hna_entry_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("hna_entries", hna_entries);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOlsr4TargetBase::handle_olsr4_0_1_get_hna_entry(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "olsr4/0.1/get_hna_entry");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4Net destination;
    IPv4 lasthop;
    uint32_t distance;
    uint32_t hold_time;
    try {
	XrlCmdError e = olsr4_0_1_get_hna_entry(
	    xa_inputs.get(0, "hnaid").uint32(),
	    destination,
	    lasthop,
	    distance,
	    hold_time);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "olsr4/0.1/get_hna_entry", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("destination", destination);
	pxa_outputs->add("lasthop", lasthop);
	pxa_outputs->add("distance", distance);
	pxa_outputs->add("hold_time", hold_time);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

void
XrlOlsr4TargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlOlsr4TargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlOlsr4TargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlOlsr4TargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlOlsr4TargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlOlsr4TargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlOlsr4TargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("socket4_user/0.1/recv_event",
	    callback(this, &XrlOlsr4TargetBase::handle_socket4_user_0_1_recv_event)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "socket4_user/0.1/recv_event");
	}
	if (_cmds->add_handler("socket4_user/0.1/inbound_connect_event",
	    callback(this, &XrlOlsr4TargetBase::handle_socket4_user_0_1_inbound_connect_event)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "socket4_user/0.1/inbound_connect_event");
	}
	if (_cmds->add_handler("socket4_user/0.1/outgoing_connect_event",
	    callback(this, &XrlOlsr4TargetBase::handle_socket4_user_0_1_outgoing_connect_event)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "socket4_user/0.1/outgoing_connect_event");
	}
	if (_cmds->add_handler("socket4_user/0.1/error_event",
	    callback(this, &XrlOlsr4TargetBase::handle_socket4_user_0_1_error_event)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "socket4_user/0.1/error_event");
	}
	if (_cmds->add_handler("socket4_user/0.1/disconnect_event",
	    callback(this, &XrlOlsr4TargetBase::handle_socket4_user_0_1_disconnect_event)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "socket4_user/0.1/disconnect_event");
	}
	if (_cmds->add_handler("policy_backend/0.1/configure",
	    callback(this, &XrlOlsr4TargetBase::handle_policy_backend_0_1_configure)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "policy_backend/0.1/configure");
	}
	if (_cmds->add_handler("policy_backend/0.1/reset",
	    callback(this, &XrlOlsr4TargetBase::handle_policy_backend_0_1_reset)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "policy_backend/0.1/reset");
	}
	if (_cmds->add_handler("policy_backend/0.1/push_routes",
	    callback(this, &XrlOlsr4TargetBase::handle_policy_backend_0_1_push_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "policy_backend/0.1/push_routes");
	}
	if (_cmds->add_handler("policy_redist4/0.1/add_route4",
	    callback(this, &XrlOlsr4TargetBase::handle_policy_redist4_0_1_add_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "policy_redist4/0.1/add_route4");
	}
	if (_cmds->add_handler("policy_redist4/0.1/delete_route4",
	    callback(this, &XrlOlsr4TargetBase::handle_policy_redist4_0_1_delete_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "policy_redist4/0.1/delete_route4");
	}
	if (_cmds->add_handler("profile/0.1/enable",
	    callback(this, &XrlOlsr4TargetBase::handle_profile_0_1_enable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "profile/0.1/enable");
	}
	if (_cmds->add_handler("profile/0.1/disable",
	    callback(this, &XrlOlsr4TargetBase::handle_profile_0_1_disable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "profile/0.1/disable");
	}
	if (_cmds->add_handler("profile/0.1/get_entries",
	    callback(this, &XrlOlsr4TargetBase::handle_profile_0_1_get_entries)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "profile/0.1/get_entries");
	}
	if (_cmds->add_handler("profile/0.1/clear",
	    callback(this, &XrlOlsr4TargetBase::handle_profile_0_1_clear)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "profile/0.1/clear");
	}
	if (_cmds->add_handler("profile/0.1/list",
	    callback(this, &XrlOlsr4TargetBase::handle_profile_0_1_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "profile/0.1/list");
	}
	if (_cmds->add_handler("olsr4/0.1/trace",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_trace)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/trace");
	}
	if (_cmds->add_handler("olsr4/0.1/clear_database",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_clear_database)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/clear_database");
	}
	if (_cmds->add_handler("olsr4/0.1/set_willingness",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_willingness)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_willingness");
	}
	if (_cmds->add_handler("olsr4/0.1/get_willingness",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_willingness)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_willingness");
	}
	if (_cmds->add_handler("olsr4/0.1/set_mpr_coverage",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_mpr_coverage)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_mpr_coverage");
	}
	if (_cmds->add_handler("olsr4/0.1/get_mpr_coverage",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_mpr_coverage)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_mpr_coverage");
	}
	if (_cmds->add_handler("olsr4/0.1/set_tc_redundancy",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_tc_redundancy)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_tc_redundancy");
	}
	if (_cmds->add_handler("olsr4/0.1/get_tc_redundancy",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_redundancy)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_tc_redundancy");
	}
	if (_cmds->add_handler("olsr4/0.1/set_tc_fisheye",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_tc_fisheye)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_tc_fisheye");
	}
	if (_cmds->add_handler("olsr4/0.1/get_tc_fisheye",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_fisheye)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_tc_fisheye");
	}
	if (_cmds->add_handler("olsr4/0.1/set_hna_base_cost",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_hna_base_cost)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_hna_base_cost");
	}
	if (_cmds->add_handler("olsr4/0.1/get_hna_base_cost",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_hna_base_cost)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_hna_base_cost");
	}
	if (_cmds->add_handler("olsr4/0.1/set_hello_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_hello_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_hello_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/get_hello_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_hello_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_hello_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/set_refresh_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_refresh_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_refresh_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/get_refresh_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_refresh_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_refresh_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/set_tc_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_tc_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_tc_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/get_tc_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_tc_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/set_mid_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_mid_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_mid_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/get_mid_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_mid_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_mid_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/set_hna_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_hna_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_hna_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/get_hna_interval",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_hna_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_hna_interval");
	}
	if (_cmds->add_handler("olsr4/0.1/set_dup_hold_time",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_dup_hold_time)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_dup_hold_time");
	}
	if (_cmds->add_handler("olsr4/0.1/get_dup_hold_time",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_dup_hold_time)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_dup_hold_time");
	}
	if (_cmds->add_handler("olsr4/0.1/set_main_address",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_main_address)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_main_address");
	}
	if (_cmds->add_handler("olsr4/0.1/get_main_address",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_main_address)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_main_address");
	}
	if (_cmds->add_handler("olsr4/0.1/bind_address",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_bind_address)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/bind_address");
	}
	if (_cmds->add_handler("olsr4/0.1/unbind_address",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_unbind_address)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/unbind_address");
	}
	if (_cmds->add_handler("olsr4/0.1/set_binding_enabled",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_binding_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_binding_enabled");
	}
	if (_cmds->add_handler("olsr4/0.1/get_binding_enabled",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_binding_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_binding_enabled");
	}
	if (_cmds->add_handler("olsr4/0.1/change_local_addr_port",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_change_local_addr_port)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/change_local_addr_port");
	}
	if (_cmds->add_handler("olsr4/0.1/change_all_nodes_addr_port",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_change_all_nodes_addr_port)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/change_all_nodes_addr_port");
	}
	if (_cmds->add_handler("olsr4/0.1/get_interface_list",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_interface_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_interface_list");
	}
	if (_cmds->add_handler("olsr4/0.1/get_interface_info",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_interface_info)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_interface_info");
	}
	if (_cmds->add_handler("olsr4/0.1/set_interface_cost",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_set_interface_cost)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/set_interface_cost");
	}
	if (_cmds->add_handler("olsr4/0.1/get_interface_stats",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_interface_stats)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_interface_stats");
	}
	if (_cmds->add_handler("olsr4/0.1/get_link_list",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_link_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_link_list");
	}
	if (_cmds->add_handler("olsr4/0.1/get_link_info",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_link_info)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_link_info");
	}
	if (_cmds->add_handler("olsr4/0.1/get_neighbor_list",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_neighbor_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_neighbor_list");
	}
	if (_cmds->add_handler("olsr4/0.1/get_neighbor_info",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_neighbor_info)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_neighbor_info");
	}
	if (_cmds->add_handler("olsr4/0.1/get_twohop_link_list",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_twohop_link_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_twohop_link_list");
	}
	if (_cmds->add_handler("olsr4/0.1/get_twohop_link_info",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_twohop_link_info)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_twohop_link_info");
	}
	if (_cmds->add_handler("olsr4/0.1/get_twohop_neighbor_list",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_twohop_neighbor_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_twohop_neighbor_list");
	}
	if (_cmds->add_handler("olsr4/0.1/get_twohop_neighbor_info",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_twohop_neighbor_info)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_twohop_neighbor_info");
	}
	if (_cmds->add_handler("olsr4/0.1/get_mid_entry_list",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_mid_entry_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_mid_entry_list");
	}
	if (_cmds->add_handler("olsr4/0.1/get_mid_entry",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_mid_entry)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_mid_entry");
	}
	if (_cmds->add_handler("olsr4/0.1/get_tc_entry_list",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_entry_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_tc_entry_list");
	}
	if (_cmds->add_handler("olsr4/0.1/get_tc_entry",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_tc_entry)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_tc_entry");
	}
	if (_cmds->add_handler("olsr4/0.1/get_hna_entry_list",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_hna_entry_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_hna_entry_list");
	}
	if (_cmds->add_handler("olsr4/0.1/get_hna_entry",
	    callback(this, &XrlOlsr4TargetBase::handle_olsr4_0_1_get_hna_entry)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "olsr4", "olsr4/0.1/get_hna_entry");
	}
	_cmds->finalize();
}

void
XrlOlsr4TargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("socket4_user/0.1/recv_event");
	_cmds->remove_handler("socket4_user/0.1/inbound_connect_event");
	_cmds->remove_handler("socket4_user/0.1/outgoing_connect_event");
	_cmds->remove_handler("socket4_user/0.1/error_event");
	_cmds->remove_handler("socket4_user/0.1/disconnect_event");
	_cmds->remove_handler("policy_backend/0.1/configure");
	_cmds->remove_handler("policy_backend/0.1/reset");
	_cmds->remove_handler("policy_backend/0.1/push_routes");
	_cmds->remove_handler("policy_redist4/0.1/add_route4");
	_cmds->remove_handler("policy_redist4/0.1/delete_route4");
	_cmds->remove_handler("profile/0.1/enable");
	_cmds->remove_handler("profile/0.1/disable");
	_cmds->remove_handler("profile/0.1/get_entries");
	_cmds->remove_handler("profile/0.1/clear");
	_cmds->remove_handler("profile/0.1/list");
	_cmds->remove_handler("olsr4/0.1/trace");
	_cmds->remove_handler("olsr4/0.1/clear_database");
	_cmds->remove_handler("olsr4/0.1/set_willingness");
	_cmds->remove_handler("olsr4/0.1/get_willingness");
	_cmds->remove_handler("olsr4/0.1/set_mpr_coverage");
	_cmds->remove_handler("olsr4/0.1/get_mpr_coverage");
	_cmds->remove_handler("olsr4/0.1/set_tc_redundancy");
	_cmds->remove_handler("olsr4/0.1/get_tc_redundancy");
	_cmds->remove_handler("olsr4/0.1/set_tc_fisheye");
	_cmds->remove_handler("olsr4/0.1/get_tc_fisheye");
	_cmds->remove_handler("olsr4/0.1/set_hna_base_cost");
	_cmds->remove_handler("olsr4/0.1/get_hna_base_cost");
	_cmds->remove_handler("olsr4/0.1/set_hello_interval");
	_cmds->remove_handler("olsr4/0.1/get_hello_interval");
	_cmds->remove_handler("olsr4/0.1/set_refresh_interval");
	_cmds->remove_handler("olsr4/0.1/get_refresh_interval");
	_cmds->remove_handler("olsr4/0.1/set_tc_interval");
	_cmds->remove_handler("olsr4/0.1/get_tc_interval");
	_cmds->remove_handler("olsr4/0.1/set_mid_interval");
	_cmds->remove_handler("olsr4/0.1/get_mid_interval");
	_cmds->remove_handler("olsr4/0.1/set_hna_interval");
	_cmds->remove_handler("olsr4/0.1/get_hna_interval");
	_cmds->remove_handler("olsr4/0.1/set_dup_hold_time");
	_cmds->remove_handler("olsr4/0.1/get_dup_hold_time");
	_cmds->remove_handler("olsr4/0.1/set_main_address");
	_cmds->remove_handler("olsr4/0.1/get_main_address");
	_cmds->remove_handler("olsr4/0.1/bind_address");
	_cmds->remove_handler("olsr4/0.1/unbind_address");
	_cmds->remove_handler("olsr4/0.1/set_binding_enabled");
	_cmds->remove_handler("olsr4/0.1/get_binding_enabled");
	_cmds->remove_handler("olsr4/0.1/change_local_addr_port");
	_cmds->remove_handler("olsr4/0.1/change_all_nodes_addr_port");
	_cmds->remove_handler("olsr4/0.1/get_interface_list");
	_cmds->remove_handler("olsr4/0.1/get_interface_info");
	_cmds->remove_handler("olsr4/0.1/set_interface_cost");
	_cmds->remove_handler("olsr4/0.1/get_interface_stats");
	_cmds->remove_handler("olsr4/0.1/get_link_list");
	_cmds->remove_handler("olsr4/0.1/get_link_info");
	_cmds->remove_handler("olsr4/0.1/get_neighbor_list");
	_cmds->remove_handler("olsr4/0.1/get_neighbor_info");
	_cmds->remove_handler("olsr4/0.1/get_twohop_link_list");
	_cmds->remove_handler("olsr4/0.1/get_twohop_link_info");
	_cmds->remove_handler("olsr4/0.1/get_twohop_neighbor_list");
	_cmds->remove_handler("olsr4/0.1/get_twohop_neighbor_info");
	_cmds->remove_handler("olsr4/0.1/get_mid_entry_list");
	_cmds->remove_handler("olsr4/0.1/get_mid_entry");
	_cmds->remove_handler("olsr4/0.1/get_tc_entry_list");
	_cmds->remove_handler("olsr4/0.1/get_tc_entry");
	_cmds->remove_handler("olsr4/0.1/get_hna_entry_list");
	_cmds->remove_handler("olsr4/0.1/get_hna_entry");
}
