/* -*- C++ -*-	Time-stamp: <15 May 99 20:56:24 Michael Bischoff> */
/*
   Description:
   class QHelpWindow displays a simple help window.
   The window is not modal and may be closed at any time.

   Sources:
   qhelpwin.h		header file
   qhelpwin.cpp		implements the class
   mhelpwin.cpp		generated by moc

   Dependencies:
   requires the widget qmultilineedit and the Qt library (tested with version 1.42)

   Author:
   Michael Bischoff	(Michael.Bischoff@gmx.net)
*/

#include "qhelpwin.h"
#include <qpushbutton.h>
#include <qmultilinedit.h>
#include <qstring.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qlayout.h>

QHelpWindow::QHelpWindow(const char *filename, const char *caption) : QWidget() {
    v = new QVBoxLayout(this, 4, -1, filename);
    e = new QMultiLineEdit(this, filename);
    resize(408, 358);

    QFile f( filename );
    if ( !f.open( IO_ReadOnly ) )
        return;

    e->setAutoUpdate( FALSE );
    e->clear();

    QTextStream t(&f);
    while ( !t.eof() ) {
        QString s = t.readLine();
        e->append( s );
    }
    f.close();

    e->resize(400,300);
    setCaption(caption);
    e->setReadOnly(TRUE);
    e->setAutoUpdate( TRUE );
    v->addWidget(e, 100);	/* add widget with stretch factor */

    w = new QWidget(this);
    w->setFixedSize(400, 50);
    v->addWidget(w);

    close = new QPushButton("Close", w, "close button");
    QFont clsfnt("System", 12, QFont::Bold);
    close->setFont (clsfnt);
    close->resize(200, 30);
    close->move(100,10);
    v->activate();
    connect(close, SIGNAL(clicked()), this, SLOT(closeHelp()));

    show();
}

void QHelpWindow::closeHelp() {
    delete this;
}

QHelpWindow::~QHelpWindow() {
    delete close;
    delete e;
    delete w;
    delete v;
}
