echo "# Starting Xprint server"

if [ -z "${MOZ_USER_DIR}" ] ; then
    echo "Internal error: MOZ_USER_DIR not set."
    moz_startstop_addon_scripts stop
    exit 1
fi

# Make sure we pick the right binary - users may share one profile
# between different architectures
uname_os="`uname -s`"
uname_cpu="`uname -p 2>/dev/null`" # uname -p may fail on old Debian
if [ "${uname_cpu}" = "unknown" -o "${uname_cpu}" = "" ] ; then
    uname_cpu="`uname -m`"
fi

MOZXPSTARTSCRIPT="${HOME}/${MOZ_USER_DIR}/xprint_xpi/${uname_os}_${uname_cpu}/run_xprint_from_tarball.sh"

if [ -f "${MOZXPSTARTSCRIPT}" ] ; then
    echo "# Starting Xprint server"
    /bin/sh "${MOZXPSTARTSCRIPT}" start

    echo "# Populating XPSERVERLIST"

    XPSERVERLIST="`/bin/sh "${MOZXPSTARTSCRIPT}" get_xpserverlist`"
    export XPSERVERLIST

    echo "XPSERVERLIST=${XPSERVERLIST}"

    if [ -z "${XPSERVERLIST}" ] ; then
        echo "Fatal error: XPSERVERLIST empty."
        moz_startstop_addon_scripts stop
        exit 1
    fi
else
    echo "# Warning: No Xprint XPI start script found for \"${uname_os}_${uname_cpu}\"."
fi

echo "# Done."
