/*

    xpuyopuyo - pnet.h        Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Header for network code
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pnet_h_defined
#define __pnet_h_defined


#include <xpuyopuyo.h>
#ifndef USE_NETWORK
   #error USE_NETWORK must be defined
#endif


#if !USE_NETWORK /* Do not allow network support */

#define P_NETWORK_SERVER(c)   (!0)
#define P_NETWORK_CLIENT(c)   0
#define P_NETWORK(c)          0

#else /* Allow network support */


struct _pconfig;
struct _pplayer;


#define P_NETWORK(c)          ((c)->socket != NULL)
#define P_NETWORK_SERVER(c)   ((c)->socket == NULL || (c)->socket->remote >= 0)
#define P_NETWORK_CLIENT(c)   ((c)->socket != NULL && (c)->socket->remote < 0)
#define P_COMM_SOCKET(c)      ((c)->remote == -1 ? (c)->socket : (c)->remote)


#define P_NET_RES_LOST        1     /* Return code from pnet_recv_game */
#define P_NET_RES_ENDGAME     2     /* Return code from pnet_recv_game */


typedef struct _psocket {
   int socket;       /* Socket ID for this game */
   int remote;       /* Socket for remote host (server only) */
   int sent;         /* Bytes sent */
   int recv;         /* Bytes received */
} psocket;


/* Server/client creation and close */
psocket *pnet_server_new(struct _pconfig *c, int port);
psocket *pnet_client_new(struct _pconfig *c, const char *server, int port);
#define pnet_new_server    pnet_server_new
#define pnet_new_client    pnet_client_new
void pnet_close(struct _pconfig *c, psocket **s);


/* Configurations */
int pnet_send_config(struct _pconfig *c);
int pnet_recv_config(struct _pconfig *c);


/* Runtime game */
int pnet_send_rocks(struct _pconfig *c, struct _pplayer *p, int numrocks);
int pnet_send_board(struct _pconfig *c, struct _pplayer *p);
int pnet_send_subboard(struct _pconfig *c, struct _pplayer *p, int x1, int y1, int x2, int y2);
int pnet_send_status(struct _pconfig *c, struct _pplayer *p);
int pnet_send_defeat(struct _pconfig *c, struct _pplayer *p);
int pnet_send_end(struct _pconfig *c);
int pnet_send_pause(struct _pconfig *c, int paused);
int pnet_send_next(struct _pconfig *c, struct _pplayer *p);

int pnet_recv_game(struct _pconfig *c, struct _pplayer *p);
int pnet_recv_for_unpause(struct _pconfig *c);


/* Error messages */
const char *pnet_get_error(void);


/* Hostname information */
int pnet_get_hostname(char *buf, int size);


#endif /* Network? */


#endif /* __pnet_h_defined */

