/*-
# X-BASED HEXAGONS
#
#  HexagonsU.c
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Undo algorithm */

#include "HexagonsP.h"

typedef struct _MoveRecord {
#if 0
	int direction;
#endif
	unsigned char packed;	/* This makes assumptions on the data. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

static MoveStack *currMove, *lastMove, *firstMove;
static int count;
static int startSpacePosition[SPACES];
static int startSpaceRow[ROWTYPES];
int *startPosition = NULL;

static void
InitStack(void)
{
	if (!(lastMove = (MoveStack *) malloc(sizeof (MoveStack)))) {
		DISPLAY_ERROR("Not enough memory, exiting.");
	}
	if (!(firstMove = (MoveStack *) malloc(sizeof (MoveStack)))) {
		DISPLAY_ERROR("Not enough memory, exiting.");
	}
	firstMove->previous = lastMove->next = NULL;
	firstMove->next = lastMove;
	lastMove->previous = firstMove;
	count = 0;
}

static void
PushStack(MoveRecord move)
{
	if (!(currMove = (MoveStack *) malloc(sizeof (MoveStack)))) {
		DISPLAY_ERROR("Not enough memory, exiting.");
	}
	lastMove->previous->next = currMove;
	currMove->previous = lastMove->previous;
	currMove->next = lastMove;
	lastMove->previous = currMove;
	currMove->move = move;
	count++;
}

static void
PopStack(MoveRecord * move)
{
	*move = lastMove->previous->move;
	currMove = lastMove->previous;
	lastMove->previous->previous->next = lastMove;
	lastMove->previous = lastMove->previous->previous;
	free(currMove);
	count--;
}

static int
EmptyStack(void)
{
	return (lastMove->previous == firstMove);
}

static void
FlushStack(void)
{
	while (lastMove->previous != firstMove) {
		currMove = lastMove->previous;
		lastMove->previous->previous->next = lastMove;
		lastMove->previous = lastMove->previous->previous;
		free(currMove);
	}
	count = 0;
}

/**********************************/

void
InitMoves(void)
{
	InitStack();
}

static void
WriteMove(MoveRecord * move, int direction)
{
#if 0
	move->direction = direction;
#endif
	move->packed = direction & 0xF;
}

static void
ReadMove(int *direction, MoveRecord move)
{
#if 0
	*direction = move.direction;
#endif
	*direction = (int) (move.packed & 0xF);
}

void
PutMove(int direction)
{
	MoveRecord move;

	WriteMove(&move, direction);
	PushStack(move);
}

void
GetMove(int *direction)
{
	MoveRecord move;

	PopStack(&move);
	ReadMove(direction, move);
}

int
MadeMoves(void)
{
	return !EmptyStack();
}

void
FlushMoves(HexagonsWidget w)
{
	int i;

	FlushStack();
	startSpacePosition[LOW] = w->hexagons.spacePosition[LOW];
	startSpacePosition[HIGH] = w->hexagons.spacePosition[HIGH];
	startSpaceRow[TRBL] = w->hexagons.spaceRow[TRBL];
	startSpaceRow[TLBR] = w->hexagons.spaceRow[TLBR];
	startSpaceRow[ROW] = w->hexagons.spaceRow[ROW];
	for (i = 0; i < w->hexagons.sizeSize; i++)
		startPosition[i] = w->hexagons.tileOfPosition[i];
}

int
NumMoves(void)
{
	return count;
}

void
ScanMoves(FILE * fp, HexagonsWidget w, int moves)
{
	int direction, l, c;

	for (l = 0; l < moves; l++) {
		while ((c = getc(fp)) != EOF && c != SYMBOL);
		(void) fscanf(fp, "%d", &direction);
		if (!MoveHexagonsDir(w, direction, INSTANT))
			(void) fprintf(stderr,
				"%d move in direction %d, can not be made.",
				l, direction);
	}
}

void
PrintMoves(FILE * fp)
{
	int direction, counter = 0;

	currMove = firstMove->next;
	(void) fprintf(fp, "moves\tdirection\n");
	while (currMove != lastMove) {
		ReadMove(&direction, currMove->move);
		(void) fprintf(fp, "%d%c\t%d\n", ++counter, SYMBOL, direction);
		currMove = currMove->next;
	}
}

void
ScanStartPosition(FILE * fp, HexagonsWidget w)
{
	int i, num, c;

	while ((c = getc(fp)) != EOF && c != SYMBOL);
	for (i = 0; i < w->hexagons.sizeSize; i++) {
		(void) fscanf(fp, "%d ", &num);
		startPosition[i] = num;
		if (!num)
			startSpacePosition[HIGH] = i;
		else if (num == -1)
			startSpacePosition[LOW] = i;
	}
	if (w->hexagons.corners) {
		startSpaceRow[HIGH] = Row(w, startSpacePosition[HIGH]);
		if (w->hexagons.sizeX > 1 || w->hexagons.sizeY > 1)
			startSpaceRow[LOW] = Row(w,
				startSpacePosition[LOW]);
	} else {
		startSpaceRow[ROW] = Row(w, startSpacePosition[HIGH]);
		startSpaceRow[TRBL] = TrBl(w, startSpacePosition[HIGH],
			startSpaceRow[ROW]);
		startSpaceRow[TLBR] = TlBr(w, startSpacePosition[HIGH],
			startSpaceRow[ROW]);
	}
}

void
PrintStartPosition(FILE * fp, HexagonsWidget w)
{
	int rowPos = 0, r = 0, rp, p, length = 0;

	(void) fprintf(fp, "\nstartingPosition%c\n", SYMBOL);
	for (p = 0; p < w->hexagons.sizeSize; p++) {
		if (rowPos == 0) {
			if (p < w->hexagons.sizeCenter) {
				length = w->hexagons.sizeX + r;
				for (rp = 0; rp < w->hexagons.sizeY - r - 1; rp++)
					(void) fprintf(fp, "  ");
			} else {
				length = 2 * w->hexagons.sizeY + w->hexagons.sizeX - r - 2;
				for (rp = 0; rp < r - w->hexagons.sizeY + 1; rp++)
					(void) fprintf(fp, "  ");
			}
		}
		(void) fprintf(fp, "%3d ", startPosition[p]);
		if (rowPos == length - 1) {
			r++;
			rowPos = 0;
			(void) fprintf(fp, "\n");
		} else
			rowPos++;
	}
	(void) fprintf(fp, "\n");
}

void
SetStartPosition(HexagonsWidget w)
{
	int i;

	w->hexagons.spacePosition[HIGH] = startSpacePosition[HIGH];
	w->hexagons.spacePosition[LOW] = startSpacePosition[LOW];
	w->hexagons.spaceRow[TRBL] = startSpaceRow[TRBL];
	w->hexagons.spaceRow[TLBR] = startSpaceRow[TLBR];
	w->hexagons.spaceRow[ROW] = startSpaceRow[ROW];
	for (i = 0; i < w->hexagons.sizeSize; i++)
		w->hexagons.tileOfPosition[i] = startPosition[i];
	DrawAllTiles(w);
}
