/*-
# X-BASED MISSING LINK(tm)
#
#  MlinkP.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Mlink */

#ifndef _MlinkP_h
#define _MlinkP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Mlink.h"

#ifndef BUMPSOUND
#define BUMPSOUND "c:/windows/bump.wav"
#endif
#ifndef MOVESOUND
#define MOVESOUND "c:/windows/move.wav"
#endif

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)		/* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define Pixmap HBITMAP

#define DC(w,dr) ((dr==0)?w->core.hDC:w->mlink.memDC)
#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w,x,y,x+l,y+h)
#define DRAWRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->mlink.hOldBitmap = (HBITMAP) SelectObject(w->mlink.memDC,dr); \
  w->mlink.hPen = CreatePen(PS_SOLID,1,c); \
  w->mlink.hOldPen = (HPEN) SelectObject(DC(w,dr),w->mlink.hPen); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr),w->mlink.hOldPen); \
  (void) DeleteObject(w->mlink.hPen); \
  if (dr) (void) SelectObject(w->mlink.memDC,w->mlink.hOldBitmap)
#define FILLRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->mlink.hOldBitmap = (HBITMAP) SelectObject(w->mlink.memDC,dr); \
  w->mlink.hPen = CreatePen(PS_SOLID,1,c); \
  w->mlink.hOldPen = (HPEN) SelectObject(DC(w,dr),w->mlink.hPen); \
  w->mlink.hBrush = CreateSolidBrush(c); \
  w->mlink.hOldBrush = (HBRUSH) SelectObject(DC(w,dr),w->mlink.hBrush); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr),w->mlink.hOldBrush); \
  (void) DeleteObject(w->mlink.hBrush); \
  (void) SelectObject(DC(w,dr),w->mlink.hOldPen); \
  (void) DeleteObject(w->mlink.hPen); \
  if (dr) (void) SelectObject(w->mlink.memDC,w->mlink.hOldBitmap)
#define ARC(w,x,y,l,h,a1,a2) if (a2 > 0) Arc(w,x,y,x+l,y+h, \
  (int) (cos(M_PI * (a1) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1) / 180) * (h) + y + ((h)>>1)), \
  (int) (cos(M_PI * (a1+a2) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1+a2) / 180) * (h) + y + ((h)>>1))); \
  else Arc(w,x,y,x+l,y+h, \
  (int) (cos(M_PI * (a1+a2) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1+a2) / 180) * (h) + y + ((h)>>1)), \
  (int) (cos(M_PI * (a1) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1) / 180) * (h) + y + ((h)>>1)))
#define DRAWARC(w,dr,c,t,x,y,l,h,a1,a2) \
  if (dr) w->mlink.hOldBitmap = (HBITMAP) SelectObject(w->mlink.memDC,dr); \
  w->mlink.hPen = CreatePen(PS_SOLID,t,c); \
  w->mlink.hOldPen = (HPEN) SelectObject(DC(w,dr),w->mlink.hPen); \
  ARC(DC(w,dr),x,y,l,h,a1,a2); \
  (void) SelectObject(DC(w,dr),w->mlink.hOldPen); \
  (void) DeleteObject(w->mlink.hPen); \
  if (dr) (void) SelectObject(w->mlink.memDC,w->mlink.hOldBitmap)
#define DRAWTEXT(w,dr,c,x,y,s,l) \
  if (dr) w->mlink.hOldBitmap = (HBITMAP) SelectObject(w->mlink.memDC,dr); \
  (void) SetTextColor(DC(w,dr), c); \
  (void) SetBkMode(DC(w,dr), TRANSPARENT); \
  (void) TextOut(DC(w,dr), (x)-3, (y)-11, (LPCSTR) s, l); \
  if (dr) (void) SelectObject(w->mlink.memDC,w->mlink.hOldBitmap)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

extern void DestroyMlink(HBRUSH brush);
extern void ResizeMlink(MlinkWidget w);
extern void SizeMlink(MlinkWidget w);
extern void InitializeMlink(MlinkWidget w, HBRUSH brush);
extern void ExposeMlink(const MlinkWidget w);
extern void HideMlink(const MlinkWidget w);
extern void SelectMlink(MlinkWidget w,
	const int x, const int y, const int shift);
extern void ReleaseMlink(MlinkWidget w,
	const int x, const int y, const int shift);
extern void PracticeMlink(MlinkWidget w);
extern void PracticeMlinkMaybe(MlinkWidget w);
extern void PracticeMlink2(MlinkWidget w);
extern void RandomizeMlink(MlinkWidget w);
extern void RandomizeMlinkMaybe(MlinkWidget w);
extern void RandomizeMlink2(MlinkWidget w);
extern void ClearMlink(MlinkWidget w);
extern void GetMlink(MlinkWidget w);
extern void WriteMlink(MlinkWidget w);
extern void UndoMlink(MlinkWidget w);
extern void SolveMlink(MlinkWidget w);
extern void OrientizeMlink(MlinkWidget w);
extern void MiddleMlink(MlinkWidget w);
extern void SpeedMlink(MlinkWidget w);
extern void SlowMlink(MlinkWidget w);
extern void SoundMlink(MlinkWidget w);
extern void EnterMlink(MlinkWidget w);
extern void LeaveMlink(MlinkWidget w);
extern void MoveMlinkInput(MlinkWidget w,
	int x, int direction, int shift, int control);
extern int  MoveMlinkDir(MlinkWidget w, const int direction);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <X11/Xos.h>
#include "Mlink.h"

#ifdef VMS
#ifndef BUMPSOUND
#define BUMPSOUND "[.]bump.wav"
#endif
#ifndef MOVESOUND
#define MOVESOUND "[.]move.wav"
#endif
#else
#ifndef BUMPSOUND
#if 0
#define BUMPSOUND "/usr/local/share/games/xpuzzles/bump.au"
#endif
#define BUMPSOUND "/usr/share/games/xpuzzles/bump.au"
#endif
#ifndef MOVESOUND
#if 0
#define MOVESOUND "/usr/local/share/games/xpuzzles/move.au"
#endif
#define MOVESOUND "/usr/share/games/xpuzzles/move.au"
#endif
#endif

#ifndef Pos
#define Pos Position
#endif
#ifndef Point
#define Point XPoint
#endif
#define NUM_DEGREES 360
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DR(w,dr) ((dr==0)?XtWindow(w):dr)
#define DRAWRECTANGLE(w,dr,c,i,j,l,h) XDrawRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define FILLRECTANGLE(w,dr,c,i,j,l,h) XFillRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define DRAWARC(w,dr,c,t,x,y,l,h,a1,a2) \
  if(t>1)XSetLineAttributes(XtDisplay(w),c,t,LineSolid,CapNotLast,JoinRound);\
  XDrawArc(XtDisplay(w),DR(w,dr),c,x,y,l,h,(a1)*MULT,(a2)*MULT);\
  if(t>1)XSetLineAttributes(XtDisplay(w),c,1,LineSolid,CapNotLast,JoinRound)
#define DRAWTEXT(w,dr,c,x,y,s,l) (void) XDrawString(XtDisplay(w),DR(w,dr),\
  c,x,y,s,l)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _MlinkClassPart {
	int         ignore;
} MlinkClassPart;

typedef struct _MlinkClassRec {
	CoreClassPart core_class;
	MlinkClassPart mlink_class;
} MlinkClassRec;

extern MlinkClassRec mlinkClassRec;
#endif

#define SYMBOL ':'

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define COORD 4

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srandom
#define LRAND random
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand
#define LRAND rand
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _MlinkPart {
	int        *tileOfPosition, spacePosition;
	int         currentTile, currentFace, currentRef;
	Boolean     started, cheat, sound;
	Boolean     practice, orient, mono, reverse, middle, focus;
	int         delay, numSlices;
	int         base;
	int         tiles, faces, tileFaces;
	Point       offset, tileSize, faceSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
	GC          faceGC[MAXFACES];
	Pixmap      bufferTiles[2];
#ifdef WINVER
	long        oldTime;
	char        username[81], bumpSound[81], moveSound[81], picture[81];
	HDC         memDC;
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
	HBITMAP     hOldBitmap;
	char        faceChar[MAXFACES];
#else
	struct timeval oldTime;
	int         menu, graphicsFormat;
	char       *username, *bumpSound, *moveSound, *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} MlinkPart;

typedef struct _MlinkRec {
	CorePart    core;
	MlinkPart   mlink;
} MlinkRec;

extern int *startPosition;
extern void SetMlink(MlinkWidget w, int reason);
extern Boolean MoveMlink(MlinkWidget w,
	const int direction, const int tile, const int shift, const int fast);
extern void MoveMlinkDelay(MlinkWidget w,
	const int direction, const int tile, const Boolean all);

extern void SolveSomeTiles(MlinkWidget w);
extern void DrawAllTiles(const MlinkWidget w);
extern Boolean CheckSolved(const MlinkWidget w);
extern void InitMoves(void);
extern void PutMove(int direction, int tile, int control);
extern void GetMove(int *direction, int *tile, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(MlinkWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, MlinkWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, MlinkWidget w);
extern void PrintStartPosition(FILE * fp, MlinkWidget w);
extern void SetStartPosition(MlinkWidget w);

#endif /* _MlinkP_h */
