.\" X-BASED PANEX
.\"
.\" xpanex.man
.\"
.\" ##
.\"
.\" Copyright (c) 1996 - 2004	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH PANEX 6 "29 Aug 2004" "V7.1"
.SH NAME
xpanex \- Panex X widget
.SH SYNOPSIS
.B /usr/games/xpanex
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-tile {color}] [-pyramid{0|1} {color}]
[-tiles {int}] [-{mode {int}|hanoi|panex}] [-delay msecs]
[-{font|fn} {fontname}] [-username {string}]
.SH DESCRIPTION
The original Panex puzzle is from the Japanese Magic Company from the
1980's.  Mathematicians at Bell Laboratories estimated the number of
moves to swap 2 columns of order 10 to be 27,564 <= N <= 31,537.
It came in two varieties: one with a magenta and a yellow pyramid of
order 10 on silver tiles; in the gold version, pieces of each color look
alike (i.e. no pyramid is drawn on them), this is a little harder.
.LP
The original Tower of Hanoi puzzle is the invention of Edouard Lucas and
temple of Benares of the god Brahma is also his invention.
.SH FEATURES
Press "\fBmouse-left\fP" button to move a tile in the top tile of a column.
Release "\fBmouse-left\fP" button on another column to move the tile to
that column.  It will not move if blocked.
.LP
Click "\fBmouse-right\fP" button, or press "\fBC\fP", "\fBc\fP",
"\fBR\fP", or "\fBr\fP" keys, to clear/reset the puzzle.
.LP
Press "\fBM\fP" or "\fBm\fP" keys to toggle between hanoi (one pyramid
column) and panex (two pyramid columns) modes (they each have different
rules).
.BR
In Hanoi, one can not place larger trapezoid on a smaller trapezoid.
Here the goal is to move the pile from the left peg to the rightmost peg.
.BR
In Panex, a tile can not go lower that its initial starting point.
Here the goal is to exchange the 2 piles.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of tiles.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of tiles.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to auto-solve.  Unfortunately, its only
implemented from the starting position.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to save a puzzle.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Unlike other puzzles in the collection there is no way to move pieces
without drag and drop.
.LP
The title is in the following format (non-motif version):
.RS
x{hanoi | panex}: <Number of rows> @ (<Number of moves>/{<Record number of
moves> <username>|"NEVER noaccess"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the panex window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to  display on a color screen as if monochrome
(resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the panex window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the panex window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the panex window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the tiles in the panex window
(resource name "\fIborderColor\fP").
.TP 8
.B \-tile \fIcolor\fP
This option specifies the tile color of the tiles in the panex window
(resource name "\fItileColor\fP").
.TP 8
.B \-pyramid0 \fIcolor\fP
This option specifies the foreground of the first pyramid (resource name
"\fIpyramidColor0\fP").
.TP 8
.B \-pyramid1 \fIcolor\fP
This option specifies the foreground of the second pyramid, if it exists
(resource name "\fIpyramidColor1\fP").
.TP 8
.B \-tiles \fIint\fP
This option specifies the number of tiles in a column (resource name
"\fItiles\fP").
.TP 8
.B \-mode \fIint\fP
This option specifies the hanoi (0) or panex (1) mode (resource name
"\fImode\fP").
.TP 8
.B \-hanoi
This option specifies the hanoi mode (resource name "\fImode\fP").
.TP 8
.B \-panex
This option specifies the panex mode (resource name "\fImode\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move a tile or
a group of tiles one space (resource name "\fIdelay\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-username \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.SH RECORDS
You must clear the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get or an
auto-solve.
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
.RS
mode: 0-1 <0 hanoi, 1 panex>
.br
tiles: 1-10 <number of tiles in a column>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <array pairs of column and position of each tile>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <from_column> <to_column>
.RE
from_column is the top tile of the column
.br
to_column is where that tile is moved to.
.SH REFERENCES
Mark Manasse & Danny Sleator of AT&T Bell Laboratories
and Victor K. Wei of Bell Communications Research,
Some Results on the Panex Puzzle, Murray Hill, NJ, 1985
20 pp. (unpublished).
.sp
Vladimir Dubrovsky, Nesting Puzzles Part 1: Moving oriental
Quantum January/February 1996 pp 55-57, 50-51.
.sp
L. E. Horden, Sliding Piece Puzzles (Recreations in Mathematics
Series), Oxford University Press 1986, pp 144, 145.
.sp
Jerry Slocum & Jack Botermans, Puzzles Old & New (How to Make
and Solve Them), University of Washington Press, Seattle, 1987,
p 135.
.sp
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xmlink(6), xcubes(6), xtriangles(6), xhexagons(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1996-2004, David Albert Bagley
.LP
Main algorithm taken from AT&T paper above.
.sp
Thanks to Nick Baxter <nickb@baxterweb.com> for debugging level n > 4
and vTrick.
.sp
Though most code by Rene Jansen <rene.j.jansen@bigfoot.com> is now
removed much inspiration was gained by his efforts implementing
an algorithm from Quantum January/February 1996 by Vladimir
Dubrovsky.
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ibiblio.org/pub/Linux/games/strategy\fP
