/*
# X-BASED DIAL
#
#  DialSq.c
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Methods file for Square Dial */

#include "DialSqP.h"

static void InitializeSquareDial(Widget request, Widget renew);
static void ResizeSquareDial(SquareDialWidget w);

/* Not sure why DialSq.ad is not working. */
/*#define SETVAL 1*/
#ifdef SETVAL
static Boolean SetValuesSquareDial(Widget current, Widget request, Widget renew);
#endif
/*#define RESOURCES 1*/
#ifdef RESOURCES
static XtResource resourcesSquareDial[] =
{
  {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
   XtOffset(DialWidget, dial.foreground), XtRString, (caddr_t) "Black"},
  {XtNindicatorColor,  XtCColor, XtRPixel, sizeof(Pixel),
   XtOffset(DialWidget, dial.indicatorColor), XtRString, (caddr_t) "Blue"},
  {XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
   XtOffset(DialWidget, core.width), XtRString, (caddr_t) "100"},
  {XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
   XtOffset(DialWidget, core.height), XtRString, (caddr_t) "100"},
  {XtNmarkers, XtCMarkers, XtRInt, sizeof(int),
   XtOffset(DialWidget, dial.markers), XtRString, (caddr_t) "17"},
  {XtNangle, XtCAngle, XtRInt, sizeof(int),
   XtOffset(DialWidget, dial.angle), XtRString, (caddr_t) "270"},
  {XtNminimum, XtCMinimum, XtRInt, sizeof(int),
   XtOffset(DialWidget, dial.minimum), XtRString, (caddr_t) "0"},
  {XtNmaximum, XtCMaximum, XtRInt, sizeof(int),
   XtOffset(DialWidget, dial.maximum), XtRString, (caddr_t) "100"},
  {XtNmarkerLength, XtCPosition, XtRPosition, sizeof(Position),
   XtOffset(DialWidget, dial.markerLength), XtRString, (caddr_t) "5"},
  {XtNval, XtCVal, XtRInt, sizeof(int),
   XtOffset(DialWidget, dial.val), XtRString, (caddr_t) "0"},
  {XtNselectCallback, XtCCallback, XtRCallback, sizeof(caddr_t),
   XtOffset(DialWidget, dial.select), XtRCallback, NULL}
};
#endif
SquareDialClassRec squareDialClassRec =
{
  {
    (WidgetClass) &dialClassRec,   /* superclass */
    (char *) "DialSq",             /* class name */
    sizeof(SquareDialRec),         /* widget size */
    NULL,                          /* class initialize */
    NULL,                          /* class part initialize */
    FALSE,                         /* class inited */
    (XtInitProc) InitializeSquareDial, /* initialize */
    NULL,                          /* initialize hook */
    XtInheritRealize,              /* realize */
    NULL,                          /* actions */
    0,                             /* num actions */
#ifdef RESOURCES
    resourcesSquareDial,           /* resources */
    XtNumber(resourcesSquareDial), /* num resources */
#else
    NULL,                          /* resources */
    0,                             /* num resources */
#endif
    NULLQUARK,                     /* xrm class */
    TRUE,                          /* compress motion */
    TRUE,                          /* compress exposure */
    TRUE,                          /* compress enterleave */
    TRUE,                          /* visible interest */
    NULL,                          /* destroy */
    (XtWidgetProc) ResizeSquareDial, /* resize */
    XtInheritExpose,               /* expose */
#ifdef SETVAL
    (XtSetValuesFunc) SetValuesSquareDial, /* set values */
#else
    NULL,                          /* set values */
#endif
    NULL,                          /* set values hook */
    XtInheritSetValuesAlmost,      /* set values almost */
    NULL,                          /* get values hook */
    XtInheritAcceptFocus,          /* accept focus */
    XtVersion,                     /* version */
    NULL,                          /* callback private */
    XtInheritTranslations,         /* tm table */
    NULL,                          /* query geometry */
    NULL,                          /* display accelerator */
    NULL                           /* extension */
  },
  {
    0                              /* ignore */
  },
  {
    0                              /* ignore */
  }
};

WidgetClass squareDialWidgetClass = (WidgetClass) &squareDialClassRec;

static void InitializeSquareDial(Widget request, Widget renew)
{
  SquareDialWidget w = (SquareDialWidget) renew;

  ResizeSquareDial(w);
}

static void ResizeSquareDial(SquareDialWidget w)
{
  int marks_per_side = 0, h_increment, v_increment, i;
  XSegment *ptr;

  ptr = w->dial.segments;
  w->dial.center.x = w->core.width / 2;
  w->dial.center.y = w->core.height / 2;
  w->dial.outerDiam = MIN(w->core.width, w->core.height) / 2;
  w->dial.innerDiam = w->dial.outerDiam - w->dial.markerLength;
  /* Approximating */
  if (w->dial.angle <= 90)
  {
    marks_per_side = w->dial.markers + 1;
    w->dial.markers = marks_per_side + 1;
  }
  else if (w->dial.angle <= 180)
  {
    marks_per_side = w->dial.markers / 2;
    w->dial.markers = marks_per_side * 2;
  }
  else if (w->dial.angle <= 270)
  {
    marks_per_side = w->dial.markers / 3;
    w->dial.markers = marks_per_side * 3;
  }
  else
  {
    marks_per_side = w->dial.markers / 4;
    w->dial.markers = marks_per_side * 4;
  }
  h_increment = (int) w->core.width / (marks_per_side + 1);
  v_increment = (int) w->core.height / (marks_per_side + 1);
  for (i = 1; i <= marks_per_side; i++)
  {
    ptr->x1 = i * h_increment;
    ptr->y1 = 0;
    ptr->x2 = i * h_increment;
    ptr++->y2 = w->dial.markerLength;
  }
  if (w->dial.angle > 90)
  {
    for (i = 1; i <= marks_per_side; i++)
    {
      if (w->dial.angle <= 180 && i - 1 >= marks_per_side / 2)
        break;
      ptr->x1 = 0;
      ptr->y1 = i * v_increment;
      ptr->x2 = w->dial.markerLength;
      ptr++->y2 = i * v_increment;
    }
    for (i = 1; i <= marks_per_side; i++)
    {
      if (w->dial.angle <= 180 && i - 1 >= marks_per_side / 2)
        break;
      ptr->x1 = w->core.width - w->dial.markerLength;
      ptr->y1 = i * v_increment;
      ptr->x2 = w->core.width;
      ptr++->y2 = i * v_increment;
    }
    if (w->dial.angle > 270)
    {
      for (i = 1; i <= marks_per_side; i++)
      {
        ptr->x1 = w->core.width - i * h_increment;
        ptr->y1 = w->core.height - w->dial.markerLength;
        ptr->x2 = w->core.width - i * h_increment;
        ptr++->y2 = w->core.height;
      }
    }
  }
  calculate_indicator_pos((DialWidget) w);
}

#ifdef SETVAL
static Boolean SetValuesSquareDial (Widget current, Widget request, Widget renew)
{
  SquareDialWidget c = (SquareDialWidget) current, w = (SquareDialWidget) renew;
  XGCValues values;
  XtGCMask valueMask;
  Boolean redraw = FALSE;
  Boolean redraw_indicator = FALSE;

  if (w->dial.indicatorColor != c->dial.indicatorColor ||
      w->core.background_pixel != c->core.background_pixel)
  {
    valueMask = GCForeground | GCBackground;
    values.foreground = w->dial.indicatorColor;
    values.background = w->core.background_pixel;
    XtReleaseGC(renew, w->dial.indicatorGC);
    w->dial.indicatorGC = XtGetGC(renew, valueMask, &values);
    values.foreground = w->core.background_pixel;
    values.background = w->dial.indicatorColor;
    XtReleaseGC(renew, w->dial.inverseGC);
    w->dial.inverseGC = XtGetGC(renew, valueMask, &values);
    redraw_indicator = TRUE;
  }
  if (w->dial.foreground != c->dial.foreground)
  {
    valueMask = GCForeground | GCBackground;
    values.foreground = w->dial.foreground;
    values.background = w->core.background_pixel;
    XtReleaseGC(renew, w->dial.dialGC);
    w->dial.dialGC = XtGetGC(renew, valueMask, &values);
    redraw = TRUE;
  }
  return (redraw);
}
#endif
