.\" X-BASED HEXAGONS
.\"
.\" xhexagons.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 2005	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH HEXAGONS 6 "05 Sep 2005" "V7.1.5"
.SH NAME
xhexagons \- Hexagons X widget
.SH SYNOPSIS
.B /usr/games/xhexagons
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-tile {color}] [-size{x|y} {int}]
[-[no]corners] [-delay msecs] [-[no]sound]
[-bumpSound {filename}] [-base {int}]
[-{font|fn} {fontname}] [-userName {string}]
[-scoreFile {filename}] [-scores] [-version]
.SH DESCRIPTION
.LP
A sliding tile puzzle.  A hexagonal version of the 15 puzzle.  The 17
puzzle was conceived of by Alwin Vietor and marketed in 1885 in Germany
as "Trilemma" with round pieces.  Sam Cornwell rediscovered this in 1989
with "Clockblocks" of which 12 were numbered using hexagonal pieces.
Also he produced a smaller 12 block puzzle with 9 that were numbered
called "Ninefield".  Also Bernhard Wiezorke came up with the similar 17
puzzle, "Hexafax, the New Fifteen Puzzle", in 1991 and a smaller 11
piece "Counterfax" of which 8 were numbered.
.SH FEATURES
If in corners mode: Press "\fBmouse-left\fP" button to move a tile, then
release "\fBmouse-left\fP" button on a space.  It will not move if blocked.
One can only move one tile at a time. The only tiles that can be moved are
the tile(s) next to both spaces.
.br
If in nocorners mode: Click "\fBmouse-left\fP" button to move a tile.
One can move more than one tile at a time and one is not constrained by
parity.
.LP
Click "\fBmouse-right\fP" button, or press "\fBR\fP" or "\fBr\fP" keys,
to randomize the puzzle.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle corners mode.  (Default is on).
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (not implemented).
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBC\fP" or "\fBc\fP" keys to clear a puzzle.
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of tiles.
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad, "R" keys, or arrow keys to move without the mouse.
.br
Key pad is defined for Hexagons as:
.br
7   9   Upper Left, Upper Right
.sp
  ^
.sp
4< >6   Left, Right
.sp
  v
.sp
1   3   Lower Left, Lower Right
.LP
The control key allows you to change the complexity of xhexagons.  Hold
down control key and use the keypad or arrow keys to reduce or enlarge
puzzle complexity.
.LP
The title is in the following format (non-motif version):
.RS
xhexagons: <size> @ (<Number of moves>/{<Record number of moves>
<user name>|"NEVER noaccess"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the hexagons window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to  display on a color screen as if monochrome
(resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the hexagons window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the hexagons window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the hexagons window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the tiles in the hexagons
window (resource name "\fIborderColor\fP").
.TP 8
.B \-tile \fIcolor\fP
This option specifies the tile color of the tiles in the hexagons window
(resource name "\fItileColor\fP").
.TP 8
.B \-size{x|y} <\fIint\fP>
This option allows you to change the number of hexagons in a row or
column (resource names "\fIsizeX\fP", "\fIsizeY\fP").
.TP 8
.B \-corners
This option specifies the mode where movement is very restrictive (resource
name "\fIcorners\fP").
.TP 8
.B \-nocorners
This option specifies the mode where movement is very easy (resource name
 "\fIcorners\fP").
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move a tile or
a group of tiles one space (1-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if a sliding tile should make a sound or not
(resource name "\fIsound\fP"). 
.TP 8
.B \-bumpSound \fIfilename\fP
This option specifies the file for the bump sound (resource name
"\fIbumpSound\fP").
.TP 8
.B \-base \fIint\fP
This option specifies the base used (default is base 10) (resource name
"\fIbase\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xhexagons you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get.
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
.RS
corners: 0-1 <0 false, 1 true; if 0 then hexagon corners are all snipped>
.br
sizeX: 1-10 <number of columns of tiles>
.br
sizeY: 1-10 <number of rows of tiles>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <array of tile positions where 0 is the empty space for
the HIGH hexagon and -1 is the empty space for the LOW hexagon (if present)>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <direction>
.RE
Direction is represented as 0 upper right, 1 right, 2 lower right,
3 lower left, 4 left, and 5 upper left.
.SH REFERENCES
Dieter Gebhardt, "From Trilemma to Counterfax", CFF 53, October 2000, pp 8-10.
.sp
Sam Cornwell, "Ninefield: a Sliding Block Puzzle", CFF 57, March 2002, pp 4-5.
.sp
Dieter Gebhardt, "Ninefield Revisited", CFF 58, July 2002, p 21.
.sp
Bernhard Wiezorke, "Hexafax, the New Fifteen Puzzle" brochure
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xmlink(6), xpanex(6), xcubes(6), xtriangles(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-2005, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ibiblio.org/pub/Linux/games/strategy\fP
