/*-
# X-BASED MASTERBALL(tm)
#
#  MballP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Mball */

#ifndef _MballP_h
#define _MballP_h

#include "xwin.h"
#include "timer.h"
#include "Mball.h"

#ifdef WINVER
extern void DestroyMball(HBRUSH brush);
extern void ResizeMball(MballWidget w);
extern void SizeMball(MballWidget w);
extern void InitializeMball(MballWidget w, HBRUSH brush);
extern void ExposeMball(MballWidget w);
extern void HideMball(MballWidget w);
extern void SelectMball(MballWidget w,
	const int x, const int y, const int shift);
extern void ReleaseMball(MballWidget w,
	const int x, const int y, const int shift);
extern void PracticeMball(MballWidget w);
extern void PracticeMballMaybe(MballWidget w);
extern void PracticeMball2(MballWidget w);
extern void RandomizeMball(MballWidget w);
extern void RandomizeMballMaybe(MballWidget w);
extern void RandomizeMball2(MballWidget w);
extern void ClearMball(MballWidget w);
extern void GetMball(MballWidget w);
extern void WriteMball(MballWidget w);
extern void UndoMball(MballWidget w);
extern void SolveMball(MballWidget w);
extern void IncrementMball(MballWidget w);
extern Boolean DecrementMball(MballWidget w);
extern void WedgeMball(MballWidget w, const int mode);
extern void Wedge2ModeMball(MballWidget w);
extern void Wedge4ModeMball(MballWidget w);
extern void Wedge6ModeMball(MballWidget w);
extern void Wedge8ModeMball(MballWidget w);
extern void Wedge10ModeMball(MballWidget w);
extern void Wedge12ModeMball(MballWidget w);
extern void OrientizeMball(MballWidget w);
extern void MiddleMball(MballWidget w);
extern void EnterMball(MballWidget w);
extern void LeaveMball(MballWidget w);
extern void MoveMballInput(MballWidget w,
	int x, int direction, int shift, int control);
extern int  MoveMballDir(MballWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _MballClassPart {
	int         ignore;
} MballClassPart;

typedef struct _MballClassRec {
	CoreClassPart coreClass;
	MballClassPart mballClass;
} MballClassRec;

extern MballClassRec mballClassRec;
#endif

#define SYMBOL ':'

#define TOP 0
#define TTR 1
#define TR 2
#define RIGHT 3
#define BR 4
#define BBR 5
#define BOTTOM 6
#define BBL 7
#define BL 8
#define LEFT 9
#define TL 10
#define TTL 11
#define COORD 12
#define CW 13
#define CCW 23
#define CUTS (COORD / 2)
#define SAME 0
#define OPPOSITE 1
#define DOWN 0
#define UP 1
#define MAXVIEWS 2

#define ST_ANG  (NUM_DEGREES/2)
#define RT_ANG  (NUM_DEGREES/4)
#define DEGREES(x) ((x)/M_PI*(double)ST_ANG)
#define RADIANS(x) (M_PI*(x)/(double)ST_ANG)
#define CIRCLE_2  (FULLCIRCLE/2)
#define CIRCLE_4  (FULLCIRCLE/4)

typedef struct _MballLoc {
	int         wedge, direction;
} MballLoc;

typedef struct _MballPart {
	MballLoc   *mballLoc[MAXWEDGES];
	int         currentWedge, currentRing;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         base;
	int         wedges, rings;
	Position    delta, dr;
	Position    mballLength;
	Position    wedgeLength;
	Position    viewLength, viewMiddle;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          wedgeGC[MAXWEDGES];
#ifdef WINVER
	char        userName[81], scoreFile[81];
	char        wedgeChar[MAXWEDGES];
#else
	int         menu;
	char       *userName, *scoreFile, *font;
	XFontStruct *fontInfo;
	char       *wedgeName[MAXWEDGES];
	Pixel       foreground, background;
        Pixel       frameColor, borderColor;
	Pixel       wedgeColor[MAXWEDGES];
	XtCallbackList select;
#endif
} MballPart;

typedef struct _MballRec {
	CorePart    core;
	MballPart   mball;
} MballRec;

extern MballLoc *startLoc[MAXWEDGES];
extern void SetMball(MballWidget w, int reason);
extern void MoveMball(MballWidget w, const int wedge, const int ring,
	const int direction, const int control);

#if 0
/* For future auto-solver */
extern void SolveWedges(MballWidget w);

#endif
extern void DrawAllWedges(MballWidget w);
extern Boolean CheckSolved(MballWidget w);
extern void InitMoves(void);
extern void PutMove(int wedge, int ring, int direction, int control);
extern void GetMove(int *wedge, int *ring, int *direction, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(MballWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, MballWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, MballWidget w);
extern void PrintStartPosition(FILE * fp, MballWidget w);
extern void SetStartPosition(MballWidget w);

#endif /* _MballP_h */
