.\" X-BASED MASTERBALL(tm)
.\"
.\" xmball.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 2005	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH MASTERBALL 6 "05 Oct 2005" "V7.1.5"
.SH NAME
xmball \- Masterball X widget
.SH SYNOPSIS
.B /usr/games/xmball
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-wedge{0|1|2|3|4|5|6|7|8|9|10|11} {color}]
[-wedges {int}] [-rings {int}] [-[no]orient] [-[no]practice]
[-base {int}] [-{font|fn} {fontname}] [-userName {string}]
[-scoreFile {filename}] [-scores] [-version]
.SH DESCRIPTION
.LP
The original puzzle has 8 sectors on a sphere (longitudinal cuts), with
each sector divided into 4 segments (latitudinal cuts).  There are
essentially 3 varieties: Geomaster 8 colors (beachball, default colors
in this puzzle), Duomaster 2 colors (black and white beachball), and a
variety of picture Masterballs.  For some reason, they say the Geomaster
is easier than the Duomaster.  The picture Masterballs are the hardest
since all the pieces have a set solved position.  On the Duo and Geo
Masterballs pieces could be swapped or in a different order and still be
in a solved position.  Zurick University's Mathematics faculty has
calculated that Masterball's 32 segments can be arranged in
355,682,548,566,633,480,192,000,000 different possible combinations.
Masterball was invented by Dr. Geza Gyovai Hungarian Engineer,
manufactured by Whole Systems Design, Inc..
.SH FEATURES
Press "\fBmouse-left\fP" button to move a sector.  Release
"\fBmouse-left\fP" button on another piece and the pieces will turn
towards where the mouse button is released.  Usually, a click and release
on the same wedge is ambiguous and the puzzle will not turn.
.LP
Click "\fBmouse-center\fP", or press "\fBP\fP" or "\fBp\fP" keys to toggle
the practice mode (in practice mode the record should say "practice").
This is good for learning moves and experimenting.
.LP
Click "\fBmouse-right\fP", or press "\fBR\fP" or "\fBr\fP" keys to randomize
the puzzle (this must be done first to set a new record).
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of rings.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of rings.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  One has to
orient the wedges in orient mode, besides getting all the wedges to be the
same color.  To do this one has to get the numbers to be on the same side
of the ball in clockwise order.
.LP
Press "\fB2\fP", "\fB4\fP", "\fB6\fP", "\fB8\fP", "\fB0\fP", or "\fB=\fP"
keys (not the keypad 2, 4, 6, 8, 0) to change to 2, 4, 6, 8, 10, or 12
wedges, respectively.  Note: if there were odd number of wedges, there
would be no 180 degree turn and therefore the puzzle would be inoperable.
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (not implemented).
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBC\fP" or "\fBc\fP" keys to clear a puzzle.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad, "R" keys, or arrow keys to move without mouse clicks.
.br
Key pad is defined for Masterball as:
.br
N / *   Upper Upper Left, Counterclockwise, Upper Upper Right
.sp
7 8 9   Upper Left, Up, Upper Right
.br
  ^
.br
4<5>6   Left, Clockwise, Right
.br
  v
.br
1 2 3   Lower Left, Down, Lower Right
.sp
 0  .   Lower Lower Left, Lower Lower Right
.LP
Use the control key and the left mouse button, keypad, or arrow keys to
move the whole Masterball.  This is not recorded as a turn.
.LP
The title is in the following format (non-motif version):
.RS
xmball.{2|4|6|8|10|12<wedges>}: <number of sectors per wedge> @
(<Number of moves>/{<Record number of moves>
<user name>|"NEVER noaccess"|"practice"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the masterball window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to  display on a color screen as if monochrome
(resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the masterball window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the masterball window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the masterball window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the sectors in the masterball
window (resource name "\fIborderColor\fP").
.TP 8
.B \-wedge{0|1|2|3|4|5|6|7|8|9|10|11} <\fIcolor\fP>
This option allows you to change the color of a wedge (resource name
"\fIwedgeColorN\fP"). In mono-mode, color is represented as the first letter
of the color name. The wedges are ordered clockwise.  If you have two colors
that begin with the same letter you should have one in uppercase and one in
lowercase to distinguish them in mono-mode. You can change the colors of the
wedges to make a stupid Masterball (i.e. all White or in mono-mode all "W").
Unfortunately, it will not normally say its solved when its randomized.
Similarly, with the Duomasterball (black and white), it may be solved
color-wise but not by its internal representation.  This would be cheating.
.TP 8
.B \-wedges <\fIint\fP>
This option allows you to change the number of wedges (resource name
"\fIwedges\fP").
.TP 8
.B \-rings <\fIint\fP>
This option allows you to change the number of rings (resource name
"\fIrings\fP").
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]practice
This option allows you to access the practice mode (resource name
"\fIpractice\fP").
.TP 8
.B \-base \fIint\fP
This option specifies the base used (default is base 16) (resource name
"\fIbase\fP").  When there are 12 wedges there is not much room, so base
10 was not used as the default.
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xmball you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get.
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
Masterball numbered clockwise, with default colors, not randomized:
.br
    0            Y       Yellow
.br
10     2      D     B    Dark Green, Blue
.sp
9       3    C       R   Cyan, Red
.sp
 8     4      O     M    Orange, Magenta
.br
    6            G       Green
.sp
Extra colors: Pink, Saddle Brown, Light Steel Blue, Indian Red
.sp
.RS
wedges: 2-12 <number of wedges around ball (even only)>
.br
rings: 1-MAXINT <number of slices around ball>
.br
orient: 0-1 <0 false, 1 true; if true then numbers on puzzle to be
oriented and ordered>
.br
practice: 0-1 <0 false, 1 true>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <2 dimensional array of sector wedge position,
if orient mode then orientation number follows each wedge number>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <wedge> <ring> <direction> <control>
.RE
Each turn is with respect to a sector defined by wedge and ring.
.br
Direction is represented as 0 up, 1 upper upper right, 2 upper right,
3 right, 4 lower right, 5 lower lower right, 6 down, 7 lower lower left,
8 lower left, 9 left, 10 upper left, 11 upper upper left, 13 clockwise, and
23 counterclockwise.
.br
Control is represented as 0 or 1, 1 if the whole ball is moved at once, 0
if not.  The xmball record keeper does not count a control move as a move,
but here we do.
.SH REFERENCES
http://wsd.com/masterball
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6),
xmlink(6), xpanex(6), xcubes(6), xtriangles(6), xhexagons(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-2005, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ibiblio.org/pub/Linux/games/strategy\fP
