/*-
# X-BASED PANEX(tm)
#
#  Panex.h
#
###
#
#  Copyright (c) 1996 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Panex */

#ifndef _XtPanex_h
#define _XtPanex_h

/***********************************************************************
 *
 * Panex Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNtiles ((char *) "tiles")
#define XtNmode ((char *) "mode")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNmenu ((char *) "menu")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNtileBorder ((char *) "tileBorder")
#define XtNpyramidColor0 ((char *) "pyramidColor0")
#define XtNpyramidColor1 ((char *) "pyramidColor1")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCTiles ((char *) "Tiles")
#define XtCMode ((char *) "Mode")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCMenu ((char *) "Menu")

typedef struct _PanexClassRec *PanexWidgetClass;

extern WidgetClass panexWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} panexCallbackStruct;
#endif

#define PANEX_HIDE (-8)
#define PANEX_RESET_QUERY (-7)
#define PANEX_RESTORE (-6)
#define PANEX_RESET (-5)
#define PANEX_ILLEGAL (-4)
#define PANEX_BLOCKED (-3)
#define PANEX_SPACE (-2)
#define PANEX_IGNORE (-1)
#define PANEX_MOVED 0
#define PANEX_SOLVED 1
#define PANEX_DEC 2
#define PANEX_INC 3
#define PANEX_MODE 4
#define PANEX_COMPUTED 5
#define PANEX_UNDO 6
#define PANEX_SPEED 7

#define MINTILES 1
#define DEFAULTTILES 10
#define HANOI 0
#define PANEX 1
#define MAXMODES 2
#define DEFAULTMODE PANEX
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define DEFAULTDELAY 10

typedef struct _PanexRec *PanexWidget;

#endif /* _XtPanex_h */
/* DON'T ADD STUFF AFTER THIS #endif */
