/*-
# X-BASED PYRAMINX(tm)
#
#  PyraminxP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Pyraminx */

#ifndef _PyraminxP_h
#define _PyraminxP_h

#include "xwin.h"
#include "timer.h"
#include "Pyraminx.h"

#ifdef WINVER
extern void DestroyPyraminx(HBRUSH brush);
extern void ResizePyraminx(PyraminxWidget w);
extern void SizePyraminx(PyraminxWidget w);
extern void InitializePyraminx(PyraminxWidget w, HBRUSH brush);
extern void ExposePyraminx(PyraminxWidget w);
extern void HidePyraminx(PyraminxWidget w);
extern void SelectPyraminx(PyraminxWidget w,
	const int x, const int y, const int control);
extern void ReleasePyraminx(PyraminxWidget w,
	const int x, const int y, const int shift, const int control);
extern void PracticePyraminx(PyraminxWidget w);
extern void PracticePyraminxMaybe(PyraminxWidget w);
extern void PracticePyraminx2(PyraminxWidget w);
extern void RandomizePyraminx(PyraminxWidget w);
extern void RandomizePyraminxMaybe(PyraminxWidget w);
extern void RandomizePyraminx2(PyraminxWidget w);
extern void ClearPyraminx(PyraminxWidget w);
extern void GetPyraminx(PyraminxWidget w);
extern void WritePyraminx(PyraminxWidget w);
extern void UndoPyraminx(PyraminxWidget w);
extern void SolvePyraminx(PyraminxWidget w);
extern void IncrementPyraminx(PyraminxWidget w);
extern Boolean DecrementPyraminx(PyraminxWidget w);
extern void OrientizePyraminx(PyraminxWidget w);
extern void StickyModePyraminx(PyraminxWidget w);
extern void PeriodModePyraminx(PyraminxWidget w, const int mode);
extern void Period2ModePyraminx(PyraminxWidget w);
extern void Period3ModePyraminx(PyraminxWidget w);
extern void BothModePyraminx(PyraminxWidget w);
extern void EnterPyraminx(PyraminxWidget w);
extern void LeavePyraminx(PyraminxWidget w);
extern void MovePyraminxInput(PyraminxWidget w,
	int x, int y, int direction, int shift, int control);
extern int  MovePyraminxDir(PyraminxWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _PyraminxClassPart {
	int         ignore;
} PyraminxClassPart;

typedef struct _PyraminxClassRec {
	CoreClassPart coreClass;
	PyraminxClassPart pyraminxClass;
} PyraminxClassRec;

extern PyraminxClassRec pyraminxClassRec;
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TOP 0
#define TR 1
#define RIGHT 2
#define BOTTOM 3
#define BL 4
#define LEFT 5
#define COORD 6
#define CW 7
#define CCW 11

#define MAXFACES 4
#define DOWN 0
#define UP 1
#define MAXVIEWS 2
#define MAXSIDES (MAXFACES/MAXVIEWS)
#define MAXORIENT (3*MAXSIDES)

typedef struct _PyraminxLoc {
	int         face, rotation;
} PyraminxLoc;

typedef struct _PyraminxPart {
	PyraminxLoc *facetLoc[MAXFACES];
	PyraminxLoc *faceLoc[MAXSIDES];
	PyraminxLoc *rowLoc[3][MAXSIDES];
	int         currentFace, currentPosition;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, sticky, focus;
	Boolean     scoreOnly, versionOnly;
	int         size, sizeSize, mode;
	int         delay;
	Position    delta;
	Position    facetLength;
	Position    faceLength;
	Position    viewLength;
	Position    sideOffset, orientLineLength, orientDiagLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        userName[81], scoreFile[81];
	char        faceChar[MAXFACES];
#else
	int         menu;
	char       *userName, *scoreFile, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} PyraminxPart;

typedef struct _PyraminxRec {
	CorePart    core;
	PyraminxPart pyraminx;
} PyraminxRec;

extern PyraminxLoc *startLoc[MAXFACES];
extern void SetPyraminx(PyraminxWidget w, int reason);
extern void MovePyraminx(PyraminxWidget w, int face, int position,
	int direction, int style, int control);
extern void MovePyraminxDelay(PyraminxWidget w, int face, int position,
	int direction, int style, int control);

extern void SolveSomePieces(PyraminxWidget w);
extern void DrawAllPieces(PyraminxWidget w);
extern Boolean CheckSolved(PyraminxWidget w);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int style,
	int control);
extern void GetMove(int *face, int *position, int *direction, int *style,
	int *control);
extern int  MadeMoves(void);
extern void FlushMoves(PyraminxWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, PyraminxWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, PyraminxWidget w);
extern void PrintStartPosition(FILE * fp, PyraminxWidget w);
extern void SetStartPosition(PyraminxWidget w);

#endif /* _PyraminxP_h */
