.\" X-BASED THREED
.\"
.\" xthreed.man
.\"
.\" ##
.\"
.\" Copyright (c) 1995 - 2005	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH THREED 6 "05 Oct 2005" "V7.1.5"
.SH NAME
xthreed \- Threed X widget
.SH SYNOPSIS
.B /usr/games/xthreed
[-display <display>] [-geometry <geometry>]
[-{foreground | fg} <color>] [-{background | bg} <color>] [-[no]surface]
[-object {int}] [-distance {int}] [-theta {int}] [-phi {int}]
[-white {color}] [-[lt|dk]gray {color}] [-black {color}]
[-another {color}] [-version]
.SH DESCRIPTION
.LP
Press "\fBL\fP" or "\fBl\fP" keys to move shape left.
.LP
Press "\fBR\fP" or "\fBr\fP" keys to move shape right.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to move shape up.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to move shape down.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to move shape in.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to move shape out.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to change surface.
.LP
Press "\fBB\fP" or "\fBb\fP" keys to change object.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
"\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys kill program.
.LP
Use the key pad, "R" keys, or arrow keys to rotate object.
.br
Key pad is defined for Threed as:
.br
  /      Counterclockwise
.sp
  8      Up
.br
  ^
.br
4<5>6  Left, Clockwise, Right
.br
  v
.br
  2      Down
.LP
I debated releasing this, since it needs some work.  Also I
figured there was other 3D viewers out there.  Well, this one is real
simple, it only uses the X libs, so it might be useful to someone
out there.  If you have any improvements to make, let me know.
.LP
In the sample data, Cubes and F16 are big, so the polyhedrons are
scaled up to them in the data file.
Roll and Pitch.
.SH OPTIONS
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the threed window (resource
name "\fIgeometry\fP").
.TP 8
.B \-{foreground | fg} \fIcolor\fP
This option specifies the foreground of the threed window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background | bg} \fIcolor\fP
This option specifies the background of the threed window (resource name
"\fIbackground\fP").
.TP 8
.B \-[no]surface
This option allows you to access the hidden surface removal mode and
wire mode (resource name "\fIsurface\fP").
.TP 8
.B \-object <\fIint\fP>
This option allows you to set the object to be viewed (resource name
"\fIobject\fP").
.TP 8
.B \-distance <\fIint\fP>
This option allows you to set the distance of the object to be viewed
(resource name "\fIdistance\fP").
.TP 8
.B \-theta <\fIint\fP>
This option allows you to set the angle of the to be viewed in degrees
(resource name "\fIthetaDegrees\fP").  This corresponds to yaw.
.TP 8
.B \-phi <\fIint\fP>
This option allows you to set the angle of the to be viewed in degrees
(resource name "\fIphiDegrees\fP").  This corresponds to a combination
of roll and pitch.
.TP 8
.B \-white \fIcolor\fP
This option specifies the color of the white paintbrush (resource name
"\fIwhiteBrush\fP").
.TP 8
.B \-[lt|dk]gray \fIcolor\fP
This option specifies the color of the gray the paintbrush (resource name
"\fI[lt|dk]grayBrush\fP").
.TP 8
.B \-black \fIcolor\fP
This option specifies the color of the black of the paintbrush (resource name
"\fIblackBrush\fP").
.TP 8
.B \-another \fIcolor\fP
This option specifies the of color of the a paintbrush (resource name
"\fIanotherBrush\fP").
.TP 8
.B \-version
This option tells you what version of xthreed you have.
.SH SEE ALSO
.LP
X(1), xcubes(6), xtriangles(6), xhexagons(6), xmlink(6), xrubik(6),
xskewb(6), xdino(6), xpanex(6), xpyraminx(6), xoct(6), xmball(6),
xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1995-2005, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
