/*-
# X-BASED TRIANGLES
#
#  TrianglesP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Triangles */

#ifndef _TrianglesP_h
#define _TrianglesP_h

#include "xwin.h"
#include "timer.h"
#include "Triangles.h"

#ifdef WINVER
extern void DestroyTriangles(HBRUSH brush);
extern void ResizeTriangles(TrianglesWidget w);
extern void SizeTriangles(TrianglesWidget w);
extern void InitializeTriangles(TrianglesWidget w, HBRUSH brush);
extern void ExposeTriangles(TrianglesWidget w);
extern void HideTriangles(TrianglesWidget w);
extern void SelectTriangles(TrianglesWidget w, const int x, const int y);
extern void ReleaseTriangles(TrianglesWidget w);
extern void RandomizeTriangles(TrianglesWidget w);
extern void RandomizeTrianglesMaybe(TrianglesWidget w);
extern void RandomizeTriangles2(TrianglesWidget w);
extern void ClearTriangles(TrianglesWidget w);
extern void GetTriangles(TrianglesWidget w);
extern void WriteTriangles(TrianglesWidget w);
extern void UndoTriangles(TrianglesWidget w);
extern void SolveTriangles(TrianglesWidget w);
extern void IncrementTriangles(TrianglesWidget w);
extern void DecrementTriangles(TrianglesWidget w);
extern void SpeedTriangles(TrianglesWidget w);
extern void SlowTriangles(TrianglesWidget w);
extern void SoundTriangles(TrianglesWidget w);
extern void EnterTriangles(TrianglesWidget w);
extern void LeaveTriangles(TrianglesWidget w);
extern int MoveTriangles(TrianglesWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _TrianglesClassPart {
	int ignore;
} TrianglesClassPart;

typedef struct _TrianglesClassRec {
	CoreClassPart coreClass;
	TrianglesClassPart trianglesClass;
} TrianglesClassRec;

extern TrianglesClassRec trianglesClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif

#define SYMBOL ':'

#define TR 0
#define RIGHT 1
#define BR 2
#define BL 3
#define LEFT 4
#define TL 5
#define COORD 6
#define TRBL 0
#define TLBR 1
#define ROW 2
#define ROWTYPES 3
#define DOWN 0
#define UP 1
#define MAXORIENT 2

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _TrianglesPart {
	int        *tileOfPosition, spacePosition[MAXORIENT];
	int         spaceRow[MAXORIENT][ROWTYPES];
	int         currentPosition, currentRow[ROWTYPES];
	int         currentPositionOrient;
	Boolean     started, cheat, sound;
	Boolean     mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         delay, numSlices;
	int         base;
	int         size, sizeSize;
	Point       offset, tileSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
	Pixmap      bufferTiles[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], bumpSound[81];
	char	    picture[81];
#else
	int         menu, graphicsFormat;
	char       *userName, *scoreFile, *bumpSound;
	char       *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	XtCallbackList select;
#endif
} TrianglesPart;

typedef struct _TrianglesRec {
	CorePart core;
	TrianglesPart triangles;
} TrianglesRec;

extern int *startPosition;
extern void SetTriangles(TrianglesWidget w, int reason);
extern int MoveTrianglesDir(TrianglesWidget w, const int direction,
	const int fast);

#if 0
/* For future auto-solver */
extern void SolveSomeTiles(TrianglesWidget w);
#endif
extern void DrawAllTiles(const TrianglesWidget w);
extern Boolean CheckSolved(const TrianglesWidget w);
extern void InitMoves(void);
extern void PutMove(int direction);
extern void GetMove(int *direction);
extern int MadeMoves(void);
extern void FlushMoves(TrianglesWidget w);
extern int NumMoves(void);
extern void ScanMoves(FILE * fp, TrianglesWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, TrianglesWidget w);
extern void PrintStartPosition(FILE * fp, TrianglesWidget w);
extern void SetStartPosition(TrianglesWidget w);
extern int Row(const int pos);
extern int TrBl(const int pos, const int posRow);
extern int TlBr(const int pos, const int posRow);

#endif /* _TrianglesP_h */
