/*-
# X-BASED HEXAGONS
#
#  HexagonsP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Hexagons */

#ifndef _HexagonsP_h
#define _HexagonsP_h

#include "xwin.h"
#include "timer.h"
#include "Hexagons.h"

#ifdef WINVER
extern void DestroyHexagons(HBRUSH brush);
extern void ResizeHexagons(HexagonsWidget w);
extern void SizeHexagons(HexagonsWidget w);
extern void InitializeHexagons(HexagonsWidget w, HBRUSH brush);
extern void ExposeHexagons(HexagonsWidget w);
extern void HideHexagons(HexagonsWidget w);
extern void SelectHexagons(HexagonsWidget w, const int x, const int y);
extern void ReleaseHexagons(HexagonsWidget w, const int x, const int y);
extern void RandomizeHexagons(HexagonsWidget w);
extern void RandomizeHexagonsMaybe(HexagonsWidget w);
extern void RandomizeHexagons2(HexagonsWidget w);
extern void ClearHexagons(HexagonsWidget w);
extern void GetHexagons(HexagonsWidget w);
extern void WriteHexagons(HexagonsWidget w);
extern void UndoHexagons(HexagonsWidget w);
extern void SolveHexagons(HexagonsWidget w);
extern void ModeHexagons(HexagonsWidget w);
extern void SpeedHexagons(HexagonsWidget w);
extern void SlowHexagons(HexagonsWidget w);
extern void SoundHexagons(HexagonsWidget w);
extern void EnterHexagons(HexagonsWidget w);
extern void LeaveHexagons(HexagonsWidget w);
extern int MoveHexagons(HexagonsWidget w, const int direction,
	const int control);

#else

/* This gets around C's inability to do inheritance */
typedef struct _HexagonsClassPart {
	int ignore;
} HexagonsClassPart;

typedef struct _HexagonsClassRec {
	CoreClassPart coreClass;
	HexagonsClassPart hexagonsClass;
} HexagonsClassRec;

extern HexagonsClassRec hexagonsClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif

#define SYMBOL ':'

#define TR 0
#define RIGHT 1
#define BR 2
#define BL 3
#define LEFT 4
#define TL 5
#define COORD 6
#define TOP 6
#define BOTTOM 9
#define TRBL 0
#define TLBR 1
#define ROW 2
#define ROWTYPES 3
#define LOW 0
#define HIGH 1
#define SPACES 2

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _HexagonsPart {
	int        *tileOfPosition, spacePosition[SPACES];
	int         spaceRow[ROWTYPES];
	int         currentPosition, currentRow[ROWTYPES];
	Boolean     started, cheat, sound;
	Boolean     corners, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         delay, numSlices;
	int         base;
	int         sizeX, sizeY, sizeSize, sizeCenter;
	Point       offset, tileSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
	Pixmap      bufferTiles[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], bumpSound[81], picture[81];
#else
	int         menu, graphicsFormat;
	char       *userName, *scoreFile, *bumpSound;
	char       *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	XtCallbackList select;
#endif
} HexagonsPart;

typedef struct _HexagonsRec {
	CorePart core;
	HexagonsPart hexagons;
} HexagonsRec;

extern int *startPosition;
extern void SetHexagons(HexagonsWidget w, int reason);
extern int MoveHexagonsDir(HexagonsWidget w, const int direction,
	const int fast);

#if 0
/* For future auto-solver */
extern void SolveSomeTiles(HexagonsWidget w);
#endif
extern void DrawAllTiles(const HexagonsWidget w);
extern Boolean CheckSolved(const HexagonsWidget w);
extern void InitMoves(void);
extern void PutMove(int direction);
extern void GetMove(int *direction);
extern int MadeMoves(void);
extern void FlushMoves(HexagonsWidget w);
extern int NumMoves(void);
extern void ScanMoves(FILE * fp, HexagonsWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, HexagonsWidget w);
extern void PrintStartPosition(FILE * fp, HexagonsWidget w);
extern void SetStartPosition(HexagonsWidget w);
extern int Row(HexagonsWidget w, const int pos);
extern int TrBl(HexagonsWidget w, const int pos, const int posRow);
extern int TlBr(HexagonsWidget w, const int pos, const int posRow);

#endif /* _HexagonsP_h */
