/*-
# X-BASED RUBIK'S CUBE(tm)
#
#  RubikP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Rubik */

#ifndef _RubikP_h
#define _RubikP_h

#include "xwin.h"
#include "timer.h"
#include "Rubik.h"

#ifdef WINVER
extern void DestroyRubik(HBRUSH brush);
extern void ResizeRubik(RubikWidget w);
extern void SizeRubik(RubikWidget w);
extern void InitializeRubik(RubikWidget w, HBRUSH brush);
extern void ExposeRubik(RubikWidget w);
extern void IncrementAxisRubik(RubikWidget w, char axis);
extern void DimRubik(RubikWidget w);
extern int  MoveRubikDir(RubikWidget w, const int direction);
extern void SetRubikMove(RubikWidget w, int reason, int face, int position,
	int direction, Boolean control, int fast);

#else

/* This gets around C's inability to do inheritance */
typedef struct _RubikClassPart {
	int         ignore;
} RubikClassPart;

typedef struct _RubikClassRec {
	CoreClassPart coreClass;
	RubikClassPart rubikClass;
} RubikClassRec;

extern RubikClassRec rubikClassRec;

extern void QuitRubik(RubikWidget w, XEvent * event, char **args, int nArgs);
extern void MoveRubikCw(RubikWidget w, XEvent * event, char **args, int nArgs);
extern void MoveRubikCcw(RubikWidget w, XEvent * event, char **args,
	int nArgs);
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define MAXMAXSIZE (MAX(w->rubik.sizex,MAX(w->rubik.sizey,w->rubik.sizez)))
#define MAXTURNINC 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _RubikLoc {
	char        face, rotation;
} RubikLoc;

typedef struct _RubikPart {
	RubikLoc   *cubeLoc[MAXFACES];
	RubikLoc   *rowLoc[MAXORIENT];
	int         currentFace, currentPosition, currentDirection, currentFast;
	Boolean     currentControl;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         delay;
	int         sizex, sizey, sizez;
	int         degreeTurn;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        userName[81], scoreFile[81];
	char        faceChar[MAXFACES];
#else
	int         menu;
	char       *userName, *scoreFile, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} RubikPart;

typedef struct _RubikRec {
	CorePart    core;
	RubikPart   rubik;
} RubikRec;

typedef struct _RowNext {
	int         face, direction, sideFace;
} RowNext;

extern RubikLoc *startLoc[MAXFACES];

extern void HideRubik(
#ifdef WINVER
const RubikWidget w
#else
RubikWidget w, XEvent * event, char **args, int nArgs
#endif
);
extern void SelectRubik(RubikWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void ReleaseRubik(RubikWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void PracticeRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void PracticeRubikMaybe(RubikWidget w
, XEvent * event, char **args, int nArgs
);
extern void PracticeRubik2(RubikWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void RandomizeRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void RandomizeRubikMaybe(RubikWidget w
, XEvent * event, char **args, int nArgs
);
extern void RandomizeRubik2(RubikWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void GetRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void WriteRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void ClearRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void UndoRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void SolveRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void OrientizeRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void DecrementRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void IncrementRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void IncrementXRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void IncrementYRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void IncrementZRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void EnterRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void LeaveRubik(RubikWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);

extern void MoveRubikInput(RubikWidget w,
	int x, int y, int direction, int control);
extern void SetRubik(RubikWidget w, int reason);
extern void MoveRubik(RubikWidget w,
	const int face, const int position, const int direction,
	const Boolean control, int fast);
extern void MoveRubikDelay(RubikWidget w,
	const int face, const int position, const int direction,
	const Boolean control);
#if (!defined(WINVER) || (WINVER <= 0x030a))
extern void Sleep(unsigned int cMilliseconds);
#endif
extern void SetAllColors(RubikWidget w);
extern void ResetPieces(RubikWidget w);
extern void SolveSomePieces(RubikWidget w);
extern void DrawAllPieces(const RubikWidget w);
extern Boolean CheckSolved(const RubikWidget w, Boolean rotation);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int control);
extern void GetMove(int *face, int *position, int *direction, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(RubikWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, RubikWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, RubikWidget w);
extern void PrintStartPosition(FILE * fp, RubikWidget w);
extern void SetStartPosition(RubikWidget w);
extern void faceSizes(const RubikWidget w, const int face, int *sizeOfRow, int *sizeOfColumn);
extern int  sizeFace(const RubikWidget w, const int face);
extern int  sizeRow(const RubikWidget w, const int face);

#ifdef DEBUG
extern void PrintCube(const RubikWidget w);
extern void PrintRow(const RubikWidget w, const int orient, const int size);

#endif

#endif /* _RubikP_h */
