/*-
# X-BASED BARREL(tm)
#
#  Barrel.h
#
###
#
#  Copyright (c) 1994 - 2007	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Barrel */

#ifndef _XtBarrel_h
#define _XtBarrel_h

/***********************************************************************
 *
 * Barrel Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNtileBorder ((char *) "tileBorder")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNtiles ((char *) "tiles")
#define XtNfaces ((char *) "faces")
#define XtNorient ((char *) "orient")
#define XtNpairs ((char *) "pairs")
#define XtNpractice ((char *) "practice")
#define XtNbase ((char *) "base")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCTiles ((char *) "Tiles")
#define XtCFaces ((char *) "Faces")
#define XtCOrient ((char *) "Orient")
#define XtCPairs ((char *) "Pairs")
#define XtCPractice ((char *) "Practice")
#define XtCBase ((char *) "Base")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")

typedef struct _BarrelClassRec *BarrelWidgetClass;

extern WidgetClass barrelWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} barrelCallbackStruct;
#endif

#define PUZZLE_HIDE (-9)
#define PUZZLE_PRACTICE_QUERY (-8)
#define PUZZLE_RANDOMIZE_QUERY (-7)
#define PUZZLE_SOLVE_MESSAGE (-6)
#define PUZZLE_RESTORE (-5)
#define PUZZLE_RESET (-4)
#define PUZZLE_BLOCKED (-3)
#define PUZZLE_SPACE (-2)
#define PUZZLE_IGNORE (-1)
#define PUZZLE_MOVED 0
#define PUZZLE_SOLVED 1
#define PUZZLE_CONTROL 2
#define PUZZLE_PRACTICE 3
#define PUZZLE_RANDOMIZE 4
#define PUZZLE_ORIENTIZE 5
#define PUZZLE_PAIRS 6
#define PUZZLE_DEC_X 7
#define PUZZLE_INC_X 8
#define PUZZLE_DEC_Y 9
#define PUZZLE_INC_Y 10
#define PUZZLE_COMPUTED 11
#define PUZZLE_UNDO 12
#define PUZZLE_REDO 13
#define PUZZLE_SPEED 14

#define MENU_GET 0
#define MENU_WRITE 1
#define MENU_EXIT 2
#define MENU_UNDO 3
#define MENU_REDO 4
#define MENU_CLEAR 5
#define MENU_RANDOMIZE 6
#define MENU_PRACTICE 7
#define MENU_SOLVE 8
#define MENU_ORIENTIZE 9
#define MENU_PAIRS 10
#define MENU_SPEED 11
#define MENU_SLOW 12
#define MENU_SOUND 13

#define MINFACES 5
#define MAXFACES 5
#define MINTILES 6
#define MAXTILES 6
#define DEFAULTFACES 5
#define DEFAULTTILES 6
#define DEFAULTORIENT FALSE
#define DEFAULTPAIRS TRUE
#define DEFAULTPRACTICE TRUE
#define DEFAULTDELAY 10
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 10

typedef struct _BarrelRec *BarrelWidget;

#endif /* _XtBarrel_h */
/* DON'T ADD STUFF AFTER THIS #endif */
