/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* 
 * sig.c
 *
 * ʥϢؿ
 *
 */

#include"sig.h"

/*
#define DEBUG_SIG
*/
void SetSignalHandler(int sig, void (*handler)(int))
{
#if HAVE_SIGACTION
    struct sigaction sat;
    sat.sa_handler = handler;
    sigemptyset(&sat.sa_mask);
    sat.sa_flags = SA_RESTART;
    sigaction( sig, &sat, NULL );
#ifdef DEBUG_SIG
    printf("set sigaction  %d 0x%x\n",sig,handler);
#endif
#elif HAVE_SIGNAL && HAVE_SIGBLOCK
    signal( sig, handler );
#ifdef DEBUG_SIG
    printf("set signal  %d 0x%x\n",sig,handler);
#endif
#elif HAVE_SIGNAL && HAVE_SIGHOLD
    signal( sig, handler );
#ifdef DEBUG_SIG
    printf("set signal  %d 0x%x\n",sig,handler);
#endif
#endif
    return;
}

void SignalBlock(int sig)
{
#if HAVE_SIGACTION
    sigset_t set;
    sigemptyset(&set);
    sigaddset(&set,sig);
    sigprocmask( SIG_BLOCK, &set, NULL );
#ifdef DEBUG_SIG
    printf("block sigprocmask  %d\n",sig);
#endif
#elif HAVE_SIGNAL && HAVE_SIGBLOCK
    sigblock( sig );
#ifdef DEBUG_SIG
    printf("block sigblock  %d\n",sig);
#endif
#elif HAVE_SIGNAL && HAVE_SIGHOLD
    sighold( SIGUSR1 );
#ifdef DEBUG_SIG
    printf("block sighold  %d\n",sig);
#endif
#endif
    return;
}


BOOL SignalUnblock(int sig)
{
    BOOL r = FALSE;
#if HAVE_SIGACTION
    sigset_t set;
    sigpending( &set );
    r = sigismember( &set, sig );
    sigemptyset(&set);
    sigaddset(&set,sig);
    sigprocmask( SIG_UNBLOCK, &set, NULL );
#ifdef DEBUG_SIG
    printf("unblock sigprocmask  %d\n",sig);
#endif
#elif HAVE_SIGNAL && HAVE_SIGBLOCK
    sigsetmask( ((sigblock(sig)) & ~(sigmask(sig))) );
#ifdef DEBUG_SIG
    printf("unblock sigsetmask  %d\n",sig);
#endif
#elif HAVE_SIGNAL && HAVE_SIGHOLD
    sigrelse( SIGUSR1 );
#ifdef DEBUG_SIG
    printf("unblock sigrelse  %d\n",sig);
#endif
#endif
    return r;
}


