/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: config_menu.c,v 1.1 2000/01/02 01:49:04 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include <GL/glut.h>

#include "xracer.h"
#include "xracer-mode.h"
#include "xracer-menu.h"

/* Program-level menu initialization. */
void
xrConfigurationMenuInit ()
{
}

static const char *items[] = {
  "Keyboard & joystick configuration",
  "Sound configuration",
  "Back"
};

static void
keyboard_configuration ()
{
  xrEnterMode (&xrKeyboardConfigurationMenuMode, 0);
}

static void
sound_configuration ()
{
  /*xrEnterMenu (&xrSoundConfigurationMenuMode, 0);*/
}

static void
back ()
{
  xrEnterMenu (&xrStartMenu, 0);
}

static void (*actions[])(void) = {
  keyboard_configuration,
  sound_configuration,
  back
};

struct xrMenu xrConfigurationMenu = {
  name: "configuration menu",
  title: "Configuration",
  nr_items: 3,
  items: items,
  actions: actions
};
