// file      : xsde/cxx/serializer/serializer-inline.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <cxx/serializer/serializer-inline.hxx>

#include <xsd-frontend/semantic-graph.hxx>
#include <xsd-frontend/traversal.hxx>

namespace CXX
{
  namespace Serializer
  {
    namespace
    {
      //
      //
      struct List: Traversal::List, protected virtual Context
      {
        List (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& l)
        {
          String const& name (ename (l));
          SemanticGraph::Type& t (l.argumented ().type ());

          String item (unclash (name, "item"));

          os << "// " << name << endl
             << "//" << endl
             << endl;

          // item_serializer
          //
          os << inl
             << "void " << name << "::" << endl
             << unclash (name, "item_serializer") << " (" <<
            fq_name (t) << "& " << item << ")"
             << "{"
             << "this->_xsde_" << item << "_ = &" << item << ";"
             << "}";

          // serializers
          //
          os << inl
             << "void " << name << "::" << endl
             << "serializers (" << fq_name (t) << "& " << item << ")"
             << "{"
             << "this->_xsde_" << item << "_ = &" << item << ";"
             << "}";

          // c-tor
          //
          os << inl
             << name << "::" << endl
             << name << " ()" << endl
             << ": _xsde_" << item << "_ (0)"
             << "{"
             << "}";
        }
      };

      //
      //
      struct ParticleAccessor: Traversal::Element,
                               protected virtual Context
      {
        ParticleAccessor (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (SemanticGraph::Element& e)
        {
          String const& name (ename (e));

          os << inl
             << "void " << ename (e.scope ()) << "::" << endl
             << eserializer (e) << " (" << fq_name (e.type ()) << "& " <<
            name << ")"
             << "{"
             << "this->" << emember (e) << " = &" << name << ";"
             << "}";
        }
      };

      struct AttributeAccessor: Traversal::Attribute,
                                protected virtual Context
      {
        AttributeAccessor (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& a)
        {
          String const& name (ename (a));

          os << inl
             << "void " << ename (a.scope ()) << "::" << endl
             << eserializer (a) << " (" << fq_name (a.type ()) << "& " <<
            name << ")"
             << "{"
             << "this->" << emember (a) << " = &" << name << ";"
             << "}";
        }
      };

      //
      //
      struct ParticleMemberSet: Traversal::Element,
                               protected virtual Context
      {
        ParticleMemberSet (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (SemanticGraph::Element& e)
        {
          os << "this->" << emember (e) << " = &" << ename (e) << ";";
        }
      };

      struct AttributeMemberSet: Traversal::Attribute,
                                protected virtual Context
      {
        AttributeMemberSet (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& a)
        {
          os << "this->" << emember (a) << " = &" << ename (a) << ";";
        }
      };

      struct BaseMemberSet: Traversal::Complex,
                            Traversal::List,
                            protected virtual Context
      {
        BaseMemberSet (Context& c)
            : Context (c)
        {
          inherits_ >> *this;
        }

        virtual Void
        traverse (SemanticGraph::Complex& c)
        {
          inherits (c, inherits_);

          if (!restriction_p (c))
          {
            names (c);
            contains_compositor (c);
          }
        }

        virtual Void
        traverse (SemanticGraph::List& l)
        {
          String const& name (ename (l));
          String item (unclash (name, "item"));

          os << "this->_xsde_" << item << "_ = &" << name << "_item;";
        }

      private:
        Traversal::Inherits inherits_;
      };

      //
      //
      struct ParticleMemberInit: Traversal::Element,
                                 protected virtual Context
      {
        ParticleMemberInit (Context& c, Boolean comma)
            : Context (c), first_ (!comma)
        {
        }

        virtual Void
        traverse (SemanticGraph::Element& e)
        {
          if (first_)
            first_ = false;
          else
            os << "," << endl << "  ";

          os << emember (e) << " (0)";
        }

      private:
        Boolean first_;
      };

      struct AttributeMemberInit: Traversal::Attribute,
                                  protected virtual Context
      {
        AttributeMemberInit (Context& c)
            : Context (c), first_ (true)
        {
        }

        virtual Void
        traverse (Type& a)
        {
          if (first_)
            first_ = false;
          else
            os << "," << endl << "  ";

          os << emember (a) << " (0)";
        }

        Boolean
        comma () const
        {
          return !first_;
        }

      private:
        Boolean first_;
      };


      //
      //
      struct Complex: Traversal::Complex,
                      protected virtual Context
      {
        Complex (Context& c)
            : Context (c),
              particle_accessor_ (c),
              attribute_accessor_ (c),
              base_set_ (c),
              particle_set_ (c),
              attribute_set_ (c)
        {
          // Accessor.
          //
          contains_compositor_accessor_ >> compositor_accessor_;
          compositor_accessor_ >> contains_particle_accessor_;
          contains_particle_accessor_ >> compositor_accessor_;
          contains_particle_accessor_ >> particle_accessor_;

          names_attribute_accessor_ >> attribute_accessor_;

          // Member set.
          //
          inherits_base_set_ >> base_set_;
          base_set_ >> contains_compositor_set_;
          base_set_ >> names_attribute_set_;

          contains_compositor_set_ >> compositor_set_;
          compositor_set_ >> contains_particle_set_;
          contains_particle_set_ >> compositor_set_;
          contains_particle_set_ >> particle_set_;

          names_attribute_set_ >> attribute_set_;
        }

        virtual Void
        traverse (Type& c)
        {
          Boolean he (has<Traversal::Element> (c));
          Boolean ha (has<Traversal::Attribute> (c));
          Boolean restriction (restriction_p (c));

          if (!(!restriction && (he || ha)))
            return;

          String const& name (ename (c));

          os << "// " << name << endl
             << "//" << endl
             << endl;

          if (!restriction && (he || ha))
          {
            // <name>_serializer ()
            //
            if (ha)
              names (c, names_attribute_accessor_);

            if (he)
              contains_compositor (c, contains_compositor_accessor_);

            // serializer ()
            //

            os << inl
               << "void " << name << "::" << endl
               << "serializers (";

            {
              SerializerParamDecl decl (*this, true);
              decl.traverse (c);
            }

            os << ")"
               << "{";

            inherits (c, inherits_base_set_);

            if (ha)
              names (c, names_attribute_set_);

            if (he)
              contains_compositor (c, contains_compositor_set_);

            os << "}";
          }

          // Default c-tor.
          //
          os << inl
             << name << "::" << endl
             << name << " ()" << endl
             << ": ";

          if (!restriction && (he || ha))
          {
            Boolean comma (false);

            if (ha)
            {
              AttributeMemberInit attribute_init (*this);
              Traversal::Names names_attribute_init;

              names_attribute_init >> attribute_init;

              names (c, names_attribute_init);

              comma = attribute_init.comma ();
            }

            if (he)
            {
              Traversal::Compositor compositor_init;
              ParticleMemberInit particle_init (*this, comma);
              Traversal::ContainsCompositor contains_compositor_init;
              Traversal::ContainsParticle contains_particle_init;

              contains_compositor_init >> compositor_init;
              compositor_init >> contains_particle_init;
              contains_particle_init >> compositor_init;
              contains_particle_init >> particle_init;

              contains_compositor (c, contains_compositor_init);
            }
          }

          os << "{"
             << "}";
        }

      private:
        //
        //
        Traversal::Compositor compositor_accessor_;
        ParticleAccessor particle_accessor_;
        Traversal::ContainsCompositor contains_compositor_accessor_;
        Traversal::ContainsParticle contains_particle_accessor_;

        AttributeAccessor attribute_accessor_;
        Traversal::Names names_attribute_accessor_;

        //
        //
        BaseMemberSet base_set_;
        Traversal::Inherits inherits_base_set_;

        Traversal::Compositor compositor_set_;
        ParticleMemberSet particle_set_;
        Traversal::ContainsCompositor contains_compositor_set_;
        Traversal::ContainsParticle contains_particle_set_;

        AttributeMemberSet attribute_set_;
        Traversal::Names names_attribute_set_;
      };
    }

    Void
    generate_serializer_inline (Context& ctx)
    {
      Traversal::Schema schema;

      Traversal::Sources sources;
      Traversal::Names schema_names;

      Namespace ns (ctx);
      Traversal::Names names;

      schema >> sources >> schema;
      schema >> schema_names >> ns >> names;

      List list (ctx);
      Complex complex (ctx);

      names >> list;
      names >> complex;

      schema.dispatch (ctx.schema_root);
    }
  }
}

