#ifndef _B2Q_H
#define _B2Q_H

// only for GBK, GB2312 GB10830

typedef struct b2q_tab_tag
{
	char e;
	wchar_t l;		// lower convert,
	wchar_t u;		// upper convert, with shift pressed
}b2q_tab;

#ifdef OS_LINUX
const b2q_tab cb2q[] = 		// for normal char
{
	{'`',	0x0000FF40,	0x0000FF5E},
	{'1',	0x0000FF11,	0x0000FF01},
	{'2',	0x0000FF12,	0x0000FF20},
	{'3',	0x0000FF13,	0x0000FF03},
	{'4',	0x0000FF14,	0x0000FFE5},
	{'5',	0x0000FF15,	0x0000FF05},
	{'6',	0x0000FF16,	0x0000FF3E},
	{'7',	0x0000FF17,	0x0000FF06},
	{'8',	0x0000FF18,	0x0000FF0A},
	{'9',	0x0000FF19,	0x0000FF08},
	{'0',	0x0000FF10,	0x0000FF09},
	{'-',	0x0000FF0D,	0x0000FF3F},
	{'=',	0x0000FF1D,	0x0000FF0B},
	{'[',	0x0000FF3B,	0x0000FF5B},
	{']',	0x0000FF3D,	0x0000FF5D},
	{'\\',	0x0000FF3C,	0x0000FF5C},
	{';',	0x0000FF1B,	0x0000FF1A},
	{'\'',	0x0000FF07,	0x0000FF02},
	{',',	0x0000FF0C,	0x0000FF1C},
	{'.',	0x0000FF0E,	0x0000FF1E},
	{'/',	0x0000FF0F,	0x0000FF1F},
	{'a',	0x0000FF41,	0x0000FF21},
	{'b',	0x0000FF42,	0x0000FF22},
	{'c',	0x0000FF43,	0x0000FF23},
	{'d',	0x0000FF44,	0x0000FF24},
	{'e',	0x0000FF45,	0x0000FF25},
	{'f',	0x0000FF46,	0x0000FF26},
	{'g',	0x0000FF47,	0x0000FF27},
	{'h',	0x0000FF48,	0x0000FF28},
	{'i',	0x0000FF49,	0x0000FF29},
	{'j',	0x0000FF4A,	0x0000FF2A},
	{'k',	0x0000FF4B,	0x0000FF2B},
	{'l',	0x0000FF4C,	0x0000FF2C},
	{'m',	0x0000FF4D,	0x0000FF2D},
	{'n',	0x0000FF4E,	0x0000FF2E},
	{'o',	0x0000FF4F,	0x0000FF2F},
	{'p',	0x0000FF50,	0x0000FF30},
	{'q',	0x0000FF51,	0x0000FF31},
	{'r',	0x0000FF52,	0x0000FF32},
	{'s',	0x0000FF53,	0x0000FF33},
	{'t',	0x0000FF54,	0x0000FF34},
	{'u',	0x0000FF55,	0x0000FF35},
	{'v',	0x0000FF56,	0x0000FF36},
	{'w',	0x0000FF57,	0x0000FF37},
	{'x',	0x0000FF58,	0x0000FF38},
	{'y',	0x0000FF59,	0x0000FF39},
	{'z',	0x0000FF5A,	0x0000FF3A},
	{0,	00,	00},
};

const b2q_tab sb2q[] =			// for Symbol
{
	{'`',	0x000000B7,	0x0000FF5E},
	{'1',	L'1',		0x0000FF01},
	{'2',	L'2',		0x000025CE},
	{'3',	L'3',		0x0000FF03},
	{'4',	L'4',		0x0000FFE5},
	{'5',	L'5',		0x0000FF05},
	{'6',	L'6',		0x00002026},
	{'7',	L'7',		0x0000203B},
	{'8',	L'8',		0x000000D7},
	{'9',	L'9',		0x0000FF08},
	{'0',	L'0',		0x0000FF09},
	{'-',	0x0000FF0D,	0x00002015},
	{'=',	0x0000FF1D,	0x0000FF0B},
	{'[',	0x00003010,	0x0000300E},
	{']',	0x00003011,	0x0000300F},
	{'\\',	0x000000F7,	0x000000A7},
	{';',	0x0000FF1B,	0x0000FF1A},
	{'\'',	0x00002018,	0x0000201C},		//0x00002019, 0x0000201D
	{',',	0x0000FF0C,	0x0000300A},
	{'.',	0x00003002,	0x0000300B},
	{'/',	0x00003001,	0x0000FF1F},
	{0,	00,	00}
};

const wchar_t char_pair1_1 = 0x00002018;
const wchar_t char_pair1_2 = 0x00002019;
const wchar_t char_pair2_1 = 0x0000201C;
const wchar_t char_pair2_2 = 0x0000201D;
#endif		// OS_LINUX

#ifdef OS_FREEBSD
const b2q_tab cb2q[] = 		// for normal char
{
	{'`',	0x0000a3e0,	0x0000a1ab},
	{'1',	0x0000a3b1,	0x0000a3a1},
	{'2',	0x0000a3b2,	0x0000a3c0},
	{'3',	0x0000a3b3,	0x0000a3a3},
	{'4',	0x0000a3b4,	0x0000a3a4},
	{'5',	0x0000a3b5,	0x0000a3a5},
	{'6',	0x0000a3b6,	0x0000a3de},
	{'7',	0x0000a3b7,	0x0000a3a6},
	{'8',	0x0000a3b8,	0x0000a3aa},
	{'9',	0x0000a3b9,	0x0000a3a8},
	{'0',	0x0000a3b0,	0x0000a3a9},
	{'-',	0x0000a3ad,	0x0000a3df},
	{'=',	0x0000a3bd,	0x0000a3ab},
	{'[',	0x0000a3db,	0x0000a3fb},
	{']',	0x0000a3dd,	0x0000a3fd},
	{'\\',	0x0000a3dc,	0x0000a3fc},
	{';',	0x0000a3bb,	0x0000a3ba},
	{'\'',	0x0000a3a7,	0x0000a3a2},
	{',',	0x0000a3ac,	0x0000a3bc},
	{'.',	0x0000a3ae,	0x0000a3be},
	{'/',	0x0000a3af,	0x0000a3bf},
	{'a',	0x0000a3e1,	0x0000a3c1},
	{'b',	0x0000a3e2,	0x0000a3c2},
	{'c',	0x0000a3e3,	0x0000a3c3},
	{'d',	0x0000a3e4,	0x0000a3c4},
	{'e',	0x0000a3e5,	0x0000a3c5},
	{'f',	0x0000a3e6,	0x0000a3c6},
	{'g',	0x0000a3e7,	0x0000a3c7},
	{'h',	0x0000a3e8,	0x0000a3c8},
	{'i',	0x0000a3e9,	0x0000a3c9},
	{'j',	0x0000a3ea,	0x0000a3ca},
	{'k',	0x0000a3eb,	0x0000a3cb},
	{'l',	0x0000a3ec,	0x0000a3cc},
	{'m',	0x0000a3ed,	0x0000a3cd},
	{'n',	0x0000a3ee,	0x0000a3ce},
	{'o',	0x0000a3ef,	0x0000a3cf},
	{'p',	0x0000a3f0,	0x0000a3d0},
	{'q',	0x0000a3f1,	0x0000a3d1},
	{'r',	0x0000a3f2,	0x0000a3d2},
	{'s',	0x0000a3f3,	0x0000a3d3},
	{'t',	0x0000a3f4,	0x0000a3d4},
	{'u',	0x0000a3f5,	0x0000a3d5},
	{'v',	0x0000a3f6,	0x0000a3d6},
	{'w',	0x0000a3f7,	0x0000a3d7},
	{'x',	0x0000a3f8,	0x0000a3d8},
	{'y',	0x0000a3f9,	0x0000a3d9},
	{'z',	0x0000a3fa,	0x0000a3da},
	{0,	00,	00},
};

const b2q_tab sb2q[] =			// for Symbol
{
	{'`',	0x0000A1A4,	0x0000A1AB},
	{'1',	L'1',		0x0000A3A1},
	{'2',	L'2',		0x0000A1F2},
	{'3',	L'3',		0x0000A3A3},
	{'4',	L'4',		0x0000A3A4},
	{'5',	L'5',		0x0000A3A5},
	{'6',	L'6',		0x0000A1AD},
	{'7',	L'7',		0x0000A1F9},
	{'8',	L'8',		0x0000A1C1},
	{'9',	L'9',		0x0000A3A8},
	{'0',	L'0',		0x0000A3A9},
	{'-',	0x0000A3AD,	0x0000A1AA},
	{'=',	0x0000A3BD,	0x0000A3AB},
	{'[',	0x0000a1be,	0x0000a1ba},
	{']',	0x0000a1bf,	0x0000a1bb},
	{'\\',	0x0000a1c2,	0x0000a1ec},
	{';',	0x0000a3bb,	0x0000a3ba},
	{'\'',	0x0000a1ae,	0x0000a1b0},		// 0x0000a1b1  0x0000a1af
	{',',	0x0000a3ac,	0x0000a1b6},
	{'.',	0x0000a1a3,	0x0000a1b7},
	{'/',	0x0000a1a2,	0x0000a3bf},
	{0,	00,	00}
};
const wchar_t char_pair1_1 = 0x0000a1ae;
const wchar_t char_pair1_2 = 0x0000a1af;
const wchar_t char_pair2_1 = 0x0000a1b0;
const wchar_t char_pair2_2 = 0x0000a1b1;
#endif		// OS_FREEBSD

#endif
