/*
	Copyright (C) 2002 zhang lu

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <X11/Xlib.h>
#include "IMdkit/IMdkit.h"
#include "IMdkit/Xi18n.h"

#include "im.h"
#include "ic.h"
#include "imc.h"

TIC * TIC::focused_ic = NULL;

TIC::TIC(TIM * val)
{
	imc = NULL;

// this line does not worked, so i must add lines below, why??
//	init(IC_RESET);

	memset(&ic_, 0, sizeof(IC));
	im = val;
	on_stat = 0;
}


void TIC::init(int init_mode, TIM * val)
{
	switch (init_mode){
		case IC_CLEAR:
			if (!imc)
				get_imc();
			imc->clear();
			break;

		case IC_RESET:
			if (im == val)
				return;
			if (imc)
				delete imc;
			imc = NULL;
			im = val;
			on_stat = 0;
			break;

		case IC_ERASE:
			memset(&ic_, 0, sizeof(IC));
			if (imc)
				delete imc;
			im = NULL;
			imc = NULL;
			on_stat = 0;
			unset_focus();
			break;
		}
}

TIC::~TIC()
{
	if (imc)
		delete imc;
}

TIMC * TIC::get_imc()
{
	if (!imc && im)
		imc = im->create_imc();

	return imc;
}

void TIC::set_im(TIM * val)
{
	init(IC_RESET, val);
}

void TIC::turn_on()
{
	init(IC_CLEAR, NULL);
	on_stat = 1;
}

void TIC::turn_off()
{
	init(IC_CLEAR, im);
	on_stat = 0;
}

int TIC::alive()
{
	return (int)im;
}
