/**
 * A client-side 802.1x implementation supporting EAP/TLS
 *
 * This code is released under both the GPL version 2 and BSD licenses.
 * Either license may be used.  The respective licenses are found below.
 *
 * Copyright (C) 2002 Bryan D. Payne & Nick L. Petroni Jr.
 * All Rights Reserved
 *
 * --- GPL Version 2 License ---
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * --- BSD License ---
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  - All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by the University of
 *       Maryland at College Park and its contributors.
 *  - Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************
 * The driver function for a Linux application layer EAPOL 
 * implementation
 * File: xsup_debug.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: xsup_debug.h,v 1.8 2004/08/11 04:01:17 chessing Exp $
 * $Date: 2004/08/11 04:01:17 $
 *******************************************************************/
#ifndef XSUP_DEBUG_H_
#define XSUP_DEBUG_H_

#include <netinet/in.h>

#define DEBUG_NORMAL     0

#define NUM_DEBUG_CONFIG     1
#define DEBUG_CONFIG         0x01

#define NUM_DEBUG_STATE      2
#define DEBUG_STATE          0x02

#define NUM_DEBUG_AUTHTYPES  3
#define DEBUG_AUTHTYPES      0x04

#define NUM_DEBUG_INT        4
#define DEBUG_INT            0x08

#define NUM_DEBUG_SNMP       5
#define DEBUG_SNMP           0x10

#define NUM_DEBUG_EVERYTHING 6
#define DEBUG_EVERYTHING     0x20

#define NUM_DEBUG_EXCESSIVE  7
#define DEBUG_EXCESSIVE      0x40

void logfile_setup(char *);
void logfile_cleanup();
void debug_setdaemon(int);
void debug_printf(unsigned char, char *, ...);
void debug_printf_nl(unsigned char, char *, ...);
void debug_hex_printf(unsigned char, u_char *, int);
void debug_hex_dump(unsigned char, u_char *, int);
void debug_set_flags(int);
void debug_alpha_set_flags(char *);
int debug_getlevel();

#endif
