/*******************************************************************
 *
 * File: xsup_get_state.c
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: xsup_get_state.c,v 1.6 2005/08/20 19:06:50 chessing Exp $
 * $Date: 2005/08/20 19:06:50 $
 * $Log: xsup_get_state.c,v $
 * Revision 1.6  2005/08/20 19:06:50  chessing
 * Patch from Carsten Grohmann to fix a few things in xsup_get_state.c.  Also added the ability to define an empty network clause, that will set the card in to encryption disabled mode.  From there, anything short of changing the SSID will be ignored by Xsupplicant.
 *
 * Revision 1.5  2005/08/09 01:39:12  chessing
 * Cleaned out old commit notes from the released version.  Added a few small features including the ability to disable the friendly warnings that are spit out.  (Such as the warning that is displayed when keys aren't rotated after 10 minutes.)  We should also be able to start when the interface is down.  Last, but not least, we can handle empty network configs.  (This may be useful for situations where there isn't a good reason to have a default network defined.)
 *
 *
 *******************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <strings.h>
#include "../../common/gui_interface.h"

void handle_authstate(char *interface, char state)
{
  printf("Interface %s is now in ", interface);

  switch (state)
    {
    case LOGOFF:
      printf("LOGOFF");
      break;
    case DISCONNECTED:
      printf("DISCONNECTED");
      break;
    case CONNECTING:
      printf("CONNECTING");
      break;
    case ACQUIRED:
      printf("ACQUIRED");
      break;
    case AUTHENTICATING:
      printf("AUTHENTICATING");
      break;
    case HELD:
      printf("HELD");
      break;
    case AUTHENTICATED:
      printf("AUTHENTICATED");
      break;
    case RESTART:
      printf("RESTART");
      break;
    case S_FORCE_AUTH:
      printf("FORCED AUTHENTICATED");
      break;
    case S_FORCE_UNAUTH:
      printf("FORCED UNAUTHENTICATED");
      break;
    default:
      printf("UNKNOWN!!!!!!!!!!!!!!!!");
      break;
    }
  printf(" state.\n");
}

int main(int argc, char *argv[])
{
  int skfd, bufptr, dlen;
  u_char buffer[1500], result[256], myint[17];

  if (argc < 2)
    {
      fprintf(stderr, "You need to specify an interface to check.\n");
      exit(1);
    }

  if (is_xsup_running(argv[1]) == FALSE)
    {
      fprintf(stderr, "Error!  XSupplicant must be running to use this " 
              "tool!\n");
      exit(1);
    }

  skfd = gui_interface_connect(argv[1]);
  if (skfd < 1)
    {
      fprintf(stderr, "Error!  Couldn't get a handle to daemon.  (Is the "
              "interface valid? Is Xsupplicant running on it?)\n");
      exit(1);
    }

  bufptr = 0;
  gui_interface_get_state(if_nametoindex(argv[1]), (char *)&buffer, &bufptr);
  
  switch(gui_interface_send_packet(skfd, (char *)&buffer, bufptr))
    {
    case ERR_PKT_BAD:
      fprintf(stderr, "Error!  Response packet appears to be bad!\n");
      gui_interface_disconnect(skfd);
      exit(1);
      break;

    case ERR_SOCK:
      fprintf(stderr, "Error!  There was a socket error!\n");
      gui_interface_disconnect(skfd);
      exit(1);
      break;
    }

  bzero((char *)&buffer, 1500);
  bufptr = 1500;
  gui_interface_get_packet(skfd, (char *)&buffer, &bufptr, TRUE);

  bufptr = 0;

  if (gui_interface_parse_packet((char *)&buffer, &bufptr, (char *)&result,
				 &dlen, (char *)&myint) == ERR_PKT_BAD)
    {
      fprintf(stderr, "The daemon returned an invalid packet!\n");
      gui_interface_disconnect(skfd);
      exit(1);
    }

  handle_authstate(argv[1], result[0]);
  gui_interface_disconnect(skfd);

  return 0;
}
