/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef __CONFIG_SSID_H__
#define __CONFIG_SSID_H__

struct found_ssids {
  char *ssid_name;
  u_char abilities;
  u_char *wpa_ie;
  u_char wpa_ie_len;
  u_char *rsn_ie;
  u_char rsn_ie_len;
  u_char mac[6];
  unsigned int freq;

  struct found_ssids *next;
};

void config_ssid_clear();
void config_ssids_add(char *, u_char, u_char *, u_char, u_char *, u_char, 
		      unsigned int, u_char *);
//void config_ssid_find_desired_ssid_by_priority();
//void config_ssid_find_desired_ssid_by_name(char *);
char *config_ssid_get_desired_ssid();
u_char config_ssid_get_ssid_abilities();
void config_ssid_get_wpa_ie(u_char *, u_char *);
unsigned int config_ssid_get_freq();
u_char *config_ssid_get_mac();
void config_ssid_dump();
#endif
