/*******************************************************************
 * EAPSIM Header
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: eapaka.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

/*******************************************************************
 *
 * The development of the EAP/AKA support was funded by Internet
 * Foundation Austria (http://www.nic.at/ipa)
 *
 *******************************************************************/

#ifndef _EAP_AKA_H_
#define _EAP_AKA_H_

#define EAP_TYPE_AKA   23

#ifdef EAP_SIM_ENABLE

// These are defined in section 8 of Arkko-12
// EAP-AKA Subtype values.
#define AKA_CHALLENGE             1
#define AKA_AUTHENTICATION_REJECT 2
#define AKA_SYNC_FAILURE          4
#define AKA_IDENTITY              5
#define AKA_NOTIFICATION         12
#define AKA_REAUTHENTICATION     13
#define AKA_CLIENT_ERROR         14

// EAP-AKA Subtype Attribute values
#define AT_RAND               1
#define AT_AUTN               2
#define AT_RES                3
#define AT_AUTS               4
#define AT_PADDING            6
#define AT_PERMANENT_ID_REQ  10
#define AT_MAC               11
#define AT_NOTIFICATION      12
#define AT_ANY_ID_REQ        13
#define AT_IDENTITY          14
#define AT_FULLAUTH_ID_REQ   17
#define AT_COUNTER           19
#define AT_COUNTER_TOO_SMALL 20
#define AT_NONCE_S           21
#define AT_CLIENT_ERROR_CODE 22

#define AT_IV               129
#define AT_ENCR_DATA        130
#define AT_NEXT_PSEUDONYM   132
#define AT_NEXT_REAUTH_ID   133
#define AT_CHECKCODE        134
#define AT_RESULT_IND       135

// These are values that can be returned by AT_NOTIFICATION
// These are defined in 7.19.
#define GENERAL_FAILURE_POST_AUTH       0
#define GENERAL_FAILURE_PRE_AUTH    16384
#define USER_AUTHENTICATED          32768
#define USER_DENIED                  1026
#define USER_NO_SUBSCRIPTION         1031

struct aka_eaptypedata {
  int numrands;
  char *nonce_mt;
  char random_num[16];
  char autn[16];
  char res[16];
  int reslen;
  char K_encr[16], K_aut[16], msk[64], emsk[64];
  char *keyingMaterial;
  SCARDCONTEXT scntx;
  SCARDHANDLE shdl;
  char card_mode;
  char *readers;
};  

// Get the IMSI as the username.
int eapaka_get_username(struct interface_data *);

// Initalizes Function for EAPOL package
int eapaka_setup(struct generic_eap_data *);

// Function to handle packets and manage state.
int eapaka_process(struct generic_eap_data *, u_char *, int, u_char *, int *);

// Return keying material.
int eapaka_get_keys(struct interface_data *);

//Clean up after ourselves.
int eapaka_cleanup(struct generic_eap_data *);

int eapaka_failed(struct generic_eap_data *);

#endif
#endif
