/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: xsup_ipc.h
 *
 * Authors: Chris.Hessing@utah.edu, Terry.Simons@utah.edu
 *
 *******************************************************************/

#ifndef _XSUP_IPC_H_
#define _XSUP_IPC_H_

#include <inttypes.h>

#define AUTH_STATE    1  // Get authentication state (get (or pushed) only!)
#define CONFIG        2  // Get or set a config value.
#define SNMP          3  // Get or set an SNMP value.
#define INTERFACES    4  // Get interface list (get only!)
#define PROFILE       5  // Get or Set a profile by name.
#define NOTIFY        6  // Send a notification message.
#define TEMPPASSWORD  7  // Get a password that was pushed in from a GUI client

#define ERROR_MSG   255  // Return an error message.

#define ACK           1
#define NACK          0

#define DONT_CLEAR    0
#define CLEAR         1

#define IPC_RESPONSE  0
#define IPC_GET       1
#define IPC_SET       2   // When a message is pushed from the daemon, to the
                          // client, it should be sent using an IPC_SET 
                          // command.  This will allow the client to know
                          // that this message is unsolicited.

#define IPC_VERSION_NUM  2

struct ipc_cmd {
  uint8_t version;     // Version number of this command.
  uint8_t int_idx;     // The interface index this command is for.
  uint8_t attribute;   // The value we want.
  uint8_t getset;      // Should we get, or set this value.
  uint8_t len;         // The length of this answer minus the bytes that make
                       // up the header.
  // Value comes after that.
} __attribute__((__packed__));

int xsup_ipc_init(struct interface_data *);
int xsup_ipc_send_all(char *, int);
void xsup_ipc_send_auth_state(struct interface_data *);
void xsup_ipc_send_eap_notify(struct interface_data *, char *);
void xsup_ipc_process(struct interface_data *);
void xsup_ipc_cleanup();
void xsup_ipc_debug(char *, int);
int xsup_ipc_gui_prompt(char *, char *, char *, char *);

#endif
