/*******************************************************************
 * Event core implementation.
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: event_core.c
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: event_core.c,v 1.3 2005/10/17 03:56:53 chessing Exp $
 * $Date: 2005/10/17 03:56:53 $
 * $Log: event_core.c,v $
 * Revision 1.3  2005/10/17 03:56:53  chessing
 * Updates to the libxsupconfig library.  It no longer relies on other source from the main tree, so it can be used safely in other code with problems.
 *
 * Revision 1.2  2005/09/14 02:50:44  chessing
 * Major updates.  Auto association now works.  Started to rewrite the rtnetlink pieces using iwlib from the wireless tools to avoid compatibility issues.  As a result, getting the WPA and RSN IEs via the IWEVGENIE event no longer works for some reason, but the old style using IWEVCUSTOM events should still work like a champ.
 *
 * Revision 1.1  2005/09/05 01:00:34  chessing
 * Major overhaul to most of the state machines in Xsupplicant.  Also added additional error messages to the TLS functions to try to debug the one of the problems reported on the list.  Basic testing shows this new code to be more stable than previous code, but it needs more testing.
 *
 *
 *******************************************************************/

#include <stdio.h>
#include <inttypes.h>

#include "profile.h"
#include "xsupconfig.h"
#include "wireless_sm.h"
#include "event_core.h"
#include "cardif/core.h"
#include "eapol.h"
#include "timer.h"

/***********************************************************************
 *
 * Initialize the event core. -- This should make any generic calls needed
 * to set up the OS to provide us with events.
 *
 ***********************************************************************/
void event_core_init()
{
  ext_event_init();    // Init any event generation pieces that may be
                       // needed for the OS we are running on.
}

/***********************************************************************
 *
 * Deinit the event core. -- This should call deinit functions for anything
 * that was inited in event_core_init()
 *
 ***********************************************************************/
void event_core_deinit()
{
  ext_event_deinit();  // Clean up after ourselves.
}

/***********************************************************************
 *
 * Process any events that we may have received.  This includes processing
 * frames that may have come in.  There should be *NOTHING* OS specific
 * in this code!!!  OS specific calls should be held under 
 * cardif/<OS>/<OS>_core.c/h!
 *
 ***********************************************************************/
void event_core(struct interface_data *ctx)
{
  // Process any external events. 
  if (!TEST_FLAG(ctx->flags, IS_WIRELESS)) ext_event_core(ctx, NULL);

  eapol_execute(ctx);

  // Tick the clock (if needed)
  if (ctx->tick) timer_tick(ctx);
}
