Captures and holds incoming TCP connections using no local per-connection
resources. Connections are accepted, but immediately switched to the persist
state (0 byte window), in which the remote side stops sending data and asks to
continue every 60-240 seconds. Attempts to close the connection are ignored,
forcing the remote side to time out the connection in 12-24 minutes.

This offers similar functionality to LaBrea
<http://www.hackbusters.net/LaBrea/> but does not require dedicated hardware or
IPs. Any TCP port that you would normally DROP or REJECT can instead become a
tarpit.

To tarpit connections to TCP port 80 destined for the current machine:
.IP
\-A INPUT \-p tcp \-m tcp \-\-dport 80 \-j TARPIT
.PP
To significantly slow down Code Red/Nimda-style scans of unused address space,
forward unused ip addresses to a Linux box not acting as a router (e.g. "ip
route 10.0.0.0 255.0.0.0 ip.of.linux.box" on a Cisco), enable IP forwarding on
the Linux box, and add:
.IP
\-A FORWARD \-p tcp \-j TARPIT
.IP
\-A FORWARD \-j DROP
.PP
NOTE:
If you use the conntrack module while you are using TARPIT, you should also use
the NOTRACK target, or the kernel will unnecessarily allocate resources for
each TARPITted connection. To TARPIT incoming connections to the standard IRC
port while using conntrack, you could:
.IP
\-t raw \-A PREROUTING \-p tcp \-\-dport 6667 \-j NOTRACK
.IP
\-A INPUT \-p tcp \-\-dport 6667 \-j TARPIT
