/*****************************************************************************\

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

\*****************************************************************************/


#include "icon_zoomout.xpm"
#include "icon_quit.xpm"
#include "icon_reset.xpm"
#include "icon_left.xpm"
#include "icon_right.xpm"
#include "icon_up.xpm"
#include "icon_down.xpm"
#include "icon_prefs.xpm"
#include "icon_search.xpm"
#include "icon_disaster.xpm"


const char *zoomOutText = "<img source=\"zoomout\"> "
    "Click this button to zoom out one level.";
const char *resetText = "<img source=\"icon_reset\"> "
    "Click this button to return to the entire world map from a zoomed view.";
const char *prefsText = "<img source=\"prefs\"> "
    "Click this button to change program preferences.  Right now that's just "
    "the position format and the station colors.  Maybe more later...";
const char *quitText = "<img source=\"icon_quit\"> "
    "Click this button to <b><em>exit</em></b> from the program.  "
    "You can also use the <b>Quit</b> entry in the <b>File</b> menu.";
const char *leftText = "<img source=\"icon_left\"> "
    "Click this button to move the map view <b>west</b>.  You can also use "
    "left arrow cursor key.";
const char *upText = "<img source=\"icon_up\"> "
    "Click this button to move the map view <b>north</b>.  You can also use "
    "the up arrow cursor key.";
const char *downText = "<img source=\"icon_down\"> "
    "Click this button to move the map view <b>south</b>.  You can also use "
    "the down cursor key.";
const char *rightText = "<img source=\"icon_right\"> "
    "Click this button to move the map view <b>east</b>.  You can also use "
    "the right cursor key.";
const char *searchText = "<img source=\"search\"> "
    "Click this button to perform a text search for a station.  The search is "
    "case insensitive and will search for the entered combination of "
    "characters anywhere in the station name.  The search will not begin "
    "until at least three characters have been entered.";
const char *mapText = "Pressing the left mouse button in the map will "
    "zoom in on that location in the map.  You can zoom in up to five "
    "times.  The <img source=\"icon_left\"> or <img source=\"icon_right\"> "
    "key will move the map <b>west</b> or <b>east</b>.  The "
    "<img source=\"icon_up\"> or <img source=\"icon_down\"> key will move the "
    "map <b>north</b> or <b>south</b>.  You may also move around in the map "
    "using the arrow buttons or the arrow keys.  Pressing the middle mouse "
    "button will bring up the <b>Tide Constituent Editor</b> dialog for the "
    "nearest station.  Pressing the right mouse button will bring up the "
    "<b>Tide Constituent Editor</b> dialog and allow you to enter a new "
    "station.";
const char *disasterText = "<img source=\"disaster\"> "
    "Click this button if you have totally hosed the file somehow.  This is "
    "equivalent to one massive <b>undo</b>.";
const char *bGrpText = "Select the format in which you want all geographic "
    "positions to be displayed.";
const char *refColorButtonText = "Click this button to change the color that "
    "is used to plot the reference tide station locations.  After selecting a "
    "color the stations will be redrawn.";
const char *subColorButtonText = "Click this button to change the color that "
    "is used to plot the subordinate tide station locations.  After selecting "
    "a color the stations will be redrawn.";
const char *closePrefsText = "Click this button to close the preferences "
    "dialog.";
const char *searchNameText = "Type a string to be searched for in the "
    "station names.  The search will be case insensitive and will not begin "
    "until at least three characters have been entered.";
const char *searchListText = "This is the list of stations that were returned "
    "from the station search.  Click on a station name to highlight it on the "
    "map.  Double clicking on a name will bring up the Tide Constituent "
    "editor.";
const char *closeSearchText = "Click this button to close the station search "
    "dialog.";
